/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageReconstructor;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageCorruptionDetector;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.Option;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.shaded.org.apache.commons.cli.PosixParser;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    private static final String HELP_OPT = "-h";
    private static final String HELP_LONGOPT = "--help";
    public static final Logger LOG = LoggerFactory.getLogger(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * ReverseXML: This processor takes an XML file and creates a\n    binary fsimage containing the same elements.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n    -format formats the output result in a human-readable fashion\n     rather than a number of bytes. (false by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n    It does not support secure mode nor HTTPS.\n  * Delimited (experimental): Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n    -sp print storage policy, used by delimiter only.\n    -ec print erasure coding policy, used by delimiter only.\n    -m  defines multiThread to process sub-sections, \n    used by delimiter only.\n  * DetectCorruption: Detect potential corruption of the image by\n    selectively loading parts of it and actively searching for\n    inconsistencies. Outputs a summary of the found corruptions\n    in a delimited format.\n    Note that the check is not exhaustive, and only catches\n    missing nodes during the namespace reconstruction.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage or XML file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n                       If the input file was an XML file, we\n                       will also create an <outputFile>.md5 file.\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|\n                       ReverseXML|Web|Delimited|DetectCorruption)\n                       The default is Web.\n-addr <arg>            Specify the address(host:port) to listen.\n                       (localhost:5978 by default). This option is\n                       used with Web processor.\n-maxSize <arg>         Specify the range [0, maxSize] of file sizes\n                       to be analyzed in bytes (128GB by default).\n                       This option is used with FileDistribution processor.\n-step <arg>            Specify the granularity of the distribution in bytes\n                       (2MB by default). This option is used\n                       with FileDistribution processor.\n-format                Format the output result in a human-readable fashion rather\n                       than a number of bytes. (false by default).\n                       This option is used with FileDistribution processor.\n-delimiter <arg>       Delimiting string to use with Delimited or \n                       DetectCorruption processor. \n-sp                    Whether to print storage policy (default is false). \n                       Is used by Delimited processor only. \n-ec                    Whether to print erasure coding policy (default is false). \n                       Is used by Delimited processor only. \n-t,--temp <arg>        Use temporary dir to cache intermediate\n                       result to generate DetectCorruption or\n                       Delimited outputs. If not set, the processor\n                       constructs the namespace in memory \n                       before outputting text.\n-m,--multiThread <arg> Use multiThread to process sub-sections.\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        Option optionInputFile = Option.builder((String)"i").required().hasArgs().longOpt("inputFile").build();
        options.addOption(optionInputFile);
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("format", false, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("sp", false, "");
        options.addOption("ec", false, "");
        options.addOption("t", "temp", true, "");
        options.addOption("m", "multiThread", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        ExitUtil.terminate((int)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String[] args) throws Exception {
        CommandLine cmd;
        Options options = OfflineImageViewerPB.buildOptions();
        if (args.length == 0) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        if (args.length == 1 && OfflineImageViewerPB.isHelpOption(args[0])) {
            OfflineImageViewerPB.printUsage();
            return 0;
        }
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: ");
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        if (cmd.hasOption("h")) {
            OfflineImageViewerPB.printUsage();
            return -1;
        }
        String inputFile = cmd.getOptionValue("i");
        String processor = cmd.getOptionValue("p", "Web");
        String outputFile = cmd.getOptionValue("o", "-");
        String delimiter = cmd.getOptionValue("delimiter", "\t");
        String tempPath = cmd.getOptionValue("t", "");
        int threads = Integer.parseInt(cmd.getOptionValue("m", "1"));
        Configuration conf = new Configuration();
        PrintStream out = null;
        try {
            out = outputFile.equals("-") || "REVERSEXML".equalsIgnoreCase(processor) ? System.out : new PrintStream(outputFile, "UTF-8");
            switch (StringUtils.toUpperCase((String)processor)) {
                case "FILEDISTRIBUTION": {
                    long maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                    int step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                    boolean formatOutput = cmd.hasOption("format");
                    try (RandomAccessFile r = new RandomAccessFile(inputFile, "r");){
                        new FileDistributionCalculator(conf, maxSize, step, formatOutput, out).visit(r);
                        break;
                    }
                }
                case "XML": {
                    try (RandomAccessFile r = new RandomAccessFile(inputFile, "r");){
                        new PBImageXmlWriter(conf, out).visit(r);
                        break;
                    }
                }
                case "REVERSEXML": {
                    try {
                        OfflineImageReconstructor.run(inputFile, outputFile);
                    }
                    catch (Exception e) {
                        System.err.println("OfflineImageReconstructor failed: " + e.getMessage());
                        e.printStackTrace(System.err);
                        ExitUtil.terminate((int)1);
                    }
                    break;
                }
                case "WEB": {
                    String addr = cmd.getOptionValue("addr", "localhost:5978");
                    try (WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)addr), conf);){
                        viewer.start(inputFile);
                        break;
                    }
                }
                case "DELIMITED": {
                    boolean printStoragePolicy = cmd.hasOption("sp");
                    boolean printECPolicy = cmd.hasOption("ec");
                    try (PBImageDelimitedTextWriter writer = new PBImageDelimitedTextWriter(out, delimiter, tempPath, printStoragePolicy, printECPolicy, threads, outputFile, conf);){
                        writer.visit(inputFile);
                        break;
                    }
                }
                case "DETECTCORRUPTION": {
                    try (PBImageCorruptionDetector detector = new PBImageCorruptionDetector(out, delimiter, tempPath);){
                        detector.visit(inputFile);
                        break;
                    }
                }
                default: {
                    System.err.println("Invalid processor specified : " + processor);
                    OfflineImageViewerPB.printUsage();
                    int n = -1;
                    return n;
                }
            }
            if (out != null && out.checkError()) {
                System.err.println("CRITICAL FAILURE: PrintStream reported a write error (e.g., Disk Full).");
                int n = -1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (EOFException e) {
            System.err.println("Input file ended unexpectedly. Exiting");
        }
        catch (IOException e) {
            System.err.println("Encountered exception.  Exiting: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            if (out != null && out != System.out) {
                out.close();
            }
        }
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }

    private static boolean isHelpOption(String arg) {
        return arg.equalsIgnoreCase(HELP_OPT) || arg.equalsIgnoreCase(HELP_LONGOPT);
    }
}

