/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.PrintStream;
import java.util.Arrays;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.diskbalancer.command.CancelCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ExecuteCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.HelpCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.PlanCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.QueryCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ReportCommand;
import org.apache.hadoop.shaded.org.apache.commons.cli.BasicParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.Option;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBalancerCLI
extends Configured
implements Tool {
    public static final String PLAN = "plan";
    public static final String OUTFILE = "out";
    public static final String HELP = "help";
    public static final String THRESHOLD = "thresholdPercentage";
    public static final String BANDWIDTH = "bandwidth";
    public static final String MAXERROR = "maxerror";
    public static final String EXECUTE = "execute";
    public static final String SKIPDATECHECK = "skipDateCheck";
    public static final String REPORT = "report";
    public static final String TOP = "top";
    public static final int DEFAULT_TOP = 100;
    public static final String NODE = "node";
    public static final String VERBOSE = "v";
    public static final int PLAN_VERSION = 1;
    public static final String QUERY = "query";
    public static final String CANCEL = "cancel";
    public static final String BEFORE_TEMPLATE = "%s.before.json";
    public static final String PLAN_TEMPLATE = "%s.plan.json";
    private static final Logger LOG = LoggerFactory.getLogger(DiskBalancerCLI.class);
    private static final Options PLAN_OPTIONS = new Options();
    private static final Options EXECUTE_OPTIONS = new Options();
    private static final Options QUERY_OPTIONS = new Options();
    private static final Options HELP_OPTIONS = new Options();
    private static final Options CANCEL_OPTIONS = new Options();
    private static final Options REPORT_OPTIONS = new Options();
    private final PrintStream printStream;
    private Command currentCommand = null;

    public DiskBalancerCLI(Configuration conf) {
        this(conf, System.out);
    }

    public DiskBalancerCLI(Configuration conf, PrintStream printStream) {
        super(conf);
        this.printStream = printStream;
    }

    public static void main(String[] argv) throws Exception {
        DiskBalancerCLI shell = new DiskBalancerCLI((Configuration)new HdfsConfiguration());
        int res = 0;
        try {
            res = ToolRunner.run((Tool)shell, (String[])argv);
        }
        catch (Exception ex) {
            String msg = String.format("Exception thrown while running %s.", DiskBalancerCLI.class.getSimpleName());
            LOG.error(msg, (Throwable)ex);
            res = 1;
        }
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = this.getOpts();
        CommandLine cmd = this.parseArgs(args, opts);
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length > 2) {
            throw new HadoopIllegalArgumentException("Invalid or extra Arguments: " + Arrays.toString(Arrays.copyOfRange(cmdArgs, 2, cmdArgs.length)));
        }
        return this.dispatch(cmd);
    }

    private Options getOpts() {
        Options opts = new Options();
        this.addPlanCommands(opts);
        this.addHelpCommands(opts);
        this.addExecuteCommands(opts);
        this.addQueryCommands(opts);
        this.addCancelCommands(opts);
        this.addReportCommands(opts);
        return opts;
    }

    public static Options getPlanOptions() {
        return PLAN_OPTIONS;
    }

    public static Options getHelpOptions() {
        return HELP_OPTIONS;
    }

    public static Options getExecuteOptions() {
        return EXECUTE_OPTIONS;
    }

    public static Options getQueryOptions() {
        return QUERY_OPTIONS;
    }

    public static Options getCancelOptions() {
        return CANCEL_OPTIONS;
    }

    public static Options getReportOptions() {
        return REPORT_OPTIONS;
    }

    private void addPlanCommands(Options opt) {
        Option plan = Option.builder().longOpt(PLAN).desc("Hostname, IP address or UUID of datanode for which a plan is created.").hasArg().build();
        DiskBalancerCLI.getPlanOptions().addOption(plan);
        opt.addOption(plan);
        Option outFile = Option.builder().longOpt(OUTFILE).hasArg().desc("Local path of file to write output to, if not specified defaults will be used.").build();
        DiskBalancerCLI.getPlanOptions().addOption(outFile);
        opt.addOption(outFile);
        Option bandwidth = Option.builder().longOpt(BANDWIDTH).hasArg().desc("Maximum disk bandwidth (MB/s) in integer to be consumed by diskBalancer. e.g. 10 MB/s.").build();
        DiskBalancerCLI.getPlanOptions().addOption(bandwidth);
        opt.addOption(bandwidth);
        Option threshold = Option.builder().longOpt(THRESHOLD).hasArg().desc("Percentage of data skew that is tolerated before disk balancer starts working. For example, if total data on a 2 disk node is 100 GB then disk balancer calculates the expected value on each disk, which is 50 GB. If the tolerance is 10% then data on a single disk needs to be more than 60 GB (50 GB + 10% tolerance value) for Disk balancer to balance the disks.").build();
        DiskBalancerCLI.getPlanOptions().addOption(threshold);
        opt.addOption(threshold);
        Option maxError = Option.builder().longOpt(MAXERROR).hasArg().desc("Describes how many errors can be tolerated while copying between a pair of disks.").build();
        DiskBalancerCLI.getPlanOptions().addOption(maxError);
        opt.addOption(maxError);
        Option verbose = Option.builder().longOpt(VERBOSE).desc("Print out the summary of the plan on console").build();
        DiskBalancerCLI.getPlanOptions().addOption(verbose);
        opt.addOption(verbose);
    }

    private void addHelpCommands(Options opt) {
        Option help = Option.builder().longOpt(HELP).optionalArg(true).desc("valid commands are plan | execute | query | cancel | report").build();
        DiskBalancerCLI.getHelpOptions().addOption(help);
        opt.addOption(help);
    }

    private void addExecuteCommands(Options opt) {
        Option execute = Option.builder().longOpt(EXECUTE).hasArg().desc("Takes a plan file and submits it for execution by the datanode.").build();
        DiskBalancerCLI.getExecuteOptions().addOption(execute);
        Option skipDateCheck = Option.builder().longOpt(SKIPDATECHECK).desc("skips the date check and force execute the plan").build();
        DiskBalancerCLI.getExecuteOptions().addOption(skipDateCheck);
        opt.addOption(execute);
        opt.addOption(skipDateCheck);
    }

    private void addQueryCommands(Options opt) {
        Option query = Option.builder().longOpt(QUERY).hasArg().desc("Queries the disk balancer status of given datanode(s).").build();
        DiskBalancerCLI.getQueryOptions().addOption(query);
        opt.addOption(query);
        Option verbose = Option.builder().longOpt(VERBOSE).desc("Prints details of the plan that is being executed on the datanode(s).").build();
        DiskBalancerCLI.getQueryOptions().addOption(verbose);
    }

    private void addCancelCommands(Options opt) {
        Option cancel = Option.builder().longOpt(CANCEL).hasArg().desc("Cancels a running plan using a plan file.").build();
        DiskBalancerCLI.getCancelOptions().addOption(cancel);
        opt.addOption(cancel);
        Option node = Option.builder().longOpt(NODE).hasArg().desc("Cancels a running plan using a plan ID and hostName").build();
        DiskBalancerCLI.getCancelOptions().addOption(node);
        opt.addOption(node);
    }

    private void addReportCommands(Options opt) {
        Option report = Option.builder().longOpt(REPORT).desc("List nodes that will benefit from running DiskBalancer.").build();
        DiskBalancerCLI.getReportOptions().addOption(report);
        opt.addOption(report);
        Option top = Option.builder().longOpt(TOP).hasArg().desc("specify the number of nodes to be listed which has data imbalance.").build();
        DiskBalancerCLI.getReportOptions().addOption(top);
        opt.addOption(top);
        Option node = Option.builder().longOpt(NODE).hasArg().desc("Datanode address, it can be DataNodeID, IP or hostname.").build();
        DiskBalancerCLI.getReportOptions().addOption(node);
        opt.addOption(node);
    }

    private CommandLine parseArgs(String[] argv, Options opts) throws ParseException {
        BasicParser parser = new BasicParser();
        return parser.parse(opts, argv);
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dispatch(CommandLine cmd) throws Exception {
        try (Command dbCmd = null;){
            if (cmd.hasOption(PLAN)) {
                dbCmd = new PlanCommand(this.getConf(), this.printStream);
            }
            if (cmd.hasOption(EXECUTE)) {
                dbCmd = new ExecuteCommand(this.getConf());
            }
            if (cmd.hasOption(QUERY)) {
                dbCmd = new QueryCommand(this.getConf(), this.printStream);
            }
            if (cmd.hasOption(CANCEL)) {
                dbCmd = new CancelCommand(this.getConf());
            }
            if (cmd.hasOption(REPORT)) {
                dbCmd = new ReportCommand(this.getConf(), this.printStream);
            }
            if (cmd.hasOption(HELP)) {
                dbCmd = new HelpCommand(this.getConf());
            }
            if (dbCmd == null) {
                dbCmd = new HelpCommand(this.getConf());
                dbCmd.execute(null);
                int n = 1;
                return n;
            }
            dbCmd.execute(cmd);
            int n = 0;
            return n;
        }
    }
}

