/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.visitor;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.visitor.NamespaceVisitor;

public class INodeCountVisitor
implements NamespaceVisitor {
    private final INodeSet inodes = new INodeSet();

    public static Counts countTree(INode root) {
        return new INodeCountVisitor().count(root);
    }

    @Override
    public NamespaceVisitor.INodeVisitor getDefaultVisitor() {
        return new NamespaceVisitor.INodeVisitor(){

            @Override
            public void visit(INode iNode, int snapshot) {
                INodeCountVisitor.this.inodes.put(iNode, snapshot);
            }
        };
    }

    private Counts count(INode root) {
        root.accept(this, 0x7FFFFFFE);
        return this.inodes;
    }

    static class INodeSet
    implements Counts {
        private final ConcurrentMap<SetElement, SetElement> map = new ConcurrentHashMap<SetElement, SetElement>();

        INodeSet() {
        }

        int put(INode inode, int snapshot) {
            SetElement key = new SetElement(inode);
            SetElement previous = this.map.putIfAbsent(key, key);
            SetElement current = previous != null ? previous : key;
            return current.incrementAndGet();
        }

        @Override
        public int getCount(INode inode) {
            SetElement key = new SetElement(inode);
            SetElement value = (SetElement)this.map.get(key);
            return value != null ? value.getCount() : 0;
        }
    }

    public static interface Counts {
        public int getCount(INode var1);
    }

    private static class SetElement {
        private final INode inode;
        private final AtomicInteger count = new AtomicInteger();

        SetElement(INode inode) {
            this.inode = inode;
        }

        int getCount() {
            return this.count.get();
        }

        int incrementAndGet() {
            return this.count.incrementAndGet();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SetElement that = (SetElement)obj;
            return this.inode.getId() == that.inode.getId();
        }

        public int hashCode() {
            return Long.hashCode(this.inode.getId());
        }
    }
}

