/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.fgl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FSNLockBenchmarkThroughput
extends Configured
implements Tool {
    private final FileSystem fileSystem;

    public FSNLockBenchmarkThroughput(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void benchmark(Path basePath, int readWriteRatio, int testingCount, int numClients) throws Exception {
        ArrayList<Path> readingPaths = new ArrayList<Path>();
        for (int i = 0; i < 30; ++i) {
            Path path = new Path(basePath, "reading_" + i);
            this.internalWriteFile(this.fileSystem, path, true, null);
            readingPaths.add(path);
        }
        HashMap<String, Integer> detailInfo = new HashMap<String, Integer>();
        List<Callable<Void>> tasks = this.buildTasks(this.fileSystem, basePath, testingCount, readWriteRatio, readingPaths, detailInfo);
        Collections.shuffle(tasks);
        long startTime = System.currentTimeMillis();
        ExecutorService executors = Executors.newFixedThreadPool(numClients);
        try {
            List<Future<Void>> futures = executors.invokeAll(tasks);
            for (Future<Void> f : futures) {
                f.get();
            }
            long endTime = System.currentTimeMillis();
            System.out.println("The Benchmark result is: " + tasks.size() + " tasks with readWriteRatio " + readWriteRatio + " completed, taking " + (endTime - startTime) + "(ms)");
            detailInfo.forEach((k, v) -> System.out.println("\t operationName:" + k + ", testCount:" + v));
        }
        finally {
            executors.shutdown();
            executors.shutdownNow();
            for (Path path : readingPaths) {
                this.fileSystem.delete(path, false);
            }
        }
    }

    private void internalWriteFile(FileSystem fs, Path path, boolean writeData, HashMap<String, Integer> detailInfo) throws IOException {
        try (FSDataOutputStream outputStream = fs.create(path);){
            this.incOp(detailInfo, "create");
            this.incOp(detailInfo, "complete");
            byte[] data = new byte[1024];
            ThreadLocalRandom.current().nextBytes(data);
            if (writeData) {
                outputStream.write(data);
                this.incOp(detailInfo, "addBlock");
            }
        }
    }

    private void internalAppendFile(FileSystem fs, Path path, boolean writeData, HashMap<String, Integer> detailInfo) throws IOException {
        try (FSDataOutputStream outputStream = fs.append(path);){
            this.incOp(detailInfo, "append");
            this.incOp(detailInfo, "complete");
            byte[] data = new byte[1024];
            ThreadLocalRandom.current().nextBytes(data);
            if (writeData) {
                outputStream.write(data);
            }
        }
    }

    private Callable<Void> getListing(FileSystem fs, Path path, HashMap<String, Integer> detailInfo) {
        return () -> {
            fs.listStatus(path);
            this.incOp(detailInfo, "getListing");
            return null;
        };
    }

    private synchronized void incOp(HashMap<String, Integer> detailInfo, String opName) {
        if (detailInfo != null) {
            int value = detailInfo.getOrDefault(opName, 0);
            detailInfo.put(opName, value + 1);
        }
    }

    private Callable<Void> getBlockLocation(FileSystem fs, Path path, HashMap<String, Integer> detailInfo) {
        return () -> {
            fs.getFileBlockLocations(path, 0L, Long.MAX_VALUE);
            this.incOp(detailInfo, "getBlockLocation");
            return null;
        };
    }

    private Callable<Void> getFileInfo(FileSystem fs, Path path, HashMap<String, Integer> detailInfo) {
        return () -> {
            fs.getFileStatus(path);
            this.incOp(detailInfo, "getFileInfo");
            return null;
        };
    }

    private Callable<Void> writeAndDeleteFile(FileSystem fs, Path path, HashMap<String, Integer> detailInfo) {
        return () -> {
            this.internalWriteFile(fs, path, false, detailInfo);
            fs.delete(path, false);
            this.incOp(detailInfo, "delete");
            return null;
        };
    }

    private Callable<Void> otherWriteOperation(FileSystem fs, Path path, Path renameTargetPath, HashMap<String, Integer> detailInfo) {
        return () -> {
            this.internalWriteFile(fs, path, false, detailInfo);
            this.internalAppendFile(fs, path, true, detailInfo);
            fs.rename(path, renameTargetPath);
            this.incOp(detailInfo, "rename");
            fs.setPermission(renameTargetPath, FsPermission.getDirDefault());
            this.incOp(detailInfo, "setPermission");
            fs.setOwner(renameTargetPath, "mock_user", "mock_group");
            this.incOp(detailInfo, "setOwner");
            fs.setReplication(renameTargetPath, (short)4);
            this.incOp(detailInfo, "setReplication");
            fs.delete(renameTargetPath, false);
            this.incOp(detailInfo, "delete");
            return null;
        };
    }

    private List<Callable<Void>> buildTasks(FileSystem fs, Path basePath, int testingCount, int readWriteRatio, ArrayList<Path> readingPaths, HashMap<String, Integer> detailInfo) {
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < testingCount; ++i) {
            for (int j = 0; j < 10; ++j) {
                Path path = new Path(basePath, "write_" + i + "_" + j);
                tasks.add(this.writeAndDeleteFile(fs, path, detailInfo));
            }
            Path srcPath = new Path(basePath, "src_" + i + "_" + System.nanoTime());
            Path targetPath = new Path(basePath, "target_" + i + "_" + System.nanoTime());
            tasks.add(this.otherWriteOperation(fs, srcPath, targetPath, detailInfo));
            for (int j = 0; j < readWriteRatio * 50; ++j) {
                int opNumber = ThreadLocalRandom.current().nextInt(5);
                int pathIndex = ThreadLocalRandom.current().nextInt(readingPaths.size());
                Path path = readingPaths.get(pathIndex);
                if (opNumber <= 1) {
                    tasks.add(this.getFileInfo(fs, path, detailInfo));
                    continue;
                }
                if (opNumber <= 3) {
                    tasks.add(this.getBlockLocation(fs, path, detailInfo));
                    continue;
                }
                tasks.add(this.getListing(fs, path, detailInfo));
            }
        }
        return tasks;
    }

    public int run(String[] args) throws Exception {
        String basePath = "/tmp/fsnlock/benchmark/throughput";
        int readWriteRatio = 20;
        int testingCount = 100;
        int numClients = 100;
        if (args.length >= 4) {
            basePath = args[0];
            try {
                readWriteRatio = Integer.parseInt(args[1]);
                if (readWriteRatio <= 0) {
                    FSNLockBenchmarkThroughput.printUsage("Invalid readWrite ratio: " + readWriteRatio);
                }
            }
            catch (NumberFormatException e) {
                FSNLockBenchmarkThroughput.printUsage("Invalid readWrite ratio: " + e.getMessage());
            }
            try {
                testingCount = Integer.parseInt(args[2]);
                if (testingCount <= 0) {
                    FSNLockBenchmarkThroughput.printUsage("Invalid testing count: " + testingCount);
                }
            }
            catch (NumberFormatException e) {
                FSNLockBenchmarkThroughput.printUsage("Invalid testing count: " + e.getMessage());
            }
            try {
                numClients = Integer.parseInt(args[3]);
                if (numClients <= 0) {
                    FSNLockBenchmarkThroughput.printUsage("Invalid num of clients: " + numClients);
                }
            }
            catch (NumberFormatException e) {
                FSNLockBenchmarkThroughput.printUsage("Invalid num of clients: " + e.getMessage());
            }
        } else {
            FSNLockBenchmarkThroughput.printUsage(null);
        }
        this.benchmark(new Path(basePath), readWriteRatio, testingCount, numClients);
        return 0;
    }

    private static void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.err.println("Usage: FSNLockBenchmarkThroughput <base path> <read write ratio> <testing count> <num clients>");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        int res = ToolRunner.run((Configuration)conf, (Tool)new FSNLockBenchmarkThroughput(fs), (String[])args);
        System.exit(res);
    }
}

