/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdfs.server.namenode.FsImageValidation;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INodeReferenceValidation {
    public static final Logger LOG = LoggerFactory.getLogger(INodeReferenceValidation.class);
    private static final AtomicReference<INodeReferenceValidation> INSTANCE = new AtomicReference();
    private final ReferenceSet<INodeReference.WithCount> withCounts = new ReferenceSet<INodeReference.WithCount>(INodeReference.WithCount.class);
    private final ReferenceSet<INodeReference.WithName> withNames = new ReferenceSet<INodeReference.WithName>(INodeReference.WithName.class);
    private final ReferenceSet<INodeReference.DstReference> dstReferences = new ReferenceSet<INodeReference.DstReference>(INodeReference.DstReference.class);

    public static void start() {
        INSTANCE.compareAndSet(null, new INodeReferenceValidation());
        FsImageValidation.Cli.println("%s started", INodeReferenceValidation.class.getSimpleName());
    }

    public static void end(AtomicInteger errorCount) {
        INodeReferenceValidation instance = INSTANCE.getAndSet(null);
        if (instance == null) {
            return;
        }
        int initCount = errorCount.get();
        instance.assertReferences(errorCount);
        FsImageValidation.Cli.println("%s ended successfully: %d error(s) found.", INodeReferenceValidation.class.getSimpleName(), errorCount.get() - initCount);
    }

    static <REF extends INodeReference> void add(REF ref, Class<REF> clazz) {
        INodeReferenceValidation validation = INSTANCE.get();
        if (validation != null) {
            boolean added = validation.getReferences(clazz).add(ref);
            Preconditions.checkState((boolean)added);
            LOG.trace("add {}: {}", clazz, (Object)ref.toDetailString());
        }
    }

    static <REF extends INodeReference> void remove(REF ref, Class<REF> clazz) {
        INodeReferenceValidation validation = INSTANCE.get();
        if (validation != null) {
            boolean removed = validation.getReferences(clazz).remove(ref);
            Preconditions.checkState((boolean)removed);
            LOG.trace("remove {}: {}", clazz, (Object)ref.toDetailString());
        }
    }

    <REF extends INodeReference> ReferenceSet<REF> getReferences(Class<REF> clazz) {
        if (clazz == INodeReference.WithCount.class) {
            return this.withCounts;
        }
        if (clazz == INodeReference.WithName.class) {
            return this.withNames;
        }
        if (clazz == INodeReference.DstReference.class) {
            return this.dstReferences;
        }
        throw new IllegalArgumentException("References not found for " + clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertReferences(AtomicInteger errorCount) {
        int p = Runtime.getRuntime().availableProcessors();
        LOG.info("Available Processors: {}", (Object)p);
        ExecutorService service = Executors.newFixedThreadPool(p);
        TimerTask checkProgress = new TimerTask(){

            @Override
            public void run() {
                LOG.info("ASSERT_REFERENCES Progress: {}, {}, {}", new Object[]{INodeReferenceValidation.this.dstReferences, INodeReferenceValidation.this.withCounts, INodeReferenceValidation.this.withNames});
            }
        };
        Timer t = new Timer();
        t.scheduleAtFixedRate(checkProgress, 0L, 1000L);
        try {
            this.dstReferences.submit(errorCount, service);
            this.withCounts.submit(errorCount, service);
            this.withNames.submit(errorCount, service);
            this.dstReferences.waitForFutures();
            this.withCounts.waitForFutures();
            this.withNames.waitForFutures();
        }
        catch (Throwable e) {
            FsImageValidation.Cli.printError("Failed to assertReferences", e);
        }
        finally {
            service.shutdown();
            t.cancel();
        }
    }

    static <REF extends INodeReference> List<Task<REF>> createTasks(List<REF> references, AtomicInteger errorCount) {
        LinkedList<Task<REF>> tasks = new LinkedList<Task<REF>>();
        Iterator<REF> i = references.iterator();
        while (i.hasNext()) {
            tasks.add(new Task<REF>(i, errorCount));
        }
        return tasks;
    }

    static class ReferenceSet<REF extends INodeReference> {
        private final Class<REF> clazz;
        private final List<REF> references = new LinkedList<REF>();
        private volatile List<Task<REF>> tasks;
        private volatile List<Future<Integer>> futures;
        private final AtomicInteger taskCompleted = new AtomicInteger();

        ReferenceSet(Class<REF> clazz) {
            this.clazz = clazz;
        }

        boolean add(REF ref) {
            return this.references.add(ref);
        }

        boolean remove(REF ref) {
            Iterator<REF> i = this.references.iterator();
            while (i.hasNext()) {
                if (i.next() != ref) continue;
                i.remove();
                return true;
            }
            return false;
        }

        void submit(AtomicInteger errorCount, ExecutorService service) throws InterruptedException {
            int size = this.references.size();
            this.tasks = INodeReferenceValidation.createTasks(this.references, errorCount);
            FsImageValidation.Cli.println("Submitting %d tasks for validating %s %s(s)", this.tasks.size(), FsImageValidation.Util.toCommaSeparatedNumber(size), this.clazz.getSimpleName());
            this.futures = service.invokeAll(this.tasks);
        }

        void waitForFutures() throws Exception {
            for (Future<Integer> f : this.futures) {
                f.get();
                this.taskCompleted.incrementAndGet();
            }
        }

        double getTaskCompletedPercent() {
            List<Task<REF>> t = this.tasks;
            return t == null ? 0.0 : (t.isEmpty() ? 100.0 : (double)this.taskCompleted.get() * 100.0 / (double)this.tasks.size());
        }

        public String toString() {
            return String.format("%s %.1f%%", this.clazz.getSimpleName(), this.getTaskCompletedPercent());
        }
    }

    static class Task<REF extends INodeReference>
    implements Callable<Integer> {
        static final int BATCH_SIZE = 100000;
        private final List<REF> references = new LinkedList<REF>();
        private final AtomicInteger errorCount;

        Task(Iterator<REF> i, AtomicInteger errorCount) {
            for (int n = 0; i.hasNext() && n < 100000; ++n) {
                this.references.add((INodeReference)i.next());
                i.remove();
            }
            this.errorCount = errorCount;
        }

        @Override
        public Integer call() throws Exception {
            for (INodeReference ref : this.references) {
                try {
                    ref.assertReferences();
                }
                catch (Throwable t) {
                    FsImageValidation.Cli.printError(this.errorCount, "%s", t);
                }
            }
            return this.references.size();
        }
    }
}

