/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class FSXAttrBaseTest {
    protected static MiniDFSCluster dfsCluster;
    protected static Configuration conf;
    private static int pathCount;
    protected static Path path;
    protected static Path filePath;
    protected static Path rawPath;
    protected static Path rawFilePath;
    protected static final String name1 = "user.a1";
    protected static final byte[] value1;
    protected static final byte[] newValue1;
    protected static final String name2 = "user.a2";
    protected static final byte[] value2;
    protected static final String name3 = "user.a3";
    protected static final String name4 = "user.a4";
    protected static final String raw1 = "raw.a1";
    protected static final String raw2 = "raw.a2";
    protected static final String security1 = "security.hdfs.unreadable.by.superuser";
    private static final int MAX_SIZE;
    protected FileSystem fs;
    private static final UserGroupInformation BRUCE;
    private static final UserGroupInformation DIANA;

    @BeforeAll
    public static void init() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 3);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", MAX_SIZE);
        FSXAttrBaseTest.initCluster(true);
    }

    @AfterAll
    public static void shutdown() {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        path = new Path("/p" + ++pathCount);
        filePath = new Path(path, "file");
        rawPath = new Path("/.reserved/raw/p" + pathCount);
        rawFilePath = new Path(rawPath, "file");
        this.initFileSystem();
    }

    @AfterEach
    public void destroyFileSystems() {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        this.fs = null;
    }

    @Test
    @Timeout(value=120L)
    public void testCreateXAttr() throws Exception {
        HashMap expectedXAttrs = Maps.newHashMap();
        expectedXAttrs.put(name1, value1);
        expectedXAttrs.put(name2, null);
        expectedXAttrs.put(security1, null);
        this.doTestCreateXAttr(filePath, expectedXAttrs);
        expectedXAttrs.put(raw1, value1);
        this.doTestCreateXAttr(rawFilePath, expectedXAttrs);
    }

    private void doTestCreateXAttr(Path usePath, Map<String, byte[]> expectedXAttrs) throws Exception {
        byte[] val;
        DFSTestUtil.createFile(this.fs, usePath, 8192L, (short)1, 65261L);
        this.fs.setXAttr(usePath, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(usePath);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(usePath, name1);
        xattrs = this.fs.getXAttrs(usePath);
        Assertions.assertEquals((int)xattrs.size(), (int)0);
        this.fs.setXAttr(usePath, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        try {
            this.fs.setXAttr(usePath, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
            Assertions.fail((String)"Creating xattr which already exists should fail.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fs.removeXAttr(usePath, name1);
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            this.fs.setXAttr(usePath, ent.getKey(), ent.getValue(), EnumSet.of(XAttrSetFlag.CREATE));
        }
        xattrs = this.fs.getXAttrs(usePath);
        Assertions.assertEquals((int)xattrs.size(), (int)expectedXAttrs.size());
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            val = ent.getValue() == null ? new byte[]{} : ent.getValue();
            Assertions.assertArrayEquals((byte[])val, (byte[])((byte[])xattrs.get(ent.getKey())));
        }
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(usePath);
        Assertions.assertEquals((int)xattrs.size(), (int)expectedXAttrs.size());
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            val = ent.getValue() == null ? new byte[]{} : ent.getValue();
            Assertions.assertArrayEquals((byte[])val, (byte[])((byte[])xattrs.get(ent.getKey())));
        }
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(usePath);
        Assertions.assertEquals((int)xattrs.size(), (int)expectedXAttrs.size());
        for (Map.Entry<String, byte[]> ent : expectedXAttrs.entrySet()) {
            val = ent.getValue() == null ? new byte[]{} : ent.getValue();
            Assertions.assertArrayEquals((byte[])val, (byte[])((byte[])xattrs.get(ent.getKey())));
        }
        this.fs.delete(usePath, false);
    }

    @Test
    @Timeout(value=120L)
    public void testReplaceXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.REPLACE));
        Map xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        try {
            this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.REPLACE));
            Assertions.fail((String)"Replacing xattr which does not exist should fail.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, null, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
    }

    @Test
    @Timeout(value=120L)
    public void testSetXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        Map xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        try {
            this.fs.setXAttr(path, null, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assertions.fail((String)"Setting xattr with null name should fail.");
        }
        catch (NullPointerException e) {
            GenericTestUtils.assertExceptionContains("XAttr name cannot be null", e);
        }
        catch (RemoteException e) {
            GenericTestUtils.assertExceptionContains("Required param xattr.name for op: SETXATTR is null or empty", e);
        }
        try {
            this.fs.setXAttr(path, "user.", value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assertions.fail((String)"Setting xattr with empty name should fail.");
        }
        catch (RemoteException e) {
            Assertions.assertEquals((Object)e.getClassName(), (Object)HadoopIllegalArgumentException.class.getCanonicalName(), (String)("Unexpected RemoteException: " + e));
            GenericTestUtils.assertExceptionContains("XAttr name cannot be empty", e);
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("XAttr name cannot be empty", e);
        }
        try {
            this.fs.setXAttr(path, "a1", value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assertions.fail((String)"Setting xattr with invalid name prefix or without name prefix should fail.");
        }
        catch (RemoteException e) {
            Assertions.assertEquals((Object)e.getClassName(), (Object)HadoopIllegalArgumentException.class.getCanonicalName(), (String)("Unexpected RemoteException: " + e));
            GenericTestUtils.assertExceptionContains("XAttr name must be prefixed", e);
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("XAttr name must be prefixed", e);
        }
        this.fs.setXAttr(path, name1, value1);
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1);
        this.fs.setXAttr(path, name2, value2);
        this.fs.setXAttr(path, name3, null);
        try {
            this.fs.setXAttr(path, name4, null);
            Assertions.fail((String)"Setting xattr should fail if total number of xattrs for inode exceeds max limit.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Cannot add additional XAttr", e);
        }
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        this.fs.removeXAttr(path, name3);
        String longName = "user.0123456789abcdefX0123456789abcdefX0123456789abcdef";
        try {
            this.fs.setXAttr(path, longName, null);
            Assertions.fail((String)"Setting xattr should fail if name is too long.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("XAttr is too big", e);
            GenericTestUtils.assertExceptionContains("total size is 50", e);
        }
        byte[] longValue = new byte[MAX_SIZE];
        try {
            this.fs.setXAttr(path, "user.a", longValue);
            Assertions.fail((String)"Setting xattr should fail if value is too long.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("XAttr is too big", e);
            GenericTestUtils.assertExceptionContains("total size is 38", e);
        }
        String name = "user.111";
        byte[] value = new byte[MAX_SIZE - 3];
        this.fs.setXAttr(path, name, value);
    }

    @Test
    @Timeout(value=120L)
    public void testGetXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        byte[] theValue = this.fs.getXAttr(path, "USER.a2");
        Assertions.assertArrayEquals((byte[])value2, (byte[])theValue);
        try {
            byte[] value = this.fs.getXAttr(path, name3);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("At least one of the attributes provided was not found.", e);
        }
        ArrayList names = Lists.newArrayList();
        names.add(name1);
        names.add(name2);
        names.add(name3);
        try {
            Map xattrs = this.fs.getXAttrs(path, (List)names);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("At least one of the attributes provided was not found.", e);
        }
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        try {
            byte[] xattr = this.fs.getXAttr(path, "wackynamespace.foo");
            Assertions.fail((String)"expected IOException");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'", e);
        }
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        this.fs.setXAttr(path, "trusted.foo", "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(path, "trusted.foo");
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("User doesn't have permission", e);
        }
        this.fs.setXAttr(path, name1, "1234".getBytes());
        this.fs.setPermission(path, new FsPermission(448));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(path, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        final Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)448));
        this.fs.setXAttr(childDir, name1, "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(452));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(449));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(452));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                byte[] xattr = userFs.getXAttr(childDir, FSXAttrBaseTest.name1);
                return null;
            }
        });
    }

    @Test
    @Timeout(value=120L)
    public void testRemoveXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name3, null, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        Map xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        this.fs.removeXAttr(path, name3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testRemoveXAttrPermissions() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name3, null, EnumSet.of(XAttrSetFlag.CREATE));
        try {
            this.fs.removeXAttr(path, name2);
            this.fs.removeXAttr(path, name2);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("No matching attributes found", e);
        }
        String expectedExceptionString = "An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'";
        try {
            this.fs.removeXAttr(path, "wackynamespace.foo");
            Assertions.fail((String)"expected IOException");
        }
        catch (RemoteException e) {
            Assertions.assertEquals((Object)e.getClassName(), (Object)HadoopIllegalArgumentException.class.getCanonicalName(), (String)("Unexpected RemoteException: " + e));
            GenericTestUtils.assertExceptionContains("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'", e);
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'", e);
        }
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        this.fs.setXAttr(path, "trusted.foo", "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(path, "trusted.foo");
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("User doesn't have permission", e);
        }
        finally {
            this.fs.removeXAttr(path, "trusted.foo");
        }
        this.fs.setPermission(path, new FsPermission(448));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(path, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        final Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)448));
        this.fs.setXAttr(childDir, name1, "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(452));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(449));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        this.fs.setPermission(childDir, new FsPermission(454));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                userFs.removeXAttr(childDir, FSXAttrBaseTest.name1);
                return null;
            }
        });
    }

    @Test
    @Timeout(value=120L)
    public void testRenameFileWithXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        Path renamePath = new Path(path.toString() + "-rename");
        this.fs.rename(path, renamePath);
        Map xattrs = this.fs.getXAttrs(renamePath);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(renamePath, name1);
        this.fs.removeXAttr(renamePath, name2);
    }

    @Test
    @Timeout(value=120L)
    public void testListXAttrs() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        try {
            this.fs.listXAttrs(path);
            Assertions.fail((String)"expected FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains("cannot find", e);
        }
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        List noXAttrs = this.fs.listXAttrs(path);
        Assertions.assertTrue((noXAttrs.size() == 0 ? 1 : 0) != 0, (String)"XAttrs were found?");
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        List xattrNames = this.fs.listXAttrs(path);
        Assertions.assertTrue((boolean)xattrNames.contains(name1));
        Assertions.assertTrue((boolean)xattrNames.contains(name2));
        Assertions.assertTrue((xattrNames.size() == 2 ? 1 : 0) != 0);
        this.fs.setPermission(path, new FsPermission(452));
        final Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)448));
        this.fs.setXAttr(childDir, name1, "1234".getBytes());
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.listXAttrs(childDir);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(450));
        try {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.listXAttrs(childDir);
                    return null;
                }
            });
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Permission denied", e);
        }
        this.fs.setPermission(path, new FsPermission(449));
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    DistributedFileSystem userFs = dfsCluster.getFileSystem();
                    userFs.listXAttrs(childDir);
                    Assertions.fail((String)"expected AccessControlException");
                }
                catch (AccessControlException ace) {
                    GenericTestUtils.assertExceptionContains("Permission denied", ace);
                }
                return null;
            }
        });
        this.fs.setPermission(childDir, new FsPermission(452));
        this.fs.setXAttr(childDir, "trusted.myxattr", "1234".getBytes());
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                List xattrs = userFs.listXAttrs(childDir);
                Assertions.assertTrue((xattrs.size() == 1 ? 1 : 0) != 0);
                Assertions.assertEquals((Object)FSXAttrBaseTest.name1, xattrs.get(0));
                return null;
            }
        });
        Assertions.assertTrue((this.fs.listXAttrs(childDir).size() == 2 ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=120L)
    public void testCleanupXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(path);
        Assertions.assertEquals((int)xattrs.size(), (int)2);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    @Test
    @Timeout(value=120L)
    public void testXAttrAcl() throws Exception {
        Map xattrs;
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setOwner(path, BRUCE.getUserName(), null);
        FileSystem fsAsBruce = this.createFileSystem(BRUCE);
        FileSystem fsAsDiana = this.createFileSystem(DIANA);
        fsAsBruce.setXAttr(path, name1, value1);
        try {
            xattrs = fsAsDiana.getXAttrs(path);
            Assertions.fail((String)"Diana should not have read access to get xattrs");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        fsAsBruce.modifyAclEntries(path, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, DIANA.getUserName(), FsAction.READ)}));
        xattrs = fsAsDiana.getXAttrs(path);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        try {
            fsAsDiana.removeXAttr(path, name1);
            Assertions.fail((String)"Diana should not have write access to remove xattrs");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            fsAsDiana.setXAttr(path, name2, value2);
            Assertions.fail((String)"Diana should not have write access to set xattrs");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        fsAsBruce.modifyAclEntries(path, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, DIANA.getUserName(), FsAction.ALL)}));
        fsAsDiana.setXAttr(path, name2, value2);
        Assertions.assertArrayEquals((byte[])value2, (byte[])((byte[])fsAsDiana.getXAttrs(path).get(name2)));
        fsAsDiana.removeXAttr(path, name1);
        fsAsDiana.removeXAttr(path, name2);
    }

    @Test
    @Timeout(value=120L)
    public void testRawXAttrs() throws Exception {
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        byte[] value = this.fs.getXAttr(rawPath, raw1);
        Assertions.assertArrayEquals((byte[])value, (byte[])value1);
        Map xattrs = this.fs.getXAttrs(rawPath);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(raw1)));
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(rawPath, raw1, newValue1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(rawPath);
        Assertions.assertEquals((int)xattrs.size(), (int)1);
        Assertions.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(raw1)));
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(rawPath, raw2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        List xattrNames = this.fs.listXAttrs(rawPath);
        Assertions.assertTrue((boolean)xattrNames.contains(raw1));
        Assertions.assertTrue((boolean)xattrNames.contains(raw2));
        Assertions.assertTrue((xattrNames.size() == 2 ? 1 : 0) != 0);
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.removeXAttr(rawPath, raw2);
        this.fs.setXAttr(rawPath, raw1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(rawPath, raw2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        xattrNames = this.fs.listXAttrs(path);
        Assertions.assertTrue((xattrNames.size() == 0 ? 1 : 0) != 0);
        this.fs.removeXAttr(rawPath, raw1);
        this.fs.removeXAttr(rawPath, raw2);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                try {
                    userFs.setXAttr(path, FSXAttrBaseTest.raw1, value1);
                    Assertions.fail((String)"setXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.setXAttr(rawPath, FSXAttrBaseTest.raw1, value1);
                    Assertions.fail((String)"setXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.getXAttrs(rawPath);
                    Assertions.fail((String)"getXAttrs should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.getXAttrs(path);
                    Assertions.fail((String)"getXAttrs should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.getXAttr(rawPath, FSXAttrBaseTest.raw1);
                    Assertions.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.getXAttr(path, FSXAttrBaseTest.raw1);
                    Assertions.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.fs.setXAttr(rawPath, raw1, value1);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                try {
                    userFs.getXAttr(rawPath, FSXAttrBaseTest.raw1);
                    Assertions.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.getXAttr(path, FSXAttrBaseTest.raw1);
                    Assertions.fail((String)"getXAttr should have thrown");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.listXAttrs(path);
                    Assertions.fail((String)"listXAttr should have thrown AccessControlException");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                try {
                    userFs.listXAttrs(rawPath);
                    Assertions.fail((String)"listXAttr should have thrown AccessControlException");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
        this.fs.setPermission(path, new FsPermission(489));
        Path childDir = new Path(path, "child" + pathCount);
        FileSystem.mkdirs((FileSystem)this.fs, (Path)childDir, (FsPermission)FsPermission.createImmutable((short)452));
        final Path rawChildDir = new Path("/.reserved/raw" + childDir.toString());
        this.fs.setXAttr(rawChildDir, raw1, value1);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                List xattrs = userFs.listXAttrs(rawChildDir);
                Assertions.assertEquals((int)1, (int)xattrs.size());
                Assertions.assertEquals((Object)FSXAttrBaseTest.raw1, xattrs.get(0));
                return null;
            }
        });
        this.fs.removeXAttr(rawPath, raw1);
        Path parentPath = new Path("/foo");
        this.fs.mkdirs(parentPath);
        this.fs.setOwner(parentPath, "user", "mygroup");
        this.fs.setPermission(parentPath, new FsPermission("701"));
        final Path childPath = new Path("/foo/bar");
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem dfs = dfsCluster.getFileSystem();
                DFSTestUtil.createFile((FileSystem)dfs, childPath, 1024L, (short)1, 65261L);
                dfs.setPermission(childPath, new FsPermission("740"));
                return null;
            }
        });
        final Path rawChildPath = new Path("/.reserved/raw" + childPath.toString());
        this.fs.setXAttr(new Path("/.reserved/raw/foo/bar"), raw1, value1);
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem dfs = dfsCluster.getFileSystem();
                byte[] xattr = dfs.getXAttr(rawChildPath, FSXAttrBaseTest.raw1);
                Assertions.assertEquals((Object)Arrays.toString(value1), (Object)Arrays.toString(xattr));
                return null;
            }
        });
        UserGroupInformation fakeUser = UserGroupInformation.createUserForTesting((String)"fakeUser", (String[])new String[]{"fakeGroup"});
        fakeUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem dfs = dfsCluster.getFileSystem();
                try {
                    dfs.getXAttr(path, FSXAttrBaseTest.raw1);
                    Assertions.fail((String)"should have thrown AccessControlException");
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    @Test
    @Timeout(value=120L)
    public void testUnreadableBySuperuserXAttr() throws Exception {
        this.doTestUnreadableBySuperuserXAttr(this.fs, true);
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"mygroup"});
        user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                DistributedFileSystem userFs = dfsCluster.getFileSystem();
                FSXAttrBaseTest.this.doTestUnreadableBySuperuserXAttr((FileSystem)userFs, false);
                return null;
            }
        });
    }

    private void doTestUnreadableBySuperuserXAttr(FileSystem userFs, boolean expectOpenFailure) throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)511));
        DFSTestUtil.createFile(userFs, filePath, 8192L, (short)1, 65261L);
        try {
            this.doTUBSXAInt(userFs, expectOpenFailure);
            userFs.delete(filePath, false);
        }
        finally {
            this.fs.delete(path, true);
        }
    }

    private void doTUBSXAInt(FileSystem userFs, boolean expectOpenFailure) throws Exception {
        try {
            userFs.setXAttr(path, security1, null, EnumSet.of(XAttrSetFlag.CREATE));
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Can only set 'security.hdfs.unreadable.by.superuser' on a file", e);
        }
        userFs.setXAttr(filePath, security1, null, EnumSet.of(XAttrSetFlag.CREATE));
        this.verifySecurityXAttrExists(userFs);
        userFs.setXAttr(filePath, security1, null, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        this.verifySecurityXAttrExists(userFs);
        try {
            userFs.removeXAttr(filePath, security1);
            Assertions.fail((String)"Removing security xattr should fail.");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains("The xattr 'security.hdfs.unreadable.by.superuser' can not be deleted.", e);
        }
        this.verifySecurityXAttrExists(userFs);
        try {
            userFs.setXAttr(filePath, security1, value1, EnumSet.of(XAttrSetFlag.REPLACE));
            Assertions.fail((String)"Should have thrown on attempt to set value");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains("Values are not allowed", e);
        }
        List xattrNames = userFs.listXAttrs(filePath);
        Assertions.assertTrue((boolean)xattrNames.contains(security1));
        Assertions.assertTrue((xattrNames.size() == 1 ? 1 : 0) != 0);
        this.verifyFileAccess(userFs, expectOpenFailure);
        Path toPath = new Path(filePath.toString() + "x");
        userFs.rename(filePath, toPath);
        userFs.rename(toPath, filePath);
    }

    private void verifySecurityXAttrExists(FileSystem userFs) throws Exception {
        try {
            Map xattrs = userFs.getXAttrs(filePath);
            Assertions.assertEquals((int)1, (int)xattrs.size());
            Assertions.assertNotNull(xattrs.get(security1));
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])userFs.getXAttr(filePath, security1), (String)"expected empty byte[] from getXAttr");
        }
        catch (AccessControlException e) {
            Assertions.fail((String)"getXAttrs failed but expected it to succeed");
        }
    }

    private void verifyFileAccess(FileSystem userFs, boolean expectOpenFailure) throws Exception {
        try {
            userFs.open(filePath).read();
            Assertions.assertFalse((boolean)expectOpenFailure, (String)"open succeeded but expected it to fail");
        }
        catch (AccessControlException e) {
            Assertions.assertTrue((boolean)expectOpenFailure, (String)"open failed but expected it to succeed");
        }
    }

    protected FileSystem createFileSystem() throws Exception {
        return dfsCluster.getFileSystem();
    }

    protected FileSystem createFileSystem(UserGroupInformation user) throws Exception {
        return DFSTestUtil.getFileSystemAs(user, conf);
    }

    private void initFileSystem() throws Exception {
        this.fs = this.createFileSystem();
    }

    protected static void initCluster(boolean format) throws Exception {
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        dfsCluster.waitActive();
    }

    protected static void restart(boolean checkpoint) throws Exception {
        NameNode nameNode = dfsCluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        FSXAttrBaseTest.shutdown();
        FSXAttrBaseTest.initCluster(false);
    }

    static {
        pathCount = 0;
        value1 = new byte[]{49, 50, 51};
        newValue1 = new byte[]{49, 49, 49};
        value2 = new byte[]{55, 56, 57};
        MAX_SIZE = security1.length();
        BRUCE = UserGroupInformation.createUserForTesting((String)"bruce", (String[])new String[0]);
        DIANA = UserGroupInformation.createUserForTesting((String)"diana", (String[])new String[0]);
    }
}

