/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.XAttrStorage;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfyManager;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.util.Lists;

final class FSDirSatisfyStoragePolicyOp {
    private FSDirSatisfyStoragePolicyOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus satisfyStoragePolicy(FSDirectory fsd, BlockManager bm, String src, boolean logRetryCache) throws IOException {
        INodesInPath iip;
        assert (fsd.getFSNamesystem().hasWriteLock(RwLockMode.FS));
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.writeLock();
        try {
            INode inode;
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            if (fsd.isPermissionEnabled()) {
                fsd.checkPathAccess(pc, iip, FsAction.WRITE);
            }
            if ((inode = FSDirectory.resolveLastINode(iip)).isFile() && inode.asFile().numBlocks() == 0) {
                if (NameNode.LOG.isInfoEnabled()) {
                    NameNode.LOG.info("Skipping satisfy storage policy on path:{} as this file doesn't have any blocks!", (Object)inode.getFullPathName());
                }
            } else if (FSDirSatisfyStoragePolicyOp.inodeHasSatisfyXAttr(inode)) {
                NameNode.LOG.warn("Cannot request to call satisfy storage policy on path: " + inode.getFullPathName() + ", as this file/dir was already called for satisfying storage policy.");
            } else {
                XAttr satisfyXAttr = XAttrHelper.buildXAttr((String)"user.hdfs.sps");
                List<XAttr> xAttrs = Arrays.asList(satisfyXAttr);
                List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
                List<XAttr> newXAttrs = FSDirXAttrOp.setINodeXAttrs(fsd, existingXAttrs, xAttrs, EnumSet.of(XAttrSetFlag.CREATE));
                XAttrStorage.updateINodeXAttrs(inode, newXAttrs, iip.getLatestSnapshotId());
                fsd.getEditLog().logSetXAttrs(src, xAttrs, logRetryCache);
                StoragePolicySatisfyManager spsManager = fsd.getBlockManager().getSPSManager();
                if (spsManager != null) {
                    spsManager.addPathId(inode.getId());
                }
            }
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    static boolean unprotectedSatisfyStoragePolicy(INode inode, FSDirectory fsd) {
        if (inode.isFile() && inode.asFile().numBlocks() == 0) {
            return false;
        }
        StoragePolicySatisfyManager spsManager = fsd.getBlockManager().getSPSManager();
        if (spsManager != null) {
            spsManager.addPathId(inode.getId());
        }
        return true;
    }

    private static boolean inodeHasSatisfyXAttr(INode inode) {
        XAttrFeature f = inode.getXAttrFeature();
        return inode.isFile() && f != null && f.getXAttr("user.hdfs.sps") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeSPSXattr(FSDirectory fsd, INode inode, XAttr spsXAttr) throws IOException {
        try {
            fsd.writeLock();
            List<XAttr> existingXAttrs = XAttrStorage.readINodeXAttrs(inode);
            existingXAttrs.remove(spsXAttr);
            XAttrStorage.updateINodeXAttrs(inode, existingXAttrs, INodesInPath.fromINode(inode).getLatestSnapshotId());
            ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
            xAttrs.add(spsXAttr);
            fsd.getEditLog().logRemoveXAttrs(inode.getFullPathName(), xAttrs, false);
        }
        finally {
            fsd.writeUnlock();
        }
    }
}

