/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.Time;

class FSDirRenameOp {
    FSDirRenameOp() {
    }

    @Deprecated
    static RenameResult renameToInt(FSDirectory fsd, FSPermissionChecker pc, String src, String dst, boolean logRetryCache) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: " + src + " to " + dst);
        }
        INodesInPath srcIIP = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE_LINK);
        INodesInPath dstIIP = fsd.resolvePath(pc, dst, FSDirectory.DirOp.CREATE_LINK);
        dstIIP = FSDirRenameOp.dstForRenameTo(srcIIP, dstIIP);
        return FSDirRenameOp.renameTo(fsd, pc, srcIIP, dstIIP, logRetryCache);
    }

    private static Pair<Optional<QuotaCounts>, Optional<QuotaCounts>> verifyQuotaForRename(FSDirectory fsd, INodesInPath src, INodesInPath dst) throws QuotaExceededException {
        Optional<Object> srcDelta = Optional.empty();
        Optional<Object> dstDelta = Optional.empty();
        if (!fsd.getFSNamesystem().isImageLoaded() || fsd.shouldSkipQuotaChecks()) {
            return Pair.of(srcDelta, dstDelta);
        }
        int i = 0;
        while (src.getINode(i) == dst.getINode(i)) {
            ++i;
        }
        BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
        INode dstParent = dst.getINode(-2);
        boolean isSrcSetSp = src.getLastINode().isSetStoragePolicy();
        byte storagePolicyID = isSrcSetSp ? src.getLastINode().getLocalStoragePolicyID() : dstParent.getStoragePolicyID();
        QuotaCounts delta = src.getLastINode().computeQuotaUsage(bsps, storagePolicyID, false, 0x7FFFFFFE);
        QuotaCounts srcQuota = new QuotaCounts.Builder().quotaCount(delta).build();
        srcDelta = Optional.of(srcQuota);
        INode dstINode = dst.getLastINode();
        if (dstINode != null) {
            QuotaCounts counts = dstINode.computeQuotaUsage(bsps);
            QuotaCounts dstQuota = new QuotaCounts.Builder().quotaCount(counts).build();
            dstDelta = Optional.of(dstQuota);
            delta.subtract(counts);
        }
        FSDirectory.verifyQuota(dst, dst.length() - 1, delta, src.getINode(i - 1));
        return Pair.of(srcDelta, dstDelta);
    }

    static void verifyFsLimitsForRename(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP) throws FSLimitException.PathComponentTooLongException, FSLimitException.MaxDirectoryItemsExceededException {
        byte[] dstChildName = dstIIP.getLastLocalName();
        String parentPath = dstIIP.getParentPath();
        fsd.verifyMaxComponentLength(dstChildName, parentPath);
        if (srcIIP.getINode(-2) != dstIIP.getINode(-2)) {
            fsd.verifyMaxDirItems(dstIIP.getINode(-2).asDirectory(), parentPath);
        }
    }

    @Deprecated
    static INodesInPath renameForEditLog(FSDirectory fsd, String src, String dst, long timestamp) throws IOException {
        INodesInPath srcIIP = fsd.getINodesInPath(src, FSDirectory.DirOp.WRITE_LINK);
        INodesInPath dstIIP = fsd.getINodesInPath(dst, FSDirectory.DirOp.WRITE_LINK);
        dstIIP = FSDirRenameOp.dstForRenameTo(srcIIP, dstIIP);
        return FSDirRenameOp.unprotectedRenameTo(fsd, srcIIP, dstIIP, timestamp);
    }

    private static INodesInPath dstForRenameTo(INodesInPath srcIIP, INodesInPath dstIIP) throws IOException {
        INode dstINode = dstIIP.getLastINode();
        if (dstINode != null && dstINode.isDirectory()) {
            byte[] childName = srcIIP.getLastLocalName();
            INode childINode = dstINode.asDirectory().getChild(childName, dstIIP.getPathSnapshotId());
            dstIIP = INodesInPath.append(dstIIP, childINode, childName);
        }
        return dstIIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static INodesInPath unprotectedRenameTo(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP, long timestamp) throws IOException {
        assert (fsd.hasWriteLock());
        INode srcInode = srcIIP.getLastINode();
        ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
        try {
            FSDirRenameOp.validateRenameSource(fsd, srcIIP, snapshottableDirs);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (IOException ignored) {
            return null;
        }
        String src = srcIIP.getPath();
        String dst = dstIIP.getPath();
        if (dst.equals(src)) {
            return dstIIP;
        }
        try {
            FSDirRenameOp.validateDestination(src, dst, srcInode);
        }
        catch (IOException ignored) {
            return null;
        }
        if (dstIIP.getLastINode() != null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists");
            return null;
        }
        INode dstParent = dstIIP.getINode(-2);
        if (dstParent == null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist");
            return null;
        }
        FSDirRenameOp.validateNestSnapshot(fsd, src, dstParent.asDirectory(), snapshottableDirs);
        FSDirRenameOp.checkUnderSameSnapshottableRoot(fsd, srcIIP, dstIIP);
        fsd.ezManager.checkMoveValidity(srcIIP, dstIIP);
        FSDirRenameOp.verifyFsLimitsForRename(fsd, srcIIP, dstIIP);
        Pair<Optional<QuotaCounts>, Optional<QuotaCounts>> countPair = FSDirRenameOp.verifyQuotaForRename(fsd, srcIIP, dstIIP);
        RenameOperation tx = new RenameOperation(fsd, srcIIP, dstIIP, countPair);
        boolean added = false;
        INodesInPath renamedIIP = null;
        try {
            if (!tx.removeSrc4OldRename()) {
                INodesInPath iNodesInPath = null;
                return iNodesInPath;
            }
            renamedIIP = tx.addSourceToDestination();
            boolean bl = added = renamedIIP != null;
            if (added) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                tx.updateQuotasInSourceTree(fsd.getBlockStoragePolicySuite());
                INodesInPath iNodesInPath = renamedIIP;
                return iNodesInPath;
            }
        }
        finally {
            if (!added) {
                tx.restoreSource();
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        return null;
    }

    static RenameResult renameToInt(FSDirectory fsd, FSPermissionChecker pc, String srcArg, String dstArg, boolean logRetryCache, Options.Rename ... options) throws IOException {
        String src = srcArg;
        String dst = dstArg;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: with options={} {} to {}", new Object[]{Arrays.toString(options), src, dst});
        }
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        return FSDirRenameOp.renameTo(fsd, pc, src, dst, collectedBlocks, logRetryCache, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RenameResult renameTo(FSDirectory fsd, FSPermissionChecker pc, String src, String dst, INode.BlocksMapUpdateInfo collectedBlocks, boolean logRetryCache, Options.Rename ... options) throws IOException {
        RenameResult result;
        INodesInPath srcIIP = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE_LINK);
        INodesInPath dstIIP = fsd.resolvePath(pc, dst, FSDirectory.DirOp.CREATE_LINK);
        if (fsd.isNonEmptyDirectory(srcIIP)) {
            DFSUtil.checkProtectedDescendants(fsd, srcIIP);
        }
        if (fsd.isPermissionEnabled()) {
            boolean renameToTrash = false;
            if (null != options && Arrays.asList(options).contains(Options.Rename.TO_TRASH)) {
                renameToTrash = true;
            }
            if (renameToTrash) {
                fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, FsAction.ALL, true);
            } else {
                fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, null, false);
            }
            fsd.checkPermission(pc, dstIIP, false, FsAction.WRITE, null, null, null, false);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        long mtime = Time.now();
        fsd.writeLock();
        try {
            result = FSDirRenameOp.unprotectedRenameTo(fsd, srcIIP, dstIIP, mtime, collectedBlocks, options);
            if (result.filesDeleted) {
                FSDirDeleteOp.incrDeletedFileCount(1L);
            }
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logRename(srcIIP.getPath(), dstIIP.getPath(), mtime, logRetryCache, options);
        return result;
    }

    static void renameForEditLog(FSDirectory fsd, String src, String dst, long timestamp, Options.Rename ... options) throws IOException {
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        INodesInPath srcIIP = fsd.getINodesInPath(src, FSDirectory.DirOp.WRITE_LINK);
        INodesInPath dstIIP = fsd.getINodesInPath(dst, FSDirectory.DirOp.WRITE_LINK);
        FSDirRenameOp.unprotectedRenameTo(fsd, srcIIP, dstIIP, timestamp, collectedBlocks, options);
        if (!collectedBlocks.getToDeleteList().isEmpty()) {
            fsd.getFSNamesystem().getBlockManager().removeBlocksAndUpdateSafemodeTotal(collectedBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RenameResult unprotectedRenameTo(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP, long timestamp, INode.BlocksMapUpdateInfo collectedBlocks, Options.Rename ... options) throws IOException {
        INode dstParent;
        assert (fsd.hasWriteLock());
        boolean overwrite = options != null && Arrays.asList(options).contains(Options.Rename.OVERWRITE);
        String src = srcIIP.getPath();
        String dst = dstIIP.getPath();
        INode srcInode = srcIIP.getLastINode();
        ArrayList<INodeDirectory> srcSnapshottableDirs = new ArrayList<INodeDirectory>();
        FSDirRenameOp.validateRenameSource(fsd, srcIIP, srcSnapshottableDirs);
        if (dst.equals(src)) {
            throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
        }
        FSDirRenameOp.validateDestination(src, dst, srcInode);
        if (dstIIP.length() == 1) {
            String error = "rename destination cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
        fsd.ezManager.checkMoveValidity(srcIIP, dstIIP);
        INode dstInode = dstIIP.getLastINode();
        ArrayList<INodeDirectory> dstSnapshottableDirs = new ArrayList<INodeDirectory>();
        if (dstInode != null) {
            FSDirRenameOp.validateOverwrite(src, dst, overwrite, srcInode, dstInode);
            FSDirSnapshotOp.checkSnapshot(fsd, dstIIP, dstSnapshottableDirs);
        }
        if ((dstParent = dstIIP.getINode(-2)) == null) {
            String error = "rename destination parent " + dst + " not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (!dstParent.isDirectory()) {
            String error = "rename destination parent " + dst + " is a file.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new ParentNotDirectoryException(error);
        }
        FSDirRenameOp.validateNestSnapshot(fsd, src, dstParent.asDirectory(), srcSnapshottableDirs);
        FSDirRenameOp.checkUnderSameSnapshottableRoot(fsd, srcIIP, dstIIP);
        FSDirRenameOp.verifyFsLimitsForRename(fsd, srcIIP, dstIIP);
        Pair<Optional<QuotaCounts>, Optional<QuotaCounts>> quotaPair = FSDirRenameOp.verifyQuotaForRename(fsd, srcIIP, dstIIP);
        RenameOperation tx = new RenameOperation(fsd, srcIIP, dstIIP, quotaPair);
        boolean undoRemoveSrc = true;
        tx.removeSrc();
        boolean undoRemoveDst = false;
        long removedNum = 0L;
        try {
            INodesInPath renamedIIP;
            if (dstInode != null && (removedNum = tx.removeDst()) != -1L) {
                undoRemoveDst = true;
            }
            if ((renamedIIP = tx.addSourceToDestination()) != null) {
                undoRemoveSrc = false;
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                }
                tx.updateMtimeAndLease(timestamp);
                boolean filesDeleted = false;
                if (undoRemoveDst) {
                    undoRemoveDst = false;
                    if (removedNum > 0L) {
                        filesDeleted = tx.cleanDst(bsps, collectedBlocks);
                    }
                }
                if (dstSnapshottableDirs.size() > 0) {
                    fsd.getFSNamesystem().removeSnapshottableDirs(dstSnapshottableDirs);
                }
                tx.updateQuotasInSourceTree(bsps);
                RenameResult renameResult = FSDirRenameOp.createRenameResult(fsd, renamedIIP, filesDeleted, collectedBlocks);
                return renameResult;
            }
        }
        finally {
            if (undoRemoveSrc) {
                tx.restoreSource();
            }
            if (undoRemoveDst) {
                tx.restoreDst(bsps);
            }
        }
        NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
        throw new IOException("rename from " + src + " to " + dst + " failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static RenameResult renameTo(FSDirectory fsd, FSPermissionChecker pc, INodesInPath srcIIP, INodesInPath dstIIP, boolean logRetryCache) throws IOException {
        INodesInPath renameIIP;
        if (fsd.isNonEmptyDirectory(srcIIP)) {
            DFSUtil.checkProtectedDescendants(fsd, srcIIP);
        }
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, null, false);
            fsd.checkPermission(pc, dstIIP, false, FsAction.WRITE, null, null, null, false);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + srcIIP.getPath() + " to " + dstIIP.getPath());
        }
        long mtime = Time.now();
        fsd.writeLock();
        try {
            renameIIP = FSDirRenameOp.unprotectedRenameTo(fsd, srcIIP, dstIIP, mtime);
        }
        finally {
            fsd.writeUnlock();
        }
        if (renameIIP != null) {
            fsd.getEditLog().logRename(srcIIP.getPath(), dstIIP.getPath(), mtime, logRetryCache);
        }
        return FSDirRenameOp.createRenameResult(fsd, renameIIP, false, null);
    }

    private static void validateDestination(String src, String dst, INode srcInode) throws IOException {
        if (srcInode.isSymlink() && dst.equals(srcInode.asSymlink().getSymlinkString())) {
            throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
        }
        if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
            String error = "Rename destination " + dst + " is a directory or file under source " + src;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        if (FSDirectory.isExactReservedName(src) || FSDirectory.isExactReservedName(dst)) {
            String error = "Cannot rename to or from /.reserved";
            throw new InvalidPathException(error);
        }
    }

    private static void validateOverwrite(String src, String dst, boolean overwrite, INode srcInode, INode dstInode) throws IOException {
        ReadOnlyList<INode> children;
        if (dstInode.isDirectory() != srcInode.isDirectory()) {
            String error = "Source " + src + " and destination " + dst + " must both be directories";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        if (!overwrite) {
            String error = "rename destination " + dst + " already exists";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileAlreadyExistsException(error);
        }
        if (dstInode.isDirectory() && !(children = dstInode.asDirectory().getChildrenList(0x7FFFFFFE)).isEmpty()) {
            String error = "rename destination directory is not empty: " + dst;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameSource(FSDirectory fsd, INodesInPath srcIIP, List<INodeDirectory> snapshottableDirs) throws IOException {
        INode srcInode = srcIIP.getLastINode();
        if (srcInode == null) {
            String error = "rename source " + srcIIP.getPath() + " is not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (srcIIP.length() == 1) {
            String error = "rename source cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        FSDirSnapshotOp.checkSnapshot(fsd, srcIIP, snapshottableDirs);
    }

    private static void validateNestSnapshot(FSDirectory fsd, String srcPath, INodeDirectory dstParent, List<INodeDirectory> snapshottableDirs) throws SnapshotException {
        if (fsd.getFSNamesystem().getSnapshotManager().isAllowNestedSnapshots()) {
            return;
        }
        if (snapshottableDirs != null && snapshottableDirs.size() > 0 && fsd.getFSNamesystem().getSnapshotManager().isDescendantOfSnapshotRoot(dstParent)) {
            String dstPath = dstParent.getFullPathName();
            throw new SnapshotException("Unable to rename because " + srcPath + " has snapshottable descendant directories and " + dstPath + " is a descent of a snapshottable directory, and HDFS does not support nested snapshottable directory.");
        }
    }

    private static void checkUnderSameSnapshottableRoot(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP) throws IOException {
        INodeDirectory dstRoot;
        INodeDirectory srcRoot;
        SnapshotManager snapshotManager = fsd.getFSNamesystem().getSnapshotManager();
        if (snapshotManager.isSnapshotDeletionOrdered() && fsd.getFSNamesystem().isSnapshotTrashRootEnabled() && (srcRoot = snapshotManager.getSnapshottableAncestorDir(srcIIP)) != (dstRoot = snapshotManager.getSnapshottableAncestorDir(dstIIP))) {
            String errMsg = "Source " + srcIIP.getPath() + " and dest " + dstIIP.getPath() + " are not under the same snapshot root.";
            throw new SnapshotException(errMsg);
        }
    }

    private static RenameResult createRenameResult(FSDirectory fsd, INodesInPath dst, boolean filesDeleted, INode.BlocksMapUpdateInfo collectedBlocks) throws IOException {
        boolean success = dst != null;
        FileStatus auditStat = success ? fsd.getAuditFileInfo(dst) : null;
        return new RenameResult(success, auditStat, filesDeleted, collectedBlocks);
    }

    static class RenameResult {
        final boolean success;
        final FileStatus auditStat;
        final boolean filesDeleted;
        final INode.BlocksMapUpdateInfo collectedBlocks;

        RenameResult(boolean success, FileStatus auditStat, boolean filesDeleted, INode.BlocksMapUpdateInfo collectedBlocks) {
            this.success = success;
            this.auditStat = auditStat;
            this.filesDeleted = filesDeleted;
            this.collectedBlocks = collectedBlocks;
        }
    }

    private static class RenameOperation {
        private final FSDirectory fsd;
        private INodesInPath srcIIP;
        private final INodesInPath srcParentIIP;
        private INodesInPath dstIIP;
        private final INodesInPath dstParentIIP;
        private final INodeReference.WithCount withCount;
        private final int srcRefDstSnapshot;
        private final INodeDirectory srcParent;
        private final byte[] srcChildName;
        private final boolean isSrcInSnapshot;
        private final boolean srcChildIsReference;
        private final QuotaCounts oldSrcCountsInSnapshot;
        private final boolean sameStoragePolicy;
        private final Optional<QuotaCounts> srcSubTreeCount;
        private final Optional<QuotaCounts> dstSubTreeCount;
        private INode srcChild;
        private INode oldDstChild;

        RenameOperation(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP, Pair<Optional<QuotaCounts>, Optional<QuotaCounts>> quotaPair) {
            this.fsd = fsd;
            this.srcIIP = srcIIP;
            this.dstIIP = dstIIP;
            this.srcParentIIP = srcIIP.getParentINodesInPath();
            this.dstParentIIP = dstIIP.getParentINodesInPath();
            this.sameStoragePolicy = this.isSameStoragePolicy();
            BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
            this.srcChild = this.srcIIP.getLastINode();
            this.srcChildName = this.srcChild.getLocalNameBytes();
            int srcLatestSnapshotId = srcIIP.getLatestSnapshotId();
            this.isSrcInSnapshot = this.srcChild.isInLatestSnapshot(srcLatestSnapshotId);
            this.srcChildIsReference = this.srcChild.isReference();
            this.srcParent = this.srcIIP.getINode(-2).asDirectory();
            if (this.isSrcInSnapshot) {
                if (this.srcChild.isFile()) {
                    INodeFile file = this.srcChild.asFile();
                    file.recordModification(srcLatestSnapshotId, true);
                } else {
                    this.srcChild.recordModification(srcLatestSnapshotId);
                }
            }
            this.srcRefDstSnapshot = this.srcChildIsReference ? this.srcChild.asReference().getDstSnapshotId() : 0x7FFFFFFE;
            this.oldSrcCountsInSnapshot = new QuotaCounts.Builder().build();
            if (this.isSrcInSnapshot) {
                INodeReference.WithName withName = this.srcParent.replaceChild4ReferenceWithName(this.srcChild, srcLatestSnapshotId);
                this.withCount = (INodeReference.WithCount)withName.getReferredINode();
                this.srcChild = withName;
                this.srcIIP = INodesInPath.replace(srcIIP, srcIIP.length() - 1, this.srcChild);
                this.oldSrcCountsInSnapshot.add(this.withCount.getReferredINode().computeQuotaUsage(bsps));
            } else {
                this.withCount = this.srcChildIsReference ? (INodeReference.WithCount)this.srcChild.asReference().getReferredINode() : null;
            }
            this.srcSubTreeCount = this.withCount == null ? (Optional)quotaPair.getLeft() : Optional.empty();
            this.dstSubTreeCount = (Optional)quotaPair.getRight();
        }

        boolean isSameStoragePolicy() {
            INode src = this.srcIIP.getLastINode();
            INode dst = this.dstIIP.getLastINode();
            if (src.isSetStoragePolicy()) {
                return true;
            }
            byte dstSp = dst == null ? this.dstIIP.getINode(-2).getStoragePolicyID() : (dst.isSymlink() ? (byte)0 : dst.getStoragePolicyID());
            byte srcSp = src.isSymlink() ? (byte)0 : src.getStoragePolicyID();
            return srcSp == dstSp;
        }

        long removeSrc() throws IOException {
            long removedNum = this.fsd.removeLastINode(this.srcIIP);
            if (removedNum == -1L) {
                String error = "Failed to rename " + this.srcIIP.getPath() + " to " + this.dstIIP.getPath() + " because the source can not be removed";
                NameNode.stateChangeLog.warn("DIR* FSDirRenameOp.unprotectedRenameTo:" + error);
                throw new IOException(error);
            }
            Optional<QuotaCounts> countOp = this.sameStoragePolicy ? this.srcSubTreeCount : Optional.empty();
            this.fsd.updateCountForDelete(this.srcChild, this.srcIIP, countOp);
            this.srcIIP = INodesInPath.replace(this.srcIIP, this.srcIIP.length() - 1, null);
            return removedNum;
        }

        boolean removeSrc4OldRename() {
            long removedSrc = this.fsd.removeLastINode(this.srcIIP);
            if (removedSrc == -1L) {
                NameNode.stateChangeLog.warn("DIR* FSDirRenameOp.unprotectedRenameTo: failed to rename " + this.srcIIP.getPath() + " to " + this.dstIIP.getPath() + " because the source can not be removed");
                return false;
            }
            Optional<QuotaCounts> countOp = this.sameStoragePolicy ? this.srcSubTreeCount : Optional.empty();
            this.fsd.updateCountForDelete(this.srcChild, this.srcIIP, countOp);
            this.srcIIP = INodesInPath.replace(this.srcIIP, this.srcIIP.length() - 1, null);
            return true;
        }

        long removeDst() {
            long removedNum = this.fsd.removeLastINode(this.dstIIP);
            if (removedNum != -1L) {
                this.oldDstChild = this.dstIIP.getLastINode();
                this.fsd.updateCountForDelete(this.oldDstChild, this.dstIIP, this.dstSubTreeCount);
                this.dstIIP = INodesInPath.replace(this.dstIIP, this.dstIIP.length() - 1, null);
            }
            return removedNum;
        }

        INodesInPath addSourceToDestination() {
            INode toDst;
            INode dstParent = this.dstParentIIP.getLastINode();
            byte[] dstChildName = this.dstIIP.getLastLocalName();
            if (this.withCount == null) {
                this.srcChild.setLocalName(dstChildName);
                toDst = this.srcChild;
            } else {
                this.withCount.getReferredINode().setLocalName(dstChildName);
                toDst = new INodeReference.DstReference(dstParent.asDirectory(), this.withCount, this.dstIIP.getLatestSnapshotId());
            }
            return this.fsd.addLastINodeNoQuotaCheck(this.dstParentIIP, toDst, this.srcSubTreeCount);
        }

        void updateMtimeAndLease(long timestamp) {
            this.srcParent.updateModificationTime(timestamp, this.srcIIP.getLatestSnapshotId());
            INode dstParent = this.dstParentIIP.getLastINode();
            dstParent.updateModificationTime(timestamp, this.dstIIP.getLatestSnapshotId());
        }

        void restoreSource() {
            INode oldSrcChild = this.srcChild;
            if (this.withCount == null) {
                this.srcChild.setLocalName(this.srcChildName);
            } else if (!this.srcChildIsReference) {
                this.srcChild = this.withCount.getReferredINode();
                this.srcChild.setLocalName(this.srcChildName);
            } else {
                this.withCount.removeReference(oldSrcChild.asReference());
                this.srcChild = new INodeReference.DstReference(this.srcParent, this.withCount, this.srcRefDstSnapshot);
                this.withCount.getReferredINode().setLocalName(this.srcChildName);
            }
            if (this.isSrcInSnapshot) {
                this.srcParent.undoRename4ScrParent(oldSrcChild.asReference(), this.srcChild);
            } else {
                Optional<QuotaCounts> countOp = this.sameStoragePolicy ? this.srcSubTreeCount : Optional.empty();
                this.fsd.addLastINodeNoQuotaCheck(this.srcParentIIP, this.srcChild, countOp);
            }
        }

        void restoreDst(BlockStoragePolicySuite bsps) {
            Preconditions.checkState((this.oldDstChild != null ? 1 : 0) != 0);
            INodeDirectory dstParent = this.dstParentIIP.getLastINode().asDirectory();
            if (dstParent.isWithSnapshot()) {
                dstParent.undoRename4DstParent(bsps, this.oldDstChild, this.dstIIP.getLatestSnapshotId());
            } else {
                this.fsd.addLastINodeNoQuotaCheck(this.dstParentIIP, this.oldDstChild, this.dstSubTreeCount);
            }
            if (this.oldDstChild != null && this.oldDstChild.isReference()) {
                INodeReference removedDstRef = this.oldDstChild.asReference();
                INodeReference.WithCount wc = (INodeReference.WithCount)removedDstRef.getReferredINode().asReference();
                wc.addReference(removedDstRef);
            }
        }

        boolean cleanDst(BlockStoragePolicySuite bsps, INode.BlocksMapUpdateInfo collectedBlocks) {
            boolean filesDeleted;
            Preconditions.checkState((this.oldDstChild != null ? 1 : 0) != 0);
            ChunkedArrayList removedINodes = new ChunkedArrayList();
            ChunkedArrayList removedUCFiles = new ChunkedArrayList();
            INode.ReclaimContext context = new INode.ReclaimContext(bsps, collectedBlocks, (List<INode>)removedINodes, (List<Long>)removedUCFiles);
            if (!this.oldDstChild.isInLatestSnapshot(this.dstIIP.getLatestSnapshotId())) {
                this.oldDstChild.destroyAndCollectBlocks(context);
                filesDeleted = true;
            } else {
                this.oldDstChild.cleanSubtree(context, 0x7FFFFFFE, this.dstIIP.getLatestSnapshotId());
                filesDeleted = context.quotaDelta().getNsDelta() >= 0L;
            }
            this.fsd.updateReplicationFactor(context.collectedBlocks().toUpdateReplicationInfo());
            this.fsd.getFSNamesystem().removeLeasesAndINodes((List<Long>)removedUCFiles, (List<INode>)removedINodes, false);
            return filesDeleted;
        }

        void updateQuotasInSourceTree(BlockStoragePolicySuite bsps) {
            if (this.isSrcInSnapshot) {
                QuotaCounts newSrcCounts = this.srcChild.computeQuotaUsage(bsps, false);
                newSrcCounts.subtract(this.oldSrcCountsInSnapshot);
                this.srcParent.addSpaceConsumed(newSrcCounts);
            }
        }
    }
}

