/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.RawPathHandle;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.impl.TextFileRegionAliasMap;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBuilder;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
class ProvidedVolumeImpl
extends FsVolumeImpl {
    private URI baseURI;
    private final Map<String, ProvidedBlockPoolSlice> bpSlices = new ConcurrentHashMap<String, ProvidedBlockPoolSlice>();
    private ProvidedVolumeDF df;
    private FileSystem remoteFS;
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();

    @VisibleForTesting
    protected static String getSuffix(Path prefix, Path fullPath) {
        String prefixStr = prefix.toString();
        String pathStr = fullPath.toString();
        if (!pathStr.startsWith(prefixStr)) {
            LOG.debug("Path {} is not a prefix of the path {}", (Object)prefix, (Object)fullPath);
            return pathStr;
        }
        String suffix = pathStr.replaceFirst("^" + prefixStr, "");
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return suffix;
    }

    ProvidedVolumeImpl(FsDatasetImpl dataset, String storageID, Storage.StorageDirectory sd, FileIoProvider fileIoProvider, Configuration conf) throws IOException {
        super(dataset, storageID, sd, fileIoProvider, conf, null);
        assert (this.getStorageLocation().getStorageType() == StorageType.PROVIDED) : "Only provided storages must use ProvidedVolume";
        this.baseURI = this.getStorageLocation().getUri();
        this.df = new ProvidedVolumeDF();
        this.remoteFS = FileSystem.get((URI)this.baseURI, (Configuration)conf);
    }

    @Override
    public String[] getBlockPoolList() {
        return this.bpSlices.keySet().toArray(new String[this.bpSlices.keySet().size()]);
    }

    @Override
    public long getCapacity() {
        try {
            return this.getDfsUsed();
        }
        catch (IOException e) {
            LOG.warn("Exception when trying to get capacity of ProvidedVolume: {}", (Throwable)e);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDfsUsed() throws IOException {
        long dfsUsed = 0L;
        FsDatasetSpi<? extends FsVolumeSpi> fsDatasetSpi = this.getDataset();
        synchronized (fsDatasetSpi) {
            for (ProvidedBlockPoolSlice s : this.bpSlices.values()) {
                dfsUsed += s.getDfsUsed();
            }
        }
        return dfsUsed;
    }

    @Override
    long getBlockPoolUsed(String bpid) throws IOException {
        return this.getProvidedBlockPoolSlice(bpid).getDfsUsed();
    }

    @Override
    public long getAvailable() throws IOException {
        long remaining = this.getCapacity() - this.getDfsUsed();
        if (remaining < 0L) {
            LOG.warn("Volume {} has less than 0 available space", (Object)this);
            return 0L;
        }
        return remaining;
    }

    @Override
    long getActualNonDfsUsed() throws IOException {
        return 0L;
    }

    @Override
    public long getNonDfsUsed() throws IOException {
        return 0L;
    }

    @Override
    long getNumBlocks() {
        long numBlocks = 0L;
        for (ProvidedBlockPoolSlice s : this.bpSlices.values()) {
            numBlocks += s.getNumOfBlocks();
        }
        return numBlocks;
    }

    @Override
    void incDfsUsedAndNumBlocks(String bpid, long value) {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public URI getBaseURI() {
        return this.baseURI;
    }

    @Override
    public File getFinalizedDir(String bpid) throws IOException {
        return null;
    }

    @Override
    public void reserveSpaceForReplica(long bytesToReserve) {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public void releaseReservedSpace(long bytesToRelease) {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public FsVolumeSpi.BlockIterator newBlockIterator(String bpid, String name) {
        return new ProviderBlockIteratorImpl(bpid, name, this.bpSlices.get(bpid).getBlockAliasMap());
    }

    @Override
    public FsVolumeSpi.BlockIterator loadBlockIterator(String bpid, String name) throws IOException {
        ProviderBlockIteratorImpl iter = new ProviderBlockIteratorImpl(bpid, name, this.bpSlices.get(bpid).getBlockAliasMap());
        iter.load();
        return iter;
    }

    @Override
    ReplicaInfo addFinalizedBlock(String bpid, Block b, ReplicaInfo replicaInfo, long bytesReserved) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public VolumeCheckResult check(FsVolumeSpi.VolumeCheckContext ignored) throws DiskChecker.DiskErrorException {
        return VolumeCheckResult.HEALTHY;
    }

    @Override
    void getVolumeMap(ReplicaMap volumeMap, RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        LOG.info("Creating volumemap for provided volume " + this);
        for (ProvidedBlockPoolSlice s : this.bpSlices.values()) {
            s.fetchVolumeMap(volumeMap, ramDiskReplicaMap, this.remoteFS);
        }
    }

    private ProvidedBlockPoolSlice getProvidedBlockPoolSlice(String bpid) throws IOException {
        ProvidedBlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp == null) {
            throw new IOException("block pool " + bpid + " is not found");
        }
        return bp;
    }

    @Override
    void getVolumeMap(String bpid, ReplicaMap volumeMap, RamDiskReplicaTracker ramDiskReplicaMap) throws IOException {
        this.getProvidedBlockPoolSlice(bpid).fetchVolumeMap(volumeMap, ramDiskReplicaMap, this.remoteFS);
    }

    @VisibleForTesting
    BlockAliasMap<FileRegion> getBlockFormat(String bpid) throws IOException {
        return this.getProvidedBlockPoolSlice(bpid).getBlockAliasMap();
    }

    @Override
    public String toString() {
        return this.baseURI.toString();
    }

    @Override
    void addBlockPool(String bpid, Configuration conf) throws IOException {
        this.addBlockPool(bpid, conf, null);
    }

    @Override
    void addBlockPool(String bpid, Configuration conf, Timer timer) throws IOException {
        LOG.info("Adding block pool " + bpid + " to volume with id " + this.getStorageID());
        ProvidedBlockPoolSlice bp = new ProvidedBlockPoolSlice(bpid, this, conf);
        this.bpSlices.put(bpid, bp);
    }

    @Override
    void shutdown() {
        if (this.cacheExecutor != null) {
            this.cacheExecutor.shutdown();
        }
        Set<Map.Entry<String, ProvidedBlockPoolSlice>> set = this.bpSlices.entrySet();
        for (Map.Entry<String, ProvidedBlockPoolSlice> entry : set) {
            entry.getValue().shutdown(null);
        }
    }

    @Override
    void shutdownBlockPool(String bpid, BlockListAsLongs blocksListsAsLongs) {
        ProvidedBlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp != null) {
            bp.shutdown(blocksListsAsLongs);
        }
        this.bpSlices.remove(bpid);
    }

    @Override
    boolean isBPDirEmpty(String bpid) throws IOException {
        return this.getProvidedBlockPoolSlice(bpid).isEmpty();
    }

    @Override
    void deleteBPDirectories(String bpid, boolean force) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public void compileReport(String bpid, Collection<FsVolumeSpi.ScanInfo> report, DirectoryScanner.ReportCompiler reportCompiler) throws InterruptedException, IOException {
        LOG.info("Compiling report for volume: {}; bpid: {}", (Object)this, (Object)bpid);
        if (this.bpSlices.containsKey(bpid)) {
            this.bpSlices.get(bpid).compileReport(report, reportCompiler);
        }
    }

    @Override
    public ReplicaInPipeline append(String bpid, ReplicaInfo replicaInfo, long newGS, long estimateBlockLen) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public ReplicaInPipeline createRbw(ExtendedBlock b) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public ReplicaInPipeline convertTemporaryToRbw(ExtendedBlock b, ReplicaInfo temp) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public ReplicaInPipeline createTemporary(ExtendedBlock b) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public ReplicaInPipeline updateRURCopyOnTruncate(ReplicaInfo rur, String bpid, long newBlockId, long recoveryId, long newlength) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public ReplicaInfo moveBlockToTmpLocation(ExtendedBlock block, ReplicaInfo replicaInfo, int smallBufferSize, Configuration conf) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    @Override
    public File[] copyBlockToLazyPersistLocation(String bpId, long blockId, long genStamp, ReplicaInfo replicaInfo, int smallBufferSize, Configuration conf) throws IOException {
        throw new UnsupportedOperationException("ProvidedVolume does not yet support writes");
    }

    private static URI getAbsoluteURI(URI uri) {
        if (!uri.isAbsolute()) {
            return StorageLocation.normalizeFileURI(uri);
        }
        return uri;
    }

    @VisibleForTesting
    public static boolean containsBlock(URI volumeURI, URI blockURI) {
        if (volumeURI == null && blockURI == null) {
            return true;
        }
        if (volumeURI == null || blockURI == null) {
            return false;
        }
        return !(volumeURI = ProvidedVolumeImpl.getAbsoluteURI(volumeURI)).relativize(blockURI = ProvidedVolumeImpl.getAbsoluteURI(blockURI)).equals(blockURI);
    }

    @VisibleForTesting
    BlockAliasMap<FileRegion> getFileRegionProvider(String bpid) throws IOException {
        return this.getProvidedBlockPoolSlice(bpid).getBlockAliasMap();
    }

    @VisibleForTesting
    void setFileRegionProvider(String bpid, BlockAliasMap<FileRegion> blockAliasMap) throws IOException {
        ProvidedBlockPoolSlice bp = this.bpSlices.get(bpid);
        if (bp == null) {
            throw new IOException("block pool " + bpid + " is not found");
        }
        bp.setFileRegionProvider(blockAliasMap);
    }

    public static class ProvidedVolumeDF {
        private AtomicLong used = new AtomicLong();

        public long getSpaceUsed() {
            return this.used.get();
        }

        public void decDfsUsed(long value) {
            this.used.addAndGet(-value);
        }

        public void incDfsUsed(long value) {
            this.used.addAndGet(value);
        }

        public long getCapacity() {
            return this.getSpaceUsed();
        }
    }

    static class ProvidedBlockPoolSlice {
        private ProvidedVolumeImpl providedVolume;
        private BlockAliasMap<FileRegion> aliasMap;
        private Configuration conf;
        private String bpid;
        private ReplicaMap bpVolumeMap;
        private ProvidedVolumeDF df;
        private AtomicLong numOfBlocks = new AtomicLong();
        private int numRetries;

        ProvidedBlockPoolSlice(String bpid, ProvidedVolumeImpl volume, Configuration conf) {
            this.providedVolume = volume;
            this.bpVolumeMap = new ReplicaMap();
            Class fmt = conf.getClass("dfs.provided.aliasmap.class", TextFileRegionAliasMap.class, BlockAliasMap.class);
            this.aliasMap = (BlockAliasMap)ReflectionUtils.newInstance((Class)fmt, (Configuration)conf);
            this.conf = conf;
            this.bpid = bpid;
            this.df = new ProvidedVolumeDF();
            this.bpVolumeMap.initBlockPool(bpid);
            this.numRetries = conf.getInt("dfs.provided.aliasmap.load.retries", 0);
            FsVolumeImpl.LOG.info("Created alias map using class: " + this.aliasMap.getClass());
        }

        BlockAliasMap<FileRegion> getBlockAliasMap() {
            return this.aliasMap;
        }

        @VisibleForTesting
        void setFileRegionProvider(BlockAliasMap<FileRegion> blockAliasMap) {
            this.aliasMap = blockAliasMap;
        }

        void fetchVolumeMap(ReplicaMap volumeMap, RamDiskReplicaTracker ramDiskReplicaMap, FileSystem remoteFS) throws IOException {
            BlockAliasMap.Reader<FileRegion> reader = null;
            int tries = 1;
            while (true) {
                try {
                    reader = this.aliasMap.getReader(null, this.bpid);
                }
                catch (IOException e) {
                    reader = null;
                    if (++tries <= this.numRetries) continue;
                }
                break;
            }
            if (reader == null) {
                FsVolumeImpl.LOG.error("Got null reader from BlockAliasMap " + this.aliasMap + "; no blocks will be populated");
                return;
            }
            Path blockPrefixPath = new Path(this.providedVolume.getBaseURI());
            for (FileRegion region : reader) {
                ReplicaInfo newReplica;
                ReplicaInfo oldReplica;
                if (!ProvidedVolumeImpl.containsBlock(this.providedVolume.baseURI, region.getProvidedStorageLocation().getPath().toUri())) continue;
                String blockSuffix = ProvidedVolumeImpl.getSuffix(blockPrefixPath, new Path(region.getProvidedStorageLocation().getPath().toUri()));
                RawPathHandle pathHandle = null;
                if (region.getProvidedStorageLocation().getNonce().length > 0) {
                    pathHandle = new RawPathHandle(ByteBuffer.wrap(region.getProvidedStorageLocation().getNonce()));
                }
                if ((oldReplica = volumeMap.get(this.bpid, (newReplica = new ReplicaBuilder(HdfsServerConstants.ReplicaState.FINALIZED).setBlockId(region.getBlock().getBlockId()).setPathPrefix(blockPrefixPath).setPathSuffix(blockSuffix).setOffset(region.getProvidedStorageLocation().getOffset()).setLength(region.getBlock().getNumBytes()).setGenerationStamp(region.getBlock().getGenerationStamp()).setPathHandle((PathHandle)pathHandle).setFsVolume(this.providedVolume).setConf(this.conf).setRemoteFS(remoteFS).build()).getBlockId())) == null) {
                    volumeMap.add(this.bpid, newReplica);
                    this.bpVolumeMap.add(this.bpid, newReplica);
                    this.incrNumBlocks();
                    this.incDfsUsed(region.getBlock().getNumBytes());
                    continue;
                }
                FsVolumeImpl.LOG.warn("A block with id " + newReplica.getBlockId() + " exists locally. Skipping PROVIDED replica");
            }
        }

        private void incrNumBlocks() {
            this.numOfBlocks.incrementAndGet();
        }

        public boolean isEmpty() {
            return this.bpVolumeMap.size(this.bpid) == 0;
        }

        public void shutdown(BlockListAsLongs blocksListsAsLongs) {
        }

        public void compileReport(Collection<FsVolumeSpi.ScanInfo> report, DirectoryScanner.ReportCompiler reportCompiler) throws IOException, InterruptedException {
            this.aliasMap.refresh();
            BlockAliasMap.Reader<FileRegion> reader = this.aliasMap.getReader(null, this.bpid);
            for (FileRegion region : reader) {
                reportCompiler.throttle();
                report.add(new FsVolumeSpi.ScanInfo(region.getBlock().getBlockId(), this.providedVolume, region, region.getProvidedStorageLocation().getLength()));
            }
        }

        public long getNumOfBlocks() {
            return this.numOfBlocks.get();
        }

        long getDfsUsed() throws IOException {
            return this.df.getSpaceUsed();
        }

        void incDfsUsed(long value) {
            this.df.incDfsUsed(value);
        }
    }

    private class ProviderBlockIteratorImpl
    implements FsVolumeSpi.BlockIterator {
        private String bpid;
        private String name;
        private BlockAliasMap<FileRegion> blockAliasMap;
        private Iterator<FileRegion> blockIterator;
        private ProvidedBlockIteratorState state;

        ProviderBlockIteratorImpl(String bpid, String name, BlockAliasMap<FileRegion> blockAliasMap) {
            this.bpid = bpid;
            this.name = name;
            this.blockAliasMap = blockAliasMap;
            this.rewind();
        }

        @Override
        public void close() throws IOException {
            this.blockAliasMap.close();
        }

        @Override
        public ExtendedBlock nextBlock() throws IOException {
            if (null == this.blockIterator || !this.blockIterator.hasNext()) {
                return null;
            }
            FileRegion nextRegion = null;
            while (null == nextRegion && this.blockIterator.hasNext()) {
                FileRegion temp = this.blockIterator.next();
                if (temp.getBlock().getBlockId() < this.state.lastBlockId) continue;
                nextRegion = temp;
            }
            if (null == nextRegion) {
                return null;
            }
            this.state.lastBlockId = nextRegion.getBlock().getBlockId();
            return new ExtendedBlock(this.bpid, nextRegion.getBlock());
        }

        @Override
        public boolean atEnd() {
            return this.blockIterator != null ? !this.blockIterator.hasNext() : true;
        }

        @Override
        public void rewind() {
            BlockAliasMap.Reader<FileRegion> reader = null;
            try {
                reader = this.blockAliasMap.getReader(null, this.bpid);
            }
            catch (IOException e) {
                FsVolumeImpl.LOG.warn("Exception in getting reader from provided alias map");
            }
            this.blockIterator = reader != null ? reader.iterator() : null;
            this.state = new ProvidedBlockIteratorState();
        }

        @Override
        public void save() throws IOException {
            this.state.lastSavedMs = Time.now();
        }

        @Override
        public void setMaxStalenessMs(long maxStalenessMs) {
        }

        @Override
        public long getIterStartMs() {
            return this.state.iterStartMs;
        }

        @Override
        public long getLastSavedMs() {
            return this.state.lastSavedMs;
        }

        @Override
        public String getBlockPoolId() {
            return this.bpid;
        }

        public void load() throws IOException {
            this.rewind();
            FsVolumeImpl.LOG.trace("load({}, {}): loaded iterator {}: {}", new Object[]{ProvidedVolumeImpl.this.getStorageID(), this.bpid, this.name, WRITER.writeValueAsString((Object)this.state)});
        }
    }

    private static class ProvidedBlockIteratorState {
        @JsonProperty
        private long lastSavedMs;
        @JsonProperty
        private long iterStartMs;
        @JsonProperty
        private long lastBlockId;

        ProvidedBlockIteratorState() {
            this.lastSavedMs = this.iterStartMs = Time.now();
            this.lastBlockId = -1L;
        }
    }
}

