/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Collection;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.junit.jupiter.api.Assertions;

public class FsDatasetTestUtil {
    public static File getFile(FsDatasetSpi<?> fsd, String bpid, long bid) {
        try {
            ReplicaInfo r = ((FsDatasetImpl)fsd).getReplicaInfo(bpid, bid);
            return new File(r.getBlockURI());
        }
        catch (ReplicaNotFoundException e) {
            FsDatasetImpl.LOG.warn(String.format("Replica with id %d was not found in block pool %s.", bid, bpid), (Throwable)e);
            return null;
        }
    }

    public static File getBlockFile(FsDatasetSpi<?> fsd, String bpid, Block b) throws IOException {
        ReplicaInfo r = ((FsDatasetImpl)fsd).getReplicaInfo(bpid, b.getBlockId());
        return new File(r.getBlockURI());
    }

    public static File getMetaFile(FsDatasetSpi<?> fsd, String bpid, Block b) throws IOException {
        return FsDatasetUtil.getMetaFile(FsDatasetTestUtil.getBlockFile(fsd, bpid, b), b.getGenerationStamp());
    }

    public static boolean breakHardlinksIfNeeded(FsDatasetSpi<?> fsd, ExtendedBlock block) throws IOException {
        LocalReplica info = (LocalReplica)((FsDatasetImpl)fsd).getReplicaInfo(block);
        return info.breakHardLinksIfNeeded();
    }

    public static ReplicaInfo fetchReplicaInfo(FsDatasetSpi<?> fsd, String bpid, long blockId) {
        return ((FsDatasetImpl)fsd).fetchReplicaInfo(bpid, blockId);
    }

    public static Collection<ReplicaInfo> getReplicas(FsDatasetSpi<?> fsd, String bpid) {
        return ((FsDatasetImpl)fsd).volumeMap.replicas(bpid);
    }

    public static void stopLazyWriter(DataNode dn) {
        FsDatasetImpl fsDataset = (FsDatasetImpl)dn.getFSDataset();
        ((FsDatasetImpl.LazyWriter)fsDataset.lazyWriter.getRunnable()).stop();
    }

    public static void assertFileLockReleased(String dir) throws IOException {
        block15: {
            StorageLocation sl = StorageLocation.parse(dir);
            File lockFile = new File(new File(sl.getUri()), "in_use.lock");
            try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rws");
                 FileChannel channel = raf.getChannel();){
                FileLock lock = channel.tryLock();
                Assertions.assertNotNull((Object)lock, (String)String.format("Lock file at %s appears to be held by a different process.", lockFile.getAbsolutePath()));
                if (lock == null) break block15;
                try {
                    lock.release();
                }
                catch (IOException e) {
                    FsDatasetImpl.LOG.warn(String.format("I/O error releasing file lock %s.", lockFile.getAbsolutePath()), (Throwable)e);
                    throw e;
                }
            }
            catch (OverlappingFileLockException e) {
                Assertions.fail((String)String.format("Must release lock file at %s.", lockFile.getAbsolutePath()));
            }
        }
    }
}

