/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.FinalizedProvidedReplica;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.LocalReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ProvidedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaBeingWritten;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaUnderRecovery;
import org.apache.hadoop.hdfs.server.datanode.ReplicaWaitingToBeRecovered;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;

public class ReplicaBuilder {
    private HdfsServerConstants.ReplicaState state;
    private long blockId;
    private long genStamp;
    private long length = -1L;
    private FsVolumeSpi volume = null;
    private File directoryUsed;
    private long bytesToReserve;
    private Thread writer = null;
    private long recoveryId;
    private Block block = null;
    private byte[] lastPartialChunkChecksum;
    private ReplicaInfo fromReplica = null;
    private URI uri = null;
    private long offset;
    private Configuration conf = null;
    private FileRegion fileRegion = null;
    private FileSystem remoteFS;
    private PathHandle pathHandle;
    private String pathSuffix;
    private Path pathPrefix;

    public ReplicaBuilder(HdfsServerConstants.ReplicaState state) {
        this.state = state;
        this.pathHandle = null;
    }

    public ReplicaBuilder setState(HdfsServerConstants.ReplicaState state) {
        this.state = state;
        return this;
    }

    public ReplicaBuilder setBlockId(long blockId) {
        this.blockId = blockId;
        return this;
    }

    public ReplicaBuilder setGenerationStamp(long genStamp) {
        this.genStamp = genStamp;
        return this;
    }

    public ReplicaBuilder setLength(long length) {
        this.length = length;
        return this;
    }

    public ReplicaBuilder setFsVolume(FsVolumeSpi volume) {
        this.volume = volume;
        return this;
    }

    public ReplicaBuilder setDirectoryToUse(File dir) {
        this.directoryUsed = dir;
        return this;
    }

    public ReplicaBuilder setBytesToReserve(long bytesToReserve) {
        this.bytesToReserve = bytesToReserve;
        return this;
    }

    public ReplicaBuilder setWriterThread(Thread writer) {
        this.writer = writer;
        return this;
    }

    public ReplicaBuilder from(ReplicaInfo fromReplica) {
        this.fromReplica = fromReplica;
        return this;
    }

    public ReplicaBuilder setRecoveryId(long recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public ReplicaBuilder setBlock(Block block) {
        this.block = block;
        return this;
    }

    public ReplicaBuilder setURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public ReplicaBuilder setConf(Configuration conf) {
        this.conf = conf;
        return this;
    }

    public ReplicaBuilder setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public ReplicaBuilder setFileRegion(FileRegion fileRegion) {
        this.fileRegion = fileRegion;
        return this;
    }

    public ReplicaBuilder setRemoteFS(FileSystem remoteFS) {
        this.remoteFS = remoteFS;
        return this;
    }

    public ReplicaBuilder setPathSuffix(String suffix) {
        this.pathSuffix = suffix;
        return this;
    }

    public ReplicaBuilder setPathPrefix(Path prefix) {
        this.pathPrefix = prefix;
        return this;
    }

    public ReplicaBuilder setPathHandle(PathHandle pathHandle) {
        this.pathHandle = pathHandle;
        return this;
    }

    public ReplicaBuilder setLastPartialChunkChecksum(byte[] checksum) {
        this.lastPartialChunkChecksum = checksum;
        return this;
    }

    public LocalReplicaInPipeline buildLocalReplicaInPipeline() throws IllegalArgumentException {
        LocalReplicaInPipeline info = null;
        switch (this.state) {
            case RBW: {
                info = this.buildRBW();
                break;
            }
            case TEMPORARY: {
                info = this.buildTemporaryReplica();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown replica state " + this.state);
            }
        }
        return info;
    }

    private LocalReplicaInPipeline buildRBW() throws IllegalArgumentException {
        if (null != this.fromReplica && this.fromReplica.getState() == HdfsServerConstants.ReplicaState.RBW) {
            return new ReplicaBeingWritten((ReplicaBeingWritten)this.fromReplica);
        }
        if (null != this.fromReplica) {
            throw new IllegalArgumentException("Incompatible fromReplica state: " + this.fromReplica.getState());
        }
        if (null != this.block) {
            if (null == this.writer) {
                throw new IllegalArgumentException("A valid writer is required for constructing a RBW from block " + this.block.getBlockId());
            }
            return new ReplicaBeingWritten(this.block, this.volume, this.directoryUsed, this.writer);
        }
        if (this.length != -1L) {
            return new ReplicaBeingWritten(this.blockId, this.length, this.genStamp, this.volume, this.directoryUsed, this.writer, this.bytesToReserve);
        }
        return new ReplicaBeingWritten(this.blockId, this.genStamp, this.volume, this.directoryUsed, this.bytesToReserve);
    }

    private LocalReplicaInPipeline buildTemporaryReplica() throws IllegalArgumentException {
        if (null != this.fromReplica && this.fromReplica.getState() == HdfsServerConstants.ReplicaState.TEMPORARY) {
            return new LocalReplicaInPipeline((LocalReplicaInPipeline)this.fromReplica);
        }
        if (null != this.fromReplica) {
            throw new IllegalArgumentException("Incompatible fromReplica state: " + this.fromReplica.getState());
        }
        if (null != this.block) {
            if (null == this.writer) {
                throw new IllegalArgumentException("A valid writer is required for constructing a Replica from block " + this.block.getBlockId());
            }
            return new LocalReplicaInPipeline(this.block, this.volume, this.directoryUsed, this.writer);
        }
        if (this.length != -1L) {
            return new LocalReplicaInPipeline(this.blockId, this.length, this.genStamp, this.volume, this.directoryUsed, this.writer, this.bytesToReserve);
        }
        return new LocalReplicaInPipeline(this.blockId, this.genStamp, this.volume, this.directoryUsed, this.bytesToReserve);
    }

    private LocalReplica buildFinalizedReplica() throws IllegalArgumentException {
        if (null != this.fromReplica && this.fromReplica.getState() == HdfsServerConstants.ReplicaState.FINALIZED) {
            return new FinalizedReplica((FinalizedReplica)this.fromReplica);
        }
        if (null != this.fromReplica) {
            throw new IllegalArgumentException("Incompatible fromReplica state: " + this.fromReplica.getState());
        }
        if (null != this.block) {
            return new FinalizedReplica(this.block, this.volume, this.directoryUsed, this.lastPartialChunkChecksum);
        }
        return new FinalizedReplica(this.blockId, this.length, this.genStamp, this.volume, this.directoryUsed, this.lastPartialChunkChecksum);
    }

    private LocalReplica buildRWR() throws IllegalArgumentException {
        if (null != this.fromReplica && this.fromReplica.getState() == HdfsServerConstants.ReplicaState.RWR) {
            return new ReplicaWaitingToBeRecovered((ReplicaWaitingToBeRecovered)this.fromReplica);
        }
        if (null != this.fromReplica) {
            throw new IllegalArgumentException("Incompatible fromReplica state: " + this.fromReplica.getState());
        }
        if (null != this.block) {
            return new ReplicaWaitingToBeRecovered(this.block, this.volume, this.directoryUsed);
        }
        return new ReplicaWaitingToBeRecovered(this.blockId, this.length, this.genStamp, this.volume, this.directoryUsed);
    }

    private LocalReplica buildRUR() throws IllegalArgumentException {
        if (null == this.fromReplica) {
            throw new IllegalArgumentException("Missing a valid replica to recover from");
        }
        if (null != this.writer || null != this.block) {
            throw new IllegalArgumentException("Invalid state for recovering from replica with blk id " + this.fromReplica.getBlockId());
        }
        if (this.fromReplica.getState() == HdfsServerConstants.ReplicaState.RUR) {
            return new ReplicaUnderRecovery((ReplicaUnderRecovery)this.fromReplica);
        }
        return new ReplicaUnderRecovery(this.fromReplica, this.recoveryId);
    }

    private ProvidedReplica buildProvidedFinalizedReplica() throws IllegalArgumentException {
        FinalizedProvidedReplica info = null;
        if (this.fromReplica != null) {
            throw new IllegalArgumentException("Finalized PROVIDED replica cannot be constructed from another replica");
        }
        if (this.fileRegion == null && this.uri == null && (this.pathPrefix == null || this.pathSuffix == null)) {
            throw new IllegalArgumentException("Trying to construct a provided replica on " + this.volume + " without enough information");
        }
        info = this.fileRegion == null ? (this.uri != null ? new FinalizedProvidedReplica(this.blockId, this.uri, this.offset, this.length, this.genStamp, this.pathHandle, this.volume, this.conf, this.remoteFS) : new FinalizedProvidedReplica(this.blockId, this.pathPrefix, this.pathSuffix, this.offset, this.length, this.genStamp, this.pathHandle, this.volume, this.conf, this.remoteFS)) : new FinalizedProvidedReplica(this.fileRegion, this.volume, this.conf, this.remoteFS);
        return info;
    }

    private ProvidedReplica buildProvidedReplica() throws IllegalArgumentException {
        ProvidedReplica info = null;
        switch (this.state) {
            case FINALIZED: {
                info = this.buildProvidedFinalizedReplica();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown replica state " + this.state + " for PROVIDED replica");
            }
        }
        return info;
    }

    private LocalReplica buildLocalReplica() throws IllegalArgumentException {
        LocalReplica info = null;
        switch (this.state) {
            case FINALIZED: {
                info = this.buildFinalizedReplica();
                break;
            }
            case RWR: {
                info = this.buildRWR();
                break;
            }
            case RUR: {
                info = this.buildRUR();
                break;
            }
            case RBW: 
            case TEMPORARY: {
                info = this.buildLocalReplicaInPipeline();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown replica state " + this.state);
            }
        }
        return info;
    }

    public ReplicaInfo build() throws IllegalArgumentException {
        ReplicaInfo info = null;
        info = this.volume != null && this.volume.getStorageType() == StorageType.PROVIDED ? this.buildProvidedReplica() : this.buildLocalReplica();
        return info;
    }
}

