/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.LocatedBlockBuilder;
import org.apache.hadoop.hdfs.server.common.BlockAlias;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.impl.TextFileRegionAliasMap;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.util.RwLock;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ProvidedStorageMap {
    private static final Logger LOG = LoggerFactory.getLogger(ProvidedStorageMap.class);
    private RwLock lock;
    private BlockManager bm;
    private BlockAliasMap aliasMap;
    private final String storageId;
    private final ProvidedDescriptor providedDescriptor;
    private final DatanodeStorageInfo providedStorageInfo;
    private boolean providedEnabled;
    private int defaultReplication;

    ProvidedStorageMap(RwLock lock, BlockManager bm, Configuration conf) {
        this.storageId = conf.get("dfs.provided.storage.id", "DS-PROVIDED");
        this.providedEnabled = conf.getBoolean("dfs.namenode.provided.enabled", false);
        if (!this.providedEnabled) {
            this.aliasMap = null;
            this.providedDescriptor = null;
            this.providedStorageInfo = null;
            return;
        }
        DatanodeStorage ds = new DatanodeStorage(this.storageId, DatanodeStorage.State.NORMAL, StorageType.PROVIDED);
        this.providedDescriptor = new ProvidedDescriptor();
        this.providedStorageInfo = this.providedDescriptor.createProvidedStorage(ds);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        this.bm = bm;
        this.lock = lock;
        Class aliasMapClass = conf.getClass("dfs.provided.aliasmap.class", TextFileRegionAliasMap.class, BlockAliasMap.class);
        this.aliasMap = (BlockAliasMap)ReflectionUtils.newInstance((Class)aliasMapClass, (Configuration)conf);
        LOG.info("Loaded alias map class: " + this.aliasMap.getClass() + " storage: " + this.providedStorageInfo);
    }

    DatanodeStorageInfo getStorage(DatanodeDescriptor dn, DatanodeStorage s) throws IOException {
        if (this.providedEnabled && this.storageId.equals(s.getStorageID())) {
            if (StorageType.PROVIDED.equals((Object)s.getStorageType())) {
                if (this.providedStorageInfo.getState() == DatanodeStorage.State.FAILED && s.getState() == DatanodeStorage.State.NORMAL) {
                    this.providedStorageInfo.setState(DatanodeStorage.State.NORMAL);
                    LOG.info("Provided storage transitioning to state " + DatanodeStorage.State.NORMAL);
                }
                if (dn.getStorageInfo(s.getStorageID()) == null) {
                    dn.injectStorage(this.providedStorageInfo);
                }
                this.processProvidedStorageReport();
                return this.providedDescriptor.getProvidedStorage(dn, s);
            }
            LOG.warn("Reserved storage {} reported as non-provided from {}", (Object)s, (Object)dn);
        }
        return dn.getStorageInfo(s.getStorageID());
    }

    private void processProvidedStorageReport() throws IOException {
        assert (this.lock.hasWriteLock(RwLockMode.GLOBAL)) : "Not holding write lock";
        if (this.providedStorageInfo.getBlockReportCount() == 0 || this.providedDescriptor.activeProvidedDatanodes() == 0) {
            LOG.info("Calling process first blk report from storage: " + this.providedStorageInfo);
            BlockAliasMap.Reader reader = this.aliasMap.getReader(null, this.bm.getBlockPoolId());
            if (reader != null) {
                this.bm.processFirstBlockReport(this.providedStorageInfo, new ProvidedBlockList(reader.iterator()));
            }
        }
    }

    @VisibleForTesting
    public DatanodeStorageInfo getProvidedStorageInfo() {
        return this.providedStorageInfo;
    }

    public LocatedBlockBuilder newLocatedBlocks(int maxValue) {
        if (!this.providedEnabled) {
            return new LocatedBlockBuilder(maxValue);
        }
        return new ProvidedBlocksBuilder(maxValue);
    }

    public void removeDatanode(DatanodeDescriptor dnToRemove) {
        if (this.providedEnabled) {
            assert (this.lock.hasWriteLock(RwLockMode.BM)) : "Not holding write lock";
            this.providedDescriptor.remove(dnToRemove);
            if (this.providedDescriptor.activeProvidedDatanodes() == 0) {
                this.providedStorageInfo.setBlockReportCount(0);
            }
        }
    }

    public long getCapacity() {
        if (this.providedStorageInfo == null) {
            return 0L;
        }
        return this.providedStorageInfo.getCapacity();
    }

    public void updateStorage(DatanodeDescriptor node, DatanodeStorage storage) {
        if (this.isProvidedStorage(storage.getStorageID())) {
            if (StorageType.PROVIDED.equals((Object)storage.getStorageType())) {
                node.injectStorage(this.providedStorageInfo);
                return;
            }
            LOG.warn("Reserved storage {} reported as non-provided from {}", (Object)storage, (Object)node);
        }
        node.updateStorage(storage);
    }

    private boolean isProvidedStorage(String dnStorageId) {
        return this.providedEnabled && this.storageId.equals(dnStorageId);
    }

    public DatanodeDescriptor chooseProvidedDatanode() {
        return this.providedDescriptor.chooseRandom(new DatanodeStorageInfo[0]);
    }

    @VisibleForTesting
    public BlockAliasMap getAliasMap() {
        return this.aliasMap;
    }

    public static class ProvidedDescriptor
    extends DatanodeDescriptor {
        private final NavigableMap<String, DatanodeDescriptor> dns = new ConcurrentSkipListMap<String, DatanodeDescriptor>();
        private final List<DatanodeDescriptor> dnR = new ArrayList<DatanodeDescriptor>();
        public static final String NETWORK_LOCATION = "/REMOTE";
        public static final String NAME = "PROVIDED";

        ProvidedDescriptor() {
            super(new DatanodeID(null, null, UUID.randomUUID().toString(), 0, 0, 0, 0));
        }

        DatanodeStorageInfo getProvidedStorage(DatanodeDescriptor dn, DatanodeStorage s) {
            this.dns.put(dn.getDatanodeUuid(), dn);
            this.dnR.add(dn);
            return (DatanodeStorageInfo)this.storageMap.get(s.getStorageID());
        }

        DatanodeStorageInfo createProvidedStorage(DatanodeStorage ds) {
            assert (null == this.storageMap.get(ds.getStorageID()));
            ProvidedDatanodeStorageInfo storage = new ProvidedDatanodeStorageInfo(this, ds);
            storage.setHeartbeatedSinceFailover(true);
            this.storageMap.put(storage.getStorageID(), storage);
            return storage;
        }

        DatanodeDescriptor choose(DatanodeDescriptor client) {
            return this.choose(client, Collections.emptySet());
        }

        DatanodeDescriptor choose(DatanodeDescriptor client, Set<String> excludedUUids) {
            DatanodeDescriptor dn;
            if (client != null && !excludedUUids.contains(client.getDatanodeUuid()) && (dn = (DatanodeDescriptor)((Object)this.dns.get(client.getDatanodeUuid()))) != null) {
                return dn;
            }
            dn = this.chooseRandomNode(excludedUUids, true);
            if (dn == null) {
                dn = this.chooseRandomNode(excludedUUids, false);
            }
            return dn;
        }

        private DatanodeDescriptor chooseRandomNode(Set<String> excludedUUids, boolean preferLiveNodes) {
            Random r = new Random();
            for (int i = this.dnR.size() - 1; i >= 0; --i) {
                int pos = r.nextInt(i + 1);
                DatanodeDescriptor node = this.dnR.get(pos);
                String uuid = node.getDatanodeUuid();
                if (!(excludedUUids.contains(uuid) || preferLiveNodes && node.getAdminState() != DatanodeInfo.AdminStates.NORMAL)) {
                    return node;
                }
                Collections.swap(this.dnR, i, pos);
            }
            return null;
        }

        DatanodeDescriptor chooseRandom(DatanodeStorageInfo ... excludedStorages) {
            HashSet<String> excludedNodes = new HashSet<String>();
            if (excludedStorages != null) {
                for (int i = 0; i < excludedStorages.length; ++i) {
                    DatanodeDescriptor dn = excludedStorages[i].getDatanodeDescriptor();
                    String uuid = dn.getDatanodeUuid();
                    excludedNodes.add(uuid);
                }
            }
            return this.choose(null, excludedNodes);
        }

        @Override
        public void addBlockToBeReplicated(Block block, DatanodeStorageInfo[] targets) {
            DatanodeDescriptor node = this.chooseRandom(targets);
            if (node != null) {
                node.addBlockToBeReplicated(block, targets);
            } else {
                LOG.error("Cannot find a source node to replicate block: " + block + " from");
            }
        }

        int remove(DatanodeDescriptor dnToRemove) {
            DatanodeDescriptor storedDN;
            if (dnToRemove != null && (storedDN = (DatanodeDescriptor)((Object)this.dns.get(dnToRemove.getDatanodeUuid()))) != null) {
                this.dns.remove(dnToRemove.getDatanodeUuid());
                this.dnR.remove((Object)dnToRemove);
            }
            return this.dns.size();
        }

        int activeProvidedDatanodes() {
            return this.dns.size();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "PROVIDED-LOCATION";
        }

        public String getNetworkLocation() {
            return NETWORK_LOCATION;
        }

        public String getName() {
            return NAME;
        }
    }

    static class ProvidedBlockList
    extends BlockListAsLongs {
        private final Iterator<BlockAlias> inner;

        ProvidedBlockList(Iterator<BlockAlias> inner) {
            this.inner = inner;
        }

        @Override
        public Iterator<BlockListAsLongs.BlockReportReplica> iterator() {
            return new Iterator<BlockListAsLongs.BlockReportReplica>(){

                @Override
                public BlockListAsLongs.BlockReportReplica next() {
                    return new BlockListAsLongs.BlockReportReplica(inner.next().getBlock());
                }

                @Override
                public boolean hasNext() {
                    return inner.hasNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int getNumberOfBlocks() {
            return -1;
        }

        @Override
        public ByteString getBlocksBuffer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long[] getBlockListAsLongs() {
            throw new UnsupportedOperationException();
        }
    }

    class ProvidedBlocksBuilder
    extends LocatedBlockBuilder {
        ProvidedBlocksBuilder(int maxBlocks) {
            super(maxBlocks);
        }

        private DatanodeDescriptor chooseProvidedDatanode(Set<String> excludedUUids) {
            DatanodeDescriptor dn = ProvidedStorageMap.this.providedDescriptor.choose(null, excludedUUids);
            if (dn == null) {
                dn = ProvidedStorageMap.this.providedDescriptor.choose(null);
            }
            return dn;
        }

        @Override
        LocatedBlock newLocatedBlock(ExtendedBlock eb, DatanodeStorageInfo[] storages, long pos, boolean isCorrupt) {
            ArrayList<DatanodeInfoWithStorage> locs = new ArrayList<DatanodeInfoWithStorage>();
            ArrayList<String> sids = new ArrayList<String>();
            ArrayList<StorageType> types = new ArrayList<StorageType>();
            boolean isProvidedBlock = false;
            HashSet<String> excludedUUids = new HashSet<String>();
            for (int i = 0; i < storages.length; ++i) {
                DatanodeStorageInfo currInfo = storages[i];
                StorageType storageType = currInfo.getStorageType();
                sids.add(currInfo.getStorageID());
                types.add(storageType);
                if (StorageType.PROVIDED.equals((Object)storageType)) {
                    isProvidedBlock = true;
                    continue;
                }
                locs.add(new DatanodeInfoWithStorage((DatanodeInfo)currInfo.getDatanodeDescriptor(), currInfo.getStorageID(), storageType));
                excludedUUids.add(currInfo.getDatanodeDescriptor().getDatanodeUuid());
            }
            int numLocations = locs.size();
            if (isProvidedBlock) {
                DatanodeDescriptor dn = this.chooseProvidedDatanode(excludedUUids);
                locs.add(new DatanodeInfoWithStorage((DatanodeInfo)dn, ProvidedStorageMap.this.storageId, StorageType.PROVIDED));
                excludedUUids.add(dn.getDatanodeUuid());
                for (int count = ++numLocations + 1; count <= ProvidedStorageMap.this.defaultReplication && count <= ProvidedStorageMap.this.providedDescriptor.activeProvidedDatanodes(); ++count) {
                    dn = this.chooseProvidedDatanode(excludedUUids);
                    locs.add(new DatanodeInfoWithStorage((DatanodeInfo)dn, ProvidedStorageMap.this.storageId, StorageType.PROVIDED));
                    sids.add(ProvidedStorageMap.this.storageId);
                    types.add(StorageType.PROVIDED);
                    excludedUUids.add(dn.getDatanodeUuid());
                }
            }
            return new LocatedBlock(eb, locs.toArray(new DatanodeInfoWithStorage[locs.size()]), sids.toArray(new String[sids.size()]), types.toArray(new StorageType[types.size()]), pos, isCorrupt, null);
        }

        @Override
        LocatedBlocks build(DatanodeDescriptor client) {
            return new LocatedBlocks(this.flen, this.isUC, this.blocks, this.last, this.lastComplete, this.feInfo, this.ecPolicy);
        }

        @Override
        LocatedBlocks build() {
            return this.build(ProvidedStorageMap.this.providedDescriptor.chooseRandom(new DatanodeStorageInfo[0]));
        }
    }

    static class ProvidedDatanodeStorageInfo
    extends DatanodeStorageInfo {
        ProvidedDatanodeStorageInfo(ProvidedDescriptor dn, DatanodeStorage ds) {
            super(dn, ds);
        }

        @Override
        boolean removeBlock(BlockInfo b) {
            ProvidedDescriptor dn = (ProvidedDescriptor)this.getDatanodeDescriptor();
            if (dn.activeProvidedDatanodes() == 0) {
                return super.removeBlock(b);
            }
            return false;
        }

        @Override
        void setState(DatanodeStorage.State state) {
            if (state == DatanodeStorage.State.FAILED) {
                ProvidedDescriptor dn = (ProvidedDescriptor)this.getDatanodeDescriptor();
                if (dn.activeProvidedDatanodes() == 0) {
                    LOG.info("Provided storage {} transitioning to state {}", (Object)this, (Object)DatanodeStorage.State.FAILED);
                    super.setState(state);
                }
            } else {
                super.setState(state);
            }
        }

        @Override
        public String toString() {
            return "PROVIDED-STORAGE";
        }
    }
}

