/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.XAttrHelper;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockStoragePolicySuite {
    static final Logger LOG = LoggerFactory.getLogger(BlockStoragePolicySuite.class);
    public static final String STORAGE_POLICY_XATTR_NAME = "hsm.block.storage.policy.id";
    public static final XAttr.NameSpace XAttrNS = XAttr.NameSpace.SYSTEM;
    public static final int ID_BIT_LENGTH = 4;
    private final byte defaultPolicyID;
    private final BlockStoragePolicy[] policies;

    @VisibleForTesting
    public static BlockStoragePolicySuite createDefaultSuite() {
        return BlockStoragePolicySuite.createDefaultSuite(null);
    }

    @VisibleForTesting
    public static BlockStoragePolicySuite createDefaultSuite(Configuration conf) {
        BlockStoragePolicy[] policies = new BlockStoragePolicy[16];
        byte lazyPersistId = HdfsConstants.StoragePolicy.LAZY_PERSIST.value();
        policies[lazyPersistId] = new BlockStoragePolicy(lazyPersistId, HdfsConstants.StoragePolicy.LAZY_PERSIST.name(), new StorageType[]{StorageType.RAM_DISK, StorageType.DISK}, new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.DISK}, true);
        byte allnvdimmId = HdfsConstants.StoragePolicy.ALL_NVDIMM.value();
        policies[allnvdimmId] = new BlockStoragePolicy(allnvdimmId, HdfsConstants.StoragePolicy.ALL_NVDIMM.name(), new StorageType[]{StorageType.NVDIMM}, new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.DISK});
        byte allssdId = HdfsConstants.StoragePolicy.ALL_SSD.value();
        policies[allssdId] = new BlockStoragePolicy(allssdId, HdfsConstants.StoragePolicy.ALL_SSD.name(), new StorageType[]{StorageType.SSD}, new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.DISK});
        byte onessdId = HdfsConstants.StoragePolicy.ONE_SSD.value();
        policies[onessdId] = new BlockStoragePolicy(onessdId, HdfsConstants.StoragePolicy.ONE_SSD.name(), new StorageType[]{StorageType.SSD, StorageType.DISK}, new StorageType[]{StorageType.SSD, StorageType.DISK}, new StorageType[]{StorageType.SSD, StorageType.DISK});
        byte hotId = HdfsConstants.StoragePolicy.HOT.value();
        policies[hotId] = new BlockStoragePolicy(hotId, HdfsConstants.StoragePolicy.HOT.name(), new StorageType[]{StorageType.DISK}, StorageType.EMPTY_ARRAY, new StorageType[]{StorageType.ARCHIVE});
        byte warmId = HdfsConstants.StoragePolicy.WARM.value();
        policies[warmId] = new BlockStoragePolicy(warmId, HdfsConstants.StoragePolicy.WARM.name(), new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, new StorageType[]{StorageType.DISK, StorageType.ARCHIVE});
        byte coldId = HdfsConstants.StoragePolicy.COLD.value();
        policies[coldId] = new BlockStoragePolicy(coldId, HdfsConstants.StoragePolicy.COLD.name(), new StorageType[]{StorageType.ARCHIVE}, StorageType.EMPTY_ARRAY, StorageType.EMPTY_ARRAY);
        byte providedId = HdfsConstants.StoragePolicy.PROVIDED.value();
        policies[providedId] = new BlockStoragePolicy(providedId, HdfsConstants.StoragePolicy.PROVIDED.name(), new StorageType[]{StorageType.PROVIDED, StorageType.DISK}, new StorageType[]{StorageType.PROVIDED, StorageType.DISK}, new StorageType[]{StorageType.PROVIDED, StorageType.DISK});
        return new BlockStoragePolicySuite(BlockStoragePolicySuite.getDefaultPolicyID(conf, policies), policies);
    }

    private static byte getDefaultPolicyID(Configuration conf, BlockStoragePolicy[] policies) {
        if (conf != null) {
            HdfsConstants.StoragePolicy defaultPolicy = (HdfsConstants.StoragePolicy)conf.getEnum("dfs.storage.default.policy", (Enum)DFSConfigKeys.DFS_STORAGE_DEFAULT_POLICY_DEFAULT);
            for (BlockStoragePolicy policy : policies) {
                if (policy == null || !policy.getName().equalsIgnoreCase(defaultPolicy.name())) continue;
                return policy.getId();
            }
        }
        return DFSConfigKeys.DFS_STORAGE_DEFAULT_POLICY_DEFAULT.value();
    }

    public BlockStoragePolicySuite(byte defaultPolicyID, BlockStoragePolicy[] policies) {
        this.defaultPolicyID = defaultPolicyID;
        this.policies = policies;
    }

    public BlockStoragePolicy getPolicy(byte id) {
        return id == 0 ? this.getDefaultPolicy() : this.policies[id];
    }

    public BlockStoragePolicy getDefaultPolicy() {
        return this.getPolicy(this.defaultPolicyID);
    }

    public BlockStoragePolicy getPolicy(String policyName) {
        Preconditions.checkNotNull((Object)policyName);
        if (this.policies != null) {
            for (BlockStoragePolicy policy : this.policies) {
                if (policy == null || !policy.getName().equalsIgnoreCase(policyName)) continue;
                return policy;
            }
        }
        return null;
    }

    public BlockStoragePolicy[] getAllPolicies() {
        ArrayList list = Lists.newArrayList();
        if (this.policies != null) {
            for (BlockStoragePolicy policy : this.policies) {
                if (policy == null) continue;
                list.add(policy);
            }
        }
        return list.toArray(new BlockStoragePolicy[list.size()]);
    }

    public static String buildXAttrName() {
        return StringUtils.toLowerCase((String)XAttrNS.toString()) + ".hsm.block.storage.policy.id";
    }

    public static XAttr buildXAttr(byte policyId) {
        String name = BlockStoragePolicySuite.buildXAttrName();
        return XAttrHelper.buildXAttr((String)name, (byte[])new byte[]{policyId});
    }

    public static String getStoragePolicyXAttrPrefixedName() {
        return XAttrHelper.getPrefixedName((XAttr.NameSpace)XAttrNS, (String)STORAGE_POLICY_XATTR_NAME);
    }

    public static boolean isStoragePolicyXAttr(XAttr xattr) {
        return xattr != null && xattr.getNameSpace() == XAttrNS && xattr.getName().equals(STORAGE_POLICY_XATTR_NAME);
    }
}

