/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hdfs.TestDFSStripedOutputStreamWithFailureBase;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterizedTestDFSStripedOutputStreamWithFailure
extends TestDFSStripedOutputStreamWithFailureBase {
    public static final Logger LOG = LoggerFactory.getLogger(ParameterizedTestDFSStripedOutputStreamWithFailure.class);
    private int base;

    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int i = 0; i <= 10; ++i) {
            parameters.add(new Object[]{RANDOM.nextInt(220)});
        }
        return parameters;
    }

    public void initParameterizedTestDFSStripedOutputStreamWithFailure(int pBase) {
        this.base = pBase;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=240L)
    public void runTestWithSingleFailure(int pBase) {
        int i;
        Integer length;
        this.initParameterizedTestDFSStripedOutputStreamWithFailure(pBase);
        Assumptions.assumeTrue((this.base >= 0 ? 1 : 0) != 0);
        if (this.base > this.lengths.size()) {
            this.base %= this.lengths.size();
        }
        Assumptions.assumeTrue(((length = this.getLength(i = this.base)) != null ? 1 : 0) != 0, (String)("Skip test " + i + " since length=null."));
        Assumptions.assumeTrue((RANDOM.nextInt(16) != 0 ? 1 : 0) != 0, (String)("Test " + i + ", length=" + length + ", is not chosen to run."));
        System.out.println("Run test " + i + ", length=" + length);
        this.runTest(length);
    }
}

