/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;

public class ViewFsTestSetup {
    public static String ViewFSTestDir = "/testDir";

    public static FileContext setupForViewFsLocalFs(FileContextTestHelper helper) throws Exception {
        FileContext fsTarget = FileContext.getLocalFSFileContext();
        Path targetOfTests = helper.getTestRootPath(fsTarget);
        fsTarget.delete(targetOfTests, true);
        fsTarget.mkdir(targetOfTests, FileContext.DEFAULT_PERM, true);
        Configuration conf = new Configuration();
        String testDir = helper.getTestRootPath(fsTarget).toUri().getPath();
        ViewFsTestSetup.linkUpFirstComponents(conf, testDir, fsTarget, "test dir");
        ViewFsTestSetup.setUpHomeDir(conf, fsTarget);
        String wdDir = fsTarget.getWorkingDirectory().toUri().getPath();
        ViewFsTestSetup.linkUpFirstComponents(conf, wdDir, fsTarget, "working dir");
        FileContext fc = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        fc.setWorkingDirectory(new Path(wdDir));
        Log.getLog().info("Working dir is: " + fc.getWorkingDirectory(), new Object[0]);
        return fc;
    }

    public static void tearDownForViewFsLocalFs(FileContextTestHelper helper) throws Exception {
        FileContext fclocal = FileContext.getLocalFSFileContext();
        Path targetOfTests = helper.getTestRootPath(fclocal);
        fclocal.delete(targetOfTests, true);
    }

    static void setUpHomeDir(Configuration conf, FileContext fsTarget) {
        String homeDir = fsTarget.getHomeDirectory().toUri().getPath();
        int indexOf2ndSlash = homeDir.indexOf(47, 1);
        if (indexOf2ndSlash > 0) {
            ViewFsTestSetup.linkUpFirstComponents(conf, homeDir, fsTarget, "home dir");
        } else {
            URI linkTarget = fsTarget.makeQualified(new Path(homeDir)).toUri();
            ConfigUtil.addLink((Configuration)conf, (String)homeDir, (URI)linkTarget);
            Log.getLog().info("Added link for home dir " + homeDir + "->" + linkTarget, new Object[0]);
        }
        String homeDirRoot = fsTarget.getHomeDirectory().getParent().toUri().getPath();
        ConfigUtil.setHomeDirConf((Configuration)conf, (String)homeDirRoot);
        Log.getLog().info("Home dir base for viewfs" + homeDirRoot, new Object[0]);
    }

    static void linkUpFirstComponents(Configuration conf, String path, FileContext fsTarget, String info) {
        int indexOfEnd = path.indexOf(47, 1);
        if (Shell.WINDOWS) {
            indexOfEnd = path.indexOf(47, indexOfEnd + 1);
        }
        String firstComponent = path.substring(0, indexOfEnd);
        URI linkTarget = fsTarget.makeQualified(new Path(firstComponent)).toUri();
        ConfigUtil.addLink((Configuration)conf, (String)firstComponent, (URI)linkTarget);
        Log.getLog().info("Added link for " + info + " " + firstComponent + "->" + linkTarget, new Object[0]);
    }

    static void addMountLinksToFile(String mountTable, String[] sources, String[] targets, Path mountTableConfPath, Configuration conf) throws IOException, URISyntaxException {
        ViewFileSystemOverloadScheme.ChildFsGetter cfs = new ViewFileSystemOverloadScheme.ChildFsGetter(mountTableConfPath.toUri().getScheme());
        try (FileSystem fs = cfs.getNewInstance(mountTableConfPath.toUri(), conf);
             FSDataOutputStream out = fs.create(mountTableConfPath);){
            String prefix = "fs.viewfs.mounttable" + "." + (mountTable == null ? ConfigUtil.getDefaultMountTableName((Configuration)conf) : mountTable) + ".";
            out.writeBytes("<configuration>");
            for (int i = 0; i < sources.length; ++i) {
                String src = sources[i];
                String target = targets[i];
                boolean isNfly = src.startsWith("linkNfly");
                out.writeBytes("<property><name>");
                if (isNfly) {
                    String[] srcParts = src.split("[.]");
                    Assertions.assertEquals((int)3, (int)srcParts.length, (String)"Invalid NFlyLink format");
                    String actualSrc = srcParts[srcParts.length - 1];
                    String params = srcParts[srcParts.length - 2];
                    out.writeBytes(prefix + "linkNfly." + params + "." + actualSrc);
                } else if ("linkFallback".equals(src)) {
                    out.writeBytes(prefix + "linkFallback");
                } else if ("linkMergeSlash".equals(src)) {
                    out.writeBytes(prefix + "linkMergeSlash");
                } else {
                    out.writeBytes(prefix + "link." + src);
                }
                out.writeBytes("</name>");
                out.writeBytes("<value>");
                out.writeBytes(target);
                out.writeBytes("</value></property>");
                out.flush();
            }
            out.writeBytes("</configuration>");
            out.flush();
        }
    }

    public static void addMountLinksToConf(String mountTable, String[] sources, String[] targets, Configuration config) throws URISyntaxException {
        for (int i = 0; i < sources.length; ++i) {
            String src = sources[i];
            String target = targets[i];
            String mountTableName = mountTable == null ? "default" : mountTable;
            boolean isNfly = src.startsWith("linkNfly");
            if (isNfly) {
                String[] srcParts = src.split("[.]");
                Assertions.assertEquals((int)3, (int)srcParts.length, (String)"Invalid NFlyLink format");
                String actualSrc = srcParts[srcParts.length - 1];
                String params = srcParts[srcParts.length - 2];
                ConfigUtil.addLinkNfly((Configuration)config, (String)mountTableName, (String)actualSrc, (String)params, (String)target);
                continue;
            }
            if (src.equals("linkFallback")) {
                ConfigUtil.addLinkFallback((Configuration)config, (String)mountTableName, (URI)new URI(target));
                continue;
            }
            if (src.equals("linkMergeSlash")) {
                ConfigUtil.addLinkMergeSlash((Configuration)config, (String)mountTableName, (URI)new URI(target));
                continue;
            }
            ConfigUtil.addLink((Configuration)config, (String)mountTableName, (String)src, (URI)new URI(target));
        }
    }
}

