/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.jupiter.api.Assertions;

public class HDFSContract
extends AbstractFSContract {
    public static final String CONTRACT_HDFS_XML = "contract/hdfs.xml";
    public static final int BLOCK_SIZE = 1024;
    private static MiniDFSCluster cluster;

    public HDFSContract(Configuration conf) {
        super(conf);
        this.addConfResource(CONTRACT_HDFS_XML);
    }

    public static void createCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.addResource(CONTRACT_HDFS_XML);
        conf.setInt("dfs.blocksize", 1024);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitClusterUp();
    }

    public static void destroyCluster() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    public static MiniDFSCluster getCluster() {
        return cluster;
    }

    @Override
    public void init() throws IOException {
        super.init();
        Assertions.assertTrue((boolean)this.isSupported("is-case-sensitive", false), (String)"contract options not loaded");
    }

    @Override
    public FileSystem getTestFileSystem() throws IOException {
        Assertions.assertNotNull((Object)cluster, (String)"cluster not created");
        return cluster.getFileSystem();
    }

    @Override
    public String getScheme() {
        return "hdfs";
    }

    @Override
    public Path getTestPath() {
        Path path = new Path("/test");
        return path;
    }
}

