/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractOptions;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.shaded.org.opentest4j.TestAbortedException;
import org.apache.hadoop.test.TestName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=180L)
public abstract class AbstractFSContractTestBase
extends Assertions
implements ContractOptions {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSContractTestBase.class);
    public static final int TEST_FILE_LEN = 1024;
    public static final int DEFAULT_TEST_TIMEOUT = 180000;
    private AbstractFSContract contract;
    private FileSystem fileSystem;
    private Path testPath;
    @RegisterExtension
    public TestName methodName = new TestName();

    @BeforeAll
    public static void nameTestThread() {
        Thread.currentThread().setName("JUnit");
    }

    @BeforeEach
    public void nameThread() {
        Thread.currentThread().setName("JUnit-" + this.getMethodName());
    }

    protected String getMethodName() {
        return this.methodName.getMethodName();
    }

    protected abstract AbstractFSContract createContract(Configuration var1);

    protected AbstractFSContract getContract() {
        return this.contract;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public static Logger getLogger() {
        return LOG;
    }

    protected void skipIfUnsupported(String feature) throws IOException {
        if (!this.isSupported(feature)) {
            ContractTestUtils.skip("Skipping as unsupported feature: " + feature);
        }
    }

    protected boolean isSupported(String feature) throws IOException {
        return this.contract.isSupported(feature, false);
    }

    protected void assumeEnabled() {
        if (!this.contract.isEnabled()) {
            throw new TestAbortedException("test cases disabled for " + this.contract);
        }
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected int getTestTimeoutMillis() {
        return 180000;
    }

    @BeforeEach
    public void setup() throws Exception {
        Thread.currentThread().setName("setup");
        LOG.debug("== Setup ==");
        this.contract = this.createContract(this.createConfiguration());
        this.contract.init();
        this.assumeEnabled();
        this.fileSystem = this.contract.getTestFileSystem();
        AbstractFSContractTestBase.assertNotNull((Object)this.fileSystem, (String)"null filesystem");
        URI fsURI = this.fileSystem.getUri();
        LOG.info("Test filesystem = {} implemented by {}", (Object)fsURI, (Object)this.fileSystem);
        AbstractFSContractTestBase.assertEquals((Object)this.contract.getScheme(), (Object)fsURI.getScheme(), (String)("wrong filesystem of " + fsURI));
        this.testPath = this.getContract().getTestPath();
        this.mkdirs(this.testPath);
        LOG.debug("== Setup complete ==");
    }

    @AfterEach
    public void teardown() throws Exception {
        Thread.currentThread().setName("teardown");
        LOG.debug("== Teardown ==");
        this.deleteTestDirInTeardown();
        if (this.contract != null) {
            this.contract.teardown();
        }
        LOG.debug("== Teardown complete ==");
    }

    protected void deleteTestDirInTeardown() throws IOException {
        ContractTestUtils.cleanup("TEARDOWN", this.getFileSystem(), this.testPath);
    }

    protected Path path(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(this.getContract().getTestPath(), filepath));
    }

    protected Path methodPath() throws IOException {
        return this.path(this.methodName.getMethodName());
    }

    protected Path absolutepath(String filepath) throws IOException {
        return this.getFileSystem().makeQualified(new Path(filepath));
    }

    protected String ls(Path path) throws IOException {
        return ContractTestUtils.ls(this.fileSystem, path);
    }

    protected void describe(String text) {
        LOG.info(text);
    }

    protected void handleRelaxedException(String action, String expectedException, Exception e) throws Exception {
        if (this.getContract().isSupported("supports-strict-exceptions", false)) {
            throw e;
        }
        LOG.warn("The expected exception {}  was not the exception class raised on {}: {}", new Object[]{action, e.getClass(), expectedException, e});
    }

    protected void handleExpectedException(Exception e) {
        AbstractFSContractTestBase.getLogger().debug("expected :{}", (Object)e, (Object)e);
    }

    public void assertPathExists(String message, Path path) throws IOException {
        ContractTestUtils.assertPathExists(this.fileSystem, message, path);
    }

    public void assertPathDoesNotExist(String message, Path path) throws IOException {
        ContractTestUtils.assertPathDoesNotExist(this.fileSystem, message, path);
    }

    protected void assertIsFile(Path filename) throws IOException {
        ContractTestUtils.assertIsFile(this.fileSystem, filename);
    }

    protected void assertIsDirectory(Path path) throws IOException {
        ContractTestUtils.assertIsDirectory(this.fileSystem, path);
    }

    protected void mkdirs(Path path) throws IOException {
        AbstractFSContractTestBase.assertTrue((boolean)this.fileSystem.mkdirs(path), (String)("Failed to mkdir " + path));
    }

    protected void assertDeleted(Path path, boolean recursive) throws IOException {
        ContractTestUtils.assertDeleted(this.fileSystem, path, recursive);
    }

    protected void assertMinusOne(String text, int result) {
        AbstractFSContractTestBase.assertEquals((int)-1, (int)result, (String)(text + " wrong read result " + result));
    }

    protected boolean rename(Path src, Path dst) throws IOException {
        return this.getFileSystem().rename(src, dst);
    }

    protected String generateAndLogErrorListing(Path src, Path dst) throws IOException {
        FileSystem fs = this.getFileSystem();
        AbstractFSContractTestBase.getLogger().error("src dir " + ContractTestUtils.ls(fs, src.getParent()));
        Object destDirLS = ContractTestUtils.ls(fs, dst.getParent());
        if (fs.isDirectory(dst)) {
            destDirLS = (String)destDirLS + "\n" + ContractTestUtils.ls(fs, dst);
        }
        return destDirLS;
    }
}

