/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFSContract
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFSContract.class);
    private boolean enabled = true;

    protected AbstractFSContract(Configuration conf) {
        super(conf);
        if (this.maybeAddConfResource("contract-test-options.xml")) {
            LOG.debug("Loaded authentication keys from {}", (Object)"contract-test-options.xml");
        } else {
            LOG.debug("Not loaded: {}", (Object)"contract-test-options.xml");
        }
    }

    public void init() throws IOException {
    }

    public void teardown() throws IOException {
    }

    protected void addConfResource(String resource) {
        boolean found = this.maybeAddConfResource(resource);
        Assertions.assertTrue((boolean)found, (String)("Resource not found " + resource));
    }

    protected boolean maybeAddConfResource(String resource) {
        boolean found;
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(resource);
        boolean bl = found = url != null;
        if (found) {
            this.getConf().addResource(resource);
        }
        return found;
    }

    public FileSystem getFileSystem(URI uri) throws IOException {
        return FileSystem.get((URI)uri, (Configuration)this.getConf());
    }

    public abstract FileSystem getTestFileSystem() throws IOException;

    public abstract String getScheme();

    public abstract Path getTestPath();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSupported(String feature, boolean defval) {
        return this.getConf().getBoolean(this.getConfKey(feature), defval);
    }

    public int getLimit(String feature, int defval) {
        return this.getConf().getInt(this.getConfKey(feature), defval);
    }

    public String getOption(String feature, String defval) {
        return this.getConf().get(this.getConfKey(feature), defval);
    }

    public String getConfKey(String feature) {
        return "fs.contract." + feature;
    }

    protected URI toURI(String path) throws IOException {
        try {
            return new URI(this.getScheme(), path, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString() + " with " + path, e);
        }
    }

    public String toString() {
        return "FSContract for " + this.getScheme();
    }
}

