/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.InvalidPathHandleException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.RawPathHandle;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractContractPathHandleTest
extends AbstractFSContractTestBase {
    private Options.HandleOpt[] opts;
    private boolean serialized;
    private static final byte[] B1 = ContractTestUtils.dataset(1024, 43, 255);
    private static final byte[] B2 = ContractTestUtils.dataset(1024, 44, 255);

    public void initAbstractContractPathHandleTest(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) {
        this.opts = pOpts;
        this.serialized = pSerialized;
    }

    public static Collection<Object[]> params() {
        return Arrays.asList(Arrays.asList("Exact", Options.HandleOpt.exact()), Arrays.asList("Content", Options.HandleOpt.content()), Arrays.asList("Path", Options.HandleOpt.path()), Arrays.asList("Reference", Options.HandleOpt.reference())).stream().flatMap(x -> Arrays.asList(true, false).stream().map(b -> {
            ArrayList<Boolean> y = new ArrayList<Boolean>((Collection<Boolean>)x);
            y.add((Boolean)b);
            return y;
        })).map(ArrayList::toArray).collect(Collectors.toList());
    }

    @Override
    protected Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setInt("io.file.buffer.size", 4096);
        return conf;
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testIdent(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) throws IOException {
        this.initAbstractContractPathHandleTest(pTestname, pOpts, pSerialized);
        this.describe("verify simple open, no changes");
        FileStatus stat = this.testFile(B1);
        PathHandle fd = this.getHandleOrSkip(stat);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), stat.getPath(), B1);
        try (FSDataInputStream in = this.getFileSystem().open(fd);){
            ContractTestUtils.verifyRead(in, B1, 0, 1024);
        }
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testChanged(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) throws IOException {
        this.initAbstractContractPathHandleTest(pTestname, pOpts, pSerialized);
        this.describe("verify open(PathHandle, changed(*))");
        this.assumeSupportsContentCheck();
        Options.HandleOpt.Data data = (Options.HandleOpt.Data)Options.HandleOpt.getOpt(Options.HandleOpt.Data.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
        FileStatus stat = this.testFile(B1);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        ContractTestUtils.appendFile(this.getFileSystem(), stat.getPath(), B2);
        byte[] b12 = Arrays.copyOf(B1, B1.length + B2.length);
        System.arraycopy(B2, 0, b12, B1.length, B2.length);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), stat.getPath(), b12);
        PathHandle fd = this.getHandleOrSkip(stat);
        try (FSDataInputStream in = this.getFileSystem().open(fd);){
            AbstractContractPathHandleTest.assertTrue((boolean)data.allowChange(), (String)"Failed to detect content change");
            ContractTestUtils.verifyRead(in, b12, 0, b12.length);
        }
        catch (InvalidPathHandleException e) {
            AbstractContractPathHandleTest.assertFalse((boolean)data.allowChange(), (String)"Failed to allow content change");
        }
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testMoved(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) throws IOException {
        this.initAbstractContractPathHandleTest(pTestname, pOpts, pSerialized);
        this.describe("verify open(PathHandle, moved(*))");
        this.assumeSupportsFileReference();
        Options.HandleOpt.Location loc = (Options.HandleOpt.Location)Options.HandleOpt.getOpt(Options.HandleOpt.Location.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
        FileStatus stat = this.testFile(B1);
        ContractTestUtils.rename(this.getFileSystem(), stat.getPath(), this.path(stat.getPath() + "2"));
        PathHandle fd = this.getHandleOrSkip(stat);
        try (FSDataInputStream in = this.getFileSystem().open(fd);){
            AbstractContractPathHandleTest.assertTrue((boolean)loc.allowChange(), (String)"Failed to detect location change");
            ContractTestUtils.verifyRead(in, B1, 0, B1.length);
        }
        catch (InvalidPathHandleException e) {
            AbstractContractPathHandleTest.assertFalse((boolean)loc.allowChange(), (String)"Failed to allow location change");
        }
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testChangedAndMoved(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) throws IOException {
        block9: {
            this.initAbstractContractPathHandleTest(pTestname, pOpts, pSerialized);
            this.describe("verify open(PathHandle, changed(*), moved(*))");
            this.assumeSupportsFileReference();
            this.assumeSupportsContentCheck();
            Options.HandleOpt.Data data = (Options.HandleOpt.Data)Options.HandleOpt.getOpt(Options.HandleOpt.Data.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
            Options.HandleOpt.Location loc = (Options.HandleOpt.Location)Options.HandleOpt.getOpt(Options.HandleOpt.Location.class, (Options.HandleOpt[])this.opts).orElseThrow(IllegalArgumentException::new);
            FileStatus stat = this.testFile(B1);
            Path dst = this.path(stat.getPath() + "2");
            ContractTestUtils.rename(this.getFileSystem(), stat.getPath(), dst);
            ContractTestUtils.appendFile(this.getFileSystem(), dst, B2);
            PathHandle fd = this.getHandleOrSkip(stat);
            byte[] b12 = Arrays.copyOf(B1, B1.length + B2.length);
            System.arraycopy(B2, 0, b12, B1.length, B2.length);
            try (FSDataInputStream in = this.getFileSystem().open(fd);){
                AbstractContractPathHandleTest.assertTrue((boolean)loc.allowChange(), (String)"Failed to detect location change");
                AbstractContractPathHandleTest.assertTrue((boolean)data.allowChange(), (String)"Failed to detect content change");
                ContractTestUtils.verifyRead(in, b12, 0, b12.length);
            }
            catch (InvalidPathHandleException e) {
                if (data.allowChange()) {
                    AbstractContractPathHandleTest.assertFalse((boolean)loc.allowChange(), (String)"Failed to allow location change");
                }
                if (!loc.allowChange()) break block9;
                AbstractContractPathHandleTest.assertFalse((boolean)data.allowChange(), (String)"Failed to allow content change");
            }
        }
    }

    private FileStatus testFile(byte[] content) throws IOException {
        Path path = this.path(this.methodName.getMethodName());
        ContractTestUtils.createFile(this.getFileSystem(), path, false, content);
        FileStatus stat = this.getFileSystem().getFileStatus(path);
        AbstractContractPathHandleTest.assertNotNull((Object)stat);
        AbstractContractPathHandleTest.assertEquals((Object)path, (Object)stat.getPath());
        return stat;
    }

    protected void assumeSupportsFileReference() throws IOException {
        if (this.getContract().isSupported("supports-file-reference", false)) {
            return;
        }
        ContractTestUtils.skip("Skipping as unsupported feature: supports-file-reference");
    }

    protected void assumeSupportsContentCheck() throws IOException {
        if (this.getContract().isSupported("supports-content-check", false)) {
            return;
        }
        ContractTestUtils.skip("Skipping as unsupported feature: supports-content-check");
    }

    protected PathHandle getHandleOrSkip(FileStatus stat) {
        try {
            PathHandle fd = this.getFileSystem().getPathHandle(stat, this.opts);
            if (this.serialized) {
                ByteBuffer sb = fd.bytes();
                return new RawPathHandle(sb);
            }
            return fd;
        }
        catch (UnsupportedOperationException e) {
            ContractTestUtils.skip("FileSystem does not support " + Arrays.toString(this.opts));
            return null;
        }
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testOpenFileApplyRead() throws Throwable {
        this.describe("use the apply sequence to read a whole file");
        CompletionStage readAllBytes = this.getFileSystem().openFile(this.getHandleOrSkip(this.testFile(B1))).build().thenApply(ContractTestUtils::readStream);
        AbstractContractPathHandleTest.assertEquals((long)1024L, (long)((Long)((CompletableFuture)readAllBytes).get()), (String)"Wrong number of bytes read value");
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testOpenFileDelete(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) throws Throwable {
        this.initAbstractContractPathHandleTest(pTestname, pOpts, pSerialized);
        this.describe("use the apply sequence to read a whole file");
        FileStatus testFile = this.testFile(B1);
        PathHandle handle = this.getHandleOrSkip(testFile);
        FileSystem fs = this.getFileSystem();
        fs.delete(testFile.getPath(), false);
        CompletableFuture builder = ((FutureDataInputStreamBuilder)fs.openFile(handle).opt("fs.test.something", true)).build();
        IOException ioe = LambdaTestUtils.interceptFuture(IOException.class, "", builder);
        if (!(ioe instanceof FileNotFoundException) && !(ioe instanceof InvalidPathHandleException)) {
            throw ioe;
        }
    }

    @MethodSource(value={"params"})
    @ParameterizedTest
    public void testOpenFileLazyFail(String pTestname, Options.HandleOpt[] pOpts, boolean pSerialized) throws Throwable {
        this.describe("openFile fails on a misssng file in the get() and not before");
        FileStatus stat = this.testFile(B1);
        CompletionStage readAllBytes = this.getFileSystem().openFile(this.getHandleOrSkip(stat)).build().thenApply(ContractTestUtils::readStream);
        AbstractContractPathHandleTest.assertEquals((long)1024L, (long)((Long)((CompletableFuture)readAllBytes).get()), (String)"Wrong number of bytes read value");
    }
}

