/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractContractCopyFromLocalTest
extends AbstractFSContractTestBase {
    private static final Charset ASCII = StandardCharsets.US_ASCII;
    private File file;

    @Override
    @AfterEach
    public void teardown() throws Exception {
        super.teardown();
        if (this.file != null) {
            this.file.delete();
        }
    }

    @Test
    public void testCopyEmptyFile() throws Throwable {
        this.file = File.createTempFile("test", ".txt");
        Path dest = this.copyFromLocal(this.file, true);
        this.assertPathExists("uploaded file not found", dest);
    }

    @Test
    public void testCopyFile() throws Throwable {
        String message = "hello";
        this.file = this.createTempFile(message);
        Path dest = this.copyFromLocal(this.file, true);
        this.assertPathExists("uploaded file not found", dest);
        AbstractContractCopyFromLocalTest.assertTrue((boolean)Files.exists(this.file.toPath(), new LinkOption[0]), (String)"source file deleted");
        FileSystem fs = this.getFileSystem();
        FileStatus status = fs.getFileStatus(dest);
        AbstractContractCopyFromLocalTest.assertEquals((long)message.getBytes(ASCII).length, (long)status.getLen(), (String)("File length not equal " + status));
        this.assertFileTextEquals(dest, message);
    }

    @Test
    public void testCopyFileNoOverwrite() throws Throwable {
        this.file = this.createTempFile("hello");
        this.copyFromLocal(this.file, true);
        LambdaTestUtils.intercept(PathExistsException.class, () -> this.copyFromLocal(this.file, false));
    }

    @Test
    public void testCopyFileOverwrite() throws Throwable {
        this.file = this.createTempFile("hello");
        Path dest = this.copyFromLocal(this.file, true);
        String updated = "updated";
        FileUtils.write((File)this.file, (CharSequence)updated, (Charset)ASCII);
        this.copyFromLocal(this.file, true);
        this.assertFileTextEquals(dest, updated);
    }

    @Test
    public void testCopyMissingFile() throws Throwable {
        this.describe("Copying a file that's not there must fail.");
        this.file = this.createTempFile("test");
        this.file.delete();
        LambdaTestUtils.intercept(FileNotFoundException.class, "", () -> this.copyFromLocal(this.file, true));
    }

    @Test
    public void testSourceIsFileAndDelSrcTrue() throws Throwable {
        this.describe("Source is a file delSrc flag is set to true");
        this.file = this.createTempFile("test");
        this.copyFromLocal(this.file, false, true);
        AbstractContractCopyFromLocalTest.assertFalse((boolean)Files.exists(this.file.toPath(), new LinkOption[0]), (String)"Source file not deleted");
    }

    @Test
    public void testSourceIsFileAndDestinationIsDirectory() throws Throwable {
        this.describe("Source is a file and destination is a directory. File must be copied inside the directory.");
        this.file = this.createTempFile("test");
        Path source = new Path(this.file.toURI());
        FileSystem fs = this.getFileSystem();
        File dir = this.createTempDirectory("test");
        Path destination = this.fileToPath(dir);
        fs.delete(destination, false);
        this.mkdirs(destination);
        fs.copyFromLocalFile(source, destination);
        Path expectedFile = this.path(dir.getName() + "/" + source.getName());
        this.assertPathExists("File not copied into directory", expectedFile);
    }

    @Test
    public void testSourceIsFileAndDestinationIsNonExistentDirectory() throws Throwable {
        this.describe("Source is a file and destination directory does not exist. Copy operation must still work.");
        this.file = this.createTempFile("test");
        Path source = new Path(this.file.toURI());
        FileSystem fs = this.getFileSystem();
        File dir = this.createTempDirectory("test");
        Path destination = this.fileToPath(dir);
        fs.delete(destination, false);
        this.assertPathDoesNotExist("Destination not deleted", destination);
        fs.copyFromLocalFile(source, destination);
        this.assertPathExists("Destination doesn't exist.", destination);
    }

    @Test
    public void testSrcIsDirWithFilesAndCopySuccessful() throws Throwable {
        this.describe("Source is a directory with files, copy must copy all dir contents to destination");
        String firstChild = "childOne";
        String secondChild = "childTwo";
        File parent = this.createTempDirectory("parent");
        File root = parent.getParentFile();
        File childFile = this.createTempFile(parent, firstChild, firstChild);
        File secondChildFile = this.createTempFile(parent, secondChild, secondChild);
        this.copyFromLocal(parent, false);
        this.assertPathExists("Parent directory not copied", this.fileToPath(parent));
        this.assertFileTextEquals(this.fileToPath(childFile, root), firstChild);
        this.assertFileTextEquals(this.fileToPath(secondChildFile, root), secondChild);
    }

    @Test
    public void testSrcIsEmptyDirWithCopySuccessful() throws Throwable {
        this.describe("Source is an empty directory, copy must succeed");
        File source = this.createTempDirectory("source");
        Path dest = this.copyFromLocal(source, false);
        this.assertPathExists("Empty directory not copied", dest);
    }

    @Test
    public void testSrcIsDirWithOverwriteOptions() throws Throwable {
        this.describe("Source is a directory, destination exists and must be overwritten.");
        FileSystem fs = this.getFileSystem();
        File source = this.createTempDirectory("source");
        Path sourcePath = new Path(source.toURI());
        String contents = "test file";
        File child = this.createTempFile(source, "child", contents);
        Path dest = this.path(source.getName()).getParent();
        fs.copyFromLocalFile(sourcePath, dest);
        LambdaTestUtils.intercept(PathExistsException.class, () -> fs.copyFromLocalFile(false, false, sourcePath, dest));
        String updated = "updated contents";
        FileUtils.write((File)child, (CharSequence)updated, (Charset)ASCII);
        fs.copyFromLocalFile(sourcePath, dest);
        this.assertPathExists("Parent directory not copied", this.fileToPath(source));
        this.assertFileTextEquals(this.fileToPath(child, source.getParentFile()), updated);
    }

    @Test
    public void testSrcIsDirWithDelSrcOptions() throws Throwable {
        this.describe("Source is a directory containing a file and delSrc flag is set, this must delete the source after the copy.");
        File source = this.createTempDirectory("source");
        String contents = "child file";
        File child = this.createTempFile(source, "child", contents);
        this.copyFromLocal(source, false, true);
        Path dest = this.fileToPath(child, source.getParentFile());
        AbstractContractCopyFromLocalTest.assertFalse((boolean)Files.exists(source.toPath(), new LinkOption[0]), (String)"Directory not deleted");
        this.assertFileTextEquals(dest, contents);
    }

    @Test
    public void testCopyTreeDirectoryWithoutDelete() throws Throwable {
        File srcDir = this.createTempDirectory("parent");
        File childDir = this.createTempDirectory(srcDir, "child");
        File secondChild = this.createTempDirectory(srcDir, "secondChild");
        File parentFile = this.createTempFile(srcDir, "test1", ".txt");
        File childFile = this.createTempFile(childDir, "test2", ".txt");
        this.copyFromLocal(srcDir, false, false);
        File root = srcDir.getParentFile();
        this.assertPathExists("Parent directory not found", this.fileToPath(srcDir));
        this.assertPathExists("Child directory not found", this.fileToPath(childDir, root));
        this.assertPathExists("Second child directory not found", this.fileToPath(secondChild, root));
        this.assertPathExists("Parent file not found", this.fileToPath(parentFile, root));
        this.assertPathExists("Child file not found", this.fileToPath(childFile, root));
    }

    @Test
    public void testCopyDirectoryWithDelete() throws Throwable {
        java.nio.file.Path srcDir = Files.createTempDirectory("parent", new FileAttribute[0]);
        Files.createTempFile(srcDir, "test1", ".txt", new FileAttribute[0]);
        Path src = new Path(srcDir.toUri());
        Path dst = this.path(srcDir.getFileName().toString());
        this.getFileSystem().copyFromLocalFile(true, true, src, dst);
        AbstractContractCopyFromLocalTest.assertFalse((boolean)Files.exists(srcDir, new LinkOption[0]), (String)"Source directory was not deleted");
    }

    @Test
    public void testSourceIsDirectoryAndDestinationIsFile() throws Throwable {
        this.describe("Source is a directory and destination is a file must fail");
        File file = this.createTempFile("local");
        File source = this.createTempDirectory("srcDir");
        Path destination = this.copyFromLocal(file, false);
        Path sourcePath = new Path(source.toURI());
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> this.getFileSystem().copyFromLocalFile(false, true, sourcePath, destination));
    }

    protected Path fileToPath(File file) throws IOException {
        return this.path(file.getName());
    }

    protected Path fileToPath(File file, File parent) throws IOException {
        return this.path(parent.toPath().relativize(file.toPath()).toString());
    }

    protected File createTempDirectory(String name) throws IOException {
        return Files.createTempDirectory(name, new FileAttribute[0]).toFile();
    }

    protected Path copyFromLocal(File srcFile, boolean overwrite) throws IOException {
        return this.copyFromLocal(srcFile, overwrite, false);
    }

    protected Path copyFromLocal(File srcFile, boolean overwrite, boolean delSrc) throws IOException {
        Path src = new Path(srcFile.toURI());
        Path dst = this.path(srcFile.getName());
        this.getFileSystem().copyFromLocalFile(delSrc, overwrite, src, dst);
        return dst;
    }

    protected File createTempFile(String text) throws IOException {
        File f = File.createTempFile("test", ".txt");
        FileUtils.write((File)f, (CharSequence)text, (Charset)ASCII);
        return f;
    }

    protected File createTempFile(File parent, String name, String text) throws IOException {
        File f = File.createTempFile(name, ".txt", parent);
        FileUtils.write((File)f, (CharSequence)text, (Charset)ASCII);
        return f;
    }

    protected File createTempDirectory(File parent, String name) throws IOException {
        return Files.createTempDirectory(parent.toPath(), name, new FileAttribute[0]).toFile();
    }

    private void assertFileTextEquals(Path path, String expected) throws IOException {
        AbstractContractCopyFromLocalTest.assertEquals((Object)expected, (Object)IOUtils.toString((InputStream)this.getFileSystem().open(path), (Charset)ASCII), (String)("Wrong data in " + path));
    }
}

