/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class FSMainOperationsBaseTest
extends FileSystemTestHelper {
    private static String TEST_DIR_AAA2 = "test/hadoop2/aaa";
    private static String TEST_DIR_AAA = "test/hadoop/aaa";
    private static String TEST_DIR_AXA = "test/hadoop/axa";
    private static String TEST_DIR_AXX = "test/hadoop/axx";
    private static int numBlocks = 2;
    protected FileSystem fSys;
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };
    private static final PathFilter TEST_X_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return file.getName().contains("x") || file.getName().contains("X");
        }
    };
    protected static final byte[] data = FSMainOperationsBaseTest.getFileData(numBlocks, FSMainOperationsBaseTest.getDefaultBlockSize());

    protected abstract FileSystem createFileSystem() throws Exception;

    public FSMainOperationsBaseTest() {
    }

    public FSMainOperationsBaseTest(String testRootDir) {
        super(testRootDir);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.fSys = this.createFileSystem();
        this.fSys.mkdirs(this.getTestRootPath(this.fSys, "test"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.fSys != null) {
            this.fSys.delete(new Path(this.getAbsoluteTestRootPath(this.fSys), new Path("test")), true);
        }
    }

    protected Path getDefaultWorkingDirectory() throws IOException {
        return this.getTestRootPath(this.fSys, "/user/" + System.getProperty("user.name")).makeQualified(this.fSys.getUri(), this.fSys.getWorkingDirectory());
    }

    protected boolean renameSupported() {
        return true;
    }

    protected IOException unwrapException(IOException e) {
        return e;
    }

    @Test
    public void testFsStatus() throws Exception {
        FsStatus fsStatus = this.fSys.getStatus(null);
        Assertions.assertNotNull((Object)fsStatus);
        Assertions.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = new Path(this.getAbsoluteTestRootPath(this.fSys), new Path("test"));
        this.fSys.setWorkingDirectory(workDir);
        Assertions.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        this.fSys.setWorkingDirectory(new Path("."));
        Assertions.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        this.fSys.setWorkingDirectory(new Path(".."));
        Assertions.assertEquals((Object)workDir.getParent(), (Object)this.fSys.getWorkingDirectory());
        workDir = new Path(this.getAbsoluteTestRootPath(this.fSys), new Path("test"));
        this.fSys.setWorkingDirectory(workDir);
        Assertions.assertEquals((Object)workDir, (Object)this.fSys.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(relativeDir);
        Assertions.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
        absoluteDir = this.getTestRootPath(this.fSys, "test/existingDir2");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(absoluteDir);
        Assertions.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        FSMainOperationsBaseTest.createFile(this.fSys, absolutePath);
        this.fSys.open(new Path("foo")).close();
        this.fSys.mkdirs(new Path("newDir"));
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.isDir(this.fSys, new Path(absoluteDir, "newDir")));
    }

    @Test
    public void testWDAbsolute() throws IOException {
        Path absoluteDir = this.getTestRootPath(this.fSys, "test/existingDir");
        this.fSys.mkdirs(absoluteDir);
        this.fSys.setWorkingDirectory(absoluteDir);
        Assertions.assertEquals((Object)absoluteDir, (Object)this.fSys.getWorkingDirectory());
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = this.getTestRootPath(this.fSys, "test/hadoop");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, testDir));
        this.fSys.mkdirs(testDir);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, testDir));
        this.fSys.mkdirs(testDir);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, testDir));
        Path parentDir = testDir.getParent();
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, parentDir));
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, parentDir));
        Path grandparentDir = parentDir.getParent();
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, grandparentDir));
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.isFile(this.fSys, grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.getTestRootPath(this.fSys, "test/hadoop");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        this.fSys.mkdirs(testDir);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDir));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/file"));
        Path testSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/subdir");
        try {
            this.fSys.mkdirs(testSubDir);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testSubDir));
        Path testDeepSubDir = this.getTestRootPath(this.fSys, "test/hadoop/file/deep/sub/dir");
        try {
            this.fSys.mkdirs(testDeepSubDir);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDeepSubDir));
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fSys.getFileStatus(this.getTestRootPath(this.fSys, "test/hadoop/file"));
            Assertions.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop/file"));
            Assertions.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListStatusThrowsExceptionForUnreadableDir() throws Exception {
        Path testRootDir = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        Path obscuredDir = new Path(testRootDir, "foo");
        Path subDir = new Path(obscuredDir, "bar");
        this.fSys.mkdirs(subDir);
        this.fSys.setPermission(obscuredDir, new FsPermission(0));
        try {
            this.fSys.listStatus(obscuredDir);
            Assertions.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
        }
        finally {
            this.fSys.setPermission(obscuredDir, new FsPermission(493));
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, "test/hadoop/a"), this.getTestRootPath(this.fSys, "test/hadoop/b"), this.getTestRootPath(this.fSys, "test/hadoop/c/1")};
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, testDirs[0]));
        for (Path path : testDirs) {
            this.fSys.mkdirs(path);
        }
        FileStatus[] paths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test"));
        Assertions.assertEquals((int)1, (int)paths.length);
        Assertions.assertEquals((Object)this.getTestRootPath(this.fSys, "test/hadoop"), (Object)paths[0].getPath());
        paths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop"));
        Assertions.assertEquals((int)3, (int)paths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop/a"), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop/b"), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop/c"), paths));
        paths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop/a"));
        Assertions.assertEquals((int)0, (int)paths.length);
    }

    @Test
    public void testListStatusFilterWithNoMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA2), this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test"), TEST_X_FILTER);
        Assertions.assertEquals((int)0, (int)filteredPaths.length);
    }

    @Test
    public void testListStatusFilterWithSomeMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.listStatus(this.getTestRootPath(this.fSys, "test/hadoop"), TEST_X_FILTER);
        Assertions.assertEquals((int)2, (int)filteredPaths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusNonExistentFile() throws Exception {
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoopfsdf"));
        Assertions.assertNull((Object)paths);
        paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoopfsdf/?"));
        Assertions.assertEquals((int)0, (int)paths.length);
        paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoopfsdf/xyz*/?"));
        Assertions.assertEquals((int)0, (int)paths.length);
    }

    @Test
    public void testGlobStatusWithNoMatchesInPath() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/?"));
        Assertions.assertEquals((int)0, (int)paths.length);
    }

    @Test
    public void testGlobStatusSomeMatchesInDirectories() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop*"));
        Assertions.assertEquals((int)2, (int)paths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop"), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, "test/hadoop2"), paths));
    }

    @Test
    public void testGlobStatusWithMultipleWildCardMatches() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop*/*"));
        Assertions.assertEquals((int)4, (int)paths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA2), paths));
    }

    @Test
    public void testGlobStatusWithMultipleMatchesOfSingleChar() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AAA2)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] paths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/ax?"));
        Assertions.assertEquals((int)2, (int)paths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), paths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), paths));
    }

    @Test
    public void testGlobStatusFilterWithEmptyPathResults() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/?"), DEFAULT_FILTER);
        Assertions.assertEquals((int)0, (int)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithSomePathMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/*"), DEFAULT_FILTER);
        Assertions.assertEquals((int)3, (int)filteredPaths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultipleWildCardMatchesAndTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/a??"), DEFAULT_FILTER);
        Assertions.assertEquals((int)3, (int)filteredPaths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AAA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathMatchesAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/*"), TEST_X_FILTER);
        Assertions.assertEquals((int)2, (int)filteredPaths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    @Test
    public void testGlobStatusFilterWithNoMatchingPathsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/?"), TEST_X_FILTER);
        Assertions.assertEquals((int)0, (int)filteredPaths.length);
    }

    @Test
    public void testGlobStatusFilterWithMultiplePathWildcardsAndNonTrivialFilter() throws Exception {
        Path[] testDirs = new Path[]{this.getTestRootPath(this.fSys, TEST_DIR_AAA), this.getTestRootPath(this.fSys, TEST_DIR_AXA), this.getTestRootPath(this.fSys, TEST_DIR_AXX), this.getTestRootPath(this.fSys, TEST_DIR_AXX)};
        if (!FSMainOperationsBaseTest.exists(this.fSys, testDirs[0])) {
            for (Path path : testDirs) {
                this.fSys.mkdirs(path);
            }
        }
        FileStatus[] filteredPaths = this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/a??"), TEST_X_FILTER);
        Assertions.assertEquals((int)2, (int)filteredPaths.length);
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXA), filteredPaths));
        Assertions.assertTrue((boolean)this.containsTestRootPath(this.getTestRootPath(this.fSys, TEST_DIR_AXX), filteredPaths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobStatusThrowsExceptionForUnreadableDir() throws Exception {
        Path testRootDir = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        Path obscuredDir = new Path(testRootDir, "foo");
        Path subDir = new Path(obscuredDir, "bar");
        this.fSys.mkdirs(subDir);
        this.fSys.setPermission(obscuredDir, new FsPermission(0));
        try {
            this.fSys.globStatus(this.getTestRootPath(this.fSys, "test/hadoop/dir/foo/*"));
            Assertions.fail((String)"Should throw IOException");
        }
        catch (IOException iOException) {
        }
        finally {
            this.fSys.setPermission(obscuredDir, new FsPermission(493));
        }
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(FSMainOperationsBaseTest.getDefaultBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(FSMainOperationsBaseTest.getDefaultBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        int blockSize = FSMainOperationsBaseTest.getDefaultBlockSize();
        this.writeReadAndDelete(blockSize + blockSize / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(FSMainOperationsBaseTest.getDefaultBlockSize() * 2);
    }

    protected void writeReadAndDelete(int len) throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.fSys.mkdirs(path.getParent());
        FSDataOutputStream out = this.fSys.create(path, false, 4096, (short)1, (long)FSMainOperationsBaseTest.getDefaultBlockSize());
        out.write(data, 0, len);
        out.close();
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, path), (String)"Exists");
        Assertions.assertEquals((long)len, (long)this.fSys.getFileStatus(path).getLen(), (String)"Length");
        FSDataInputStream in = this.fSys.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assertions.assertEquals((int)len, (int)buf.length);
        for (int i = 0; i < buf.length; ++i) {
            Assertions.assertEquals((byte)data[i], (byte)buf[i], (String)("Position " + i));
        }
        Assertions.assertTrue((boolean)this.fSys.delete(path, false), (String)"Deleted");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, path), (String)"No longer exists");
    }

    @Test
    public void testOverwrite() throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.fSys.mkdirs(path.getParent());
        this.createFile(path);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, path), (String)"Exists");
        Assertions.assertEquals((long)data.length, (long)this.fSys.getFileStatus(path).getLen(), (String)"Length");
        try {
            this.createFile(path);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FSDataOutputStream out = this.fSys.create(path, true, 4096);
        out.write(data, 0, data.length);
        out.close();
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, path), (String)"Exists");
        Assertions.assertEquals((long)data.length, (long)this.fSys.getFileStatus(path).getLen(), (String)"Length");
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, path.getParent()), (String)"Parent doesn't exist");
        this.createFile(path);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, path), (String)"Exists");
        Assertions.assertEquals((long)data.length, (long)this.fSys.getFileStatus(path).getLen(), (String)"Length");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, path.getParent()), (String)"Parent exists");
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = this.getTestRootPath(this.fSys, "test/hadoop/file");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, path), (String)"Doesn't exist");
        Assertions.assertFalse((boolean)this.fSys.delete(path, true), (String)"No deletion");
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = this.getTestRootPath(this.fSys, "test/hadoop");
        Path file = this.getTestRootPath(this.fSys, "test/hadoop/file");
        Path subdir = this.getTestRootPath(this.fSys, "test/hadoop/subdir");
        this.createFile(file);
        this.fSys.mkdirs(subdir);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, file), (String)"File exists");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, dir), (String)"Dir exists");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, subdir), (String)"Subdir exists");
        try {
            this.fSys.delete(dir, false);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, file), (String)"File still exists");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, dir), (String)"Dir still exists");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, subdir), (String)"Subdir still exists");
        Assertions.assertTrue((boolean)this.fSys.delete(dir, true), (String)"Deleted");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, file), (String)"File doesn't exist");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, dir), (String)"Dir doesn't exist");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, subdir), (String)"Subdir doesn't exist");
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = this.getTestRootPath(this.fSys, "test/hadoop");
        this.fSys.mkdirs(dir);
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, dir), (String)"Dir exists");
        Assertions.assertTrue((boolean)this.fSys.delete(dir, false), (String)"Deleted");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, dir), (String)"Dir doesn't exist");
    }

    @Test
    public void testRenameNonExistentPath() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/nonExistent");
        Path dst = this.getTestRootPath(this.fSys, "test/new/newpath");
        try {
            this.rename(src, dst, false, false, false, Options.Rename.NONE);
            Assertions.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Log.getLog().info("XXX", e);
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, false, false, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Should throw FileNotFoundException");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToNonExistentDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/nonExistent/newfile");
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileNotFoundException));
        }
    }

    @Test
    public void testRenameFileToDestinationWithParentFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/parentFile/newfile");
        this.createFile(dst.getParent());
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileToExistingParent() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/newfile");
        this.fSys.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Renamed file to itself");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Renamed file to itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameFileAsExistingFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/existingFile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameFileAsExistingDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/existingDir");
        this.fSys.mkdirs(dst);
        try {
            this.rename(src, dst, false, false, true, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, false, true, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToItself() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        try {
            this.rename(src, src, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Renamed directory to itself");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, src, false, true, false, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Renamed directory to itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryToNonExistentParent() throws Exception {
        block6: {
            IOException ioException;
            Path dst;
            Path src;
            block5: {
                if (!this.renameSupported()) {
                    return;
                }
                src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
                this.fSys.mkdirs(src);
                dst = this.getTestRootPath(this.fSys, "test/nonExistent/newdir");
                try {
                    this.rename(src, dst, false, true, false, Options.Rename.NONE);
                    Assertions.fail((String)"Expected exception was not thrown");
                }
                catch (IOException e) {
                    ioException = this.unwrapException(e);
                    if (ioException instanceof FileNotFoundException) break block5;
                    throw ioException;
                }
            }
            try {
                this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
                Assertions.fail((String)"Expected exception was not thrown");
            }
            catch (IOException e) {
                ioException = this.unwrapException(e);
                if (ioException instanceof FileNotFoundException) break block6;
                throw ioException;
            }
        }
    }

    @Test
    public void testRenameDirectoryAsNonExistentDirectory() throws Exception {
        this.doTestRenameDirectoryAsNonExistentDirectory(Options.Rename.NONE);
        this.tearDown();
        this.doTestRenameDirectoryAsNonExistentDirectory(Options.Rename.OVERWRITE);
    }

    private void doTestRenameDirectoryAsNonExistentDirectory(Options.Rename ... options) throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(this.fSys, "test/new/newdir");
        this.fSys.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true, options);
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/hadoop/dir/file1")), (String)"Nested file1 exists");
        Assertions.assertFalse((boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2")), (String)"Nested file2 exists");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/new/newdir/file1")), (String)"Renamed nested file1 exists");
        Assertions.assertTrue((boolean)FSMainOperationsBaseTest.exists(this.fSys, this.getTestRootPath(this.fSys, "test/new/newdir/subdir/file2")), (String)"Renamed nested exists");
    }

    @Test
    public void testRenameDirectoryAsEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(this.fSys, "test/new/newdir");
        this.fSys.mkdirs(dst);
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        this.rename(src, dst, true, false, true, Options.Rename.OVERWRITE);
    }

    @Test
    public void testRenameDirectoryAsNonEmptyDirectory() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/file1"));
        this.createFile(this.getTestRootPath(this.fSys, "test/hadoop/dir/subdir/file2"));
        Path dst = this.getTestRootPath(this.fSys, "test/new/newdir");
        this.fSys.mkdirs(dst);
        this.createFile(this.getTestRootPath(this.fSys, "test/new/newdir/file1"));
        try {
            this.rename(src, dst, false, true, false, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            this.rename(src, dst, false, true, false, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameDirectoryAsFile() throws Exception {
        if (!this.renameSupported()) {
            return;
        }
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/dir");
        this.fSys.mkdirs(src);
        Path dst = this.getTestRootPath(this.fSys, "test/new/newfile");
        this.createFile(dst);
        try {
            this.rename(src, dst, false, true, true, Options.Rename.NONE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.rename(src, dst, false, true, true, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Expected exception was not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = this.fSys.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        FSDataOutputStream out = this.fSys.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    @Test
    public void testGetWrappedInputStream() throws IOException {
        Path src = this.getTestRootPath(this.fSys, "test/hadoop/file");
        this.createFile(src);
        FSDataInputStream in = this.fSys.open(src);
        InputStream is = in.getWrappedStream();
        in.close();
        Assertions.assertNotNull((Object)is);
    }

    @Test
    public void testCopyToLocalWithUseRawLocalFileSystemOption() throws Exception {
        Configuration conf = new Configuration();
        RawLocalFileSystem fSys = new RawLocalFileSystem();
        Path fileToFS = new Path(this.getTestRootDir(), "fs.txt");
        Path fileToLFS = new Path(this.getTestRootDir(), "test.txt");
        Path crcFileAtLFS = new Path(this.getTestRootDir(), ".test.txt.crc");
        fSys.initialize(new URI("file:///"), conf);
        this.writeFile((FileSystem)fSys, fileToFS);
        if (fSys.exists(crcFileAtLFS)) {
            Assertions.assertTrue((boolean)fSys.delete(crcFileAtLFS, true), (String)"CRC files not deleted");
        }
        fSys.copyToLocalFile(false, fileToFS, fileToLFS, true);
        Assertions.assertFalse((boolean)fSys.exists(crcFileAtLFS), (String)"CRC files are created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(FileSystem fs, Path name) throws IOException {
        try (FSDataOutputStream stm = fs.create(name);){
            stm.writeBytes("42\n");
        }
    }

    protected void createFile(Path path) throws IOException {
        FSMainOperationsBaseTest.createFile(this.fSys, path);
    }

    private void rename(Path src, Path dst, boolean renameShouldSucceed, boolean srcExists, boolean dstExists, Options.Rename ... options) throws IOException {
        this.fSys.rename(src, dst, options);
        if (!renameShouldSucceed) {
            Assertions.fail((String)"rename should have thrown exception");
        }
        Assertions.assertEquals((Object)srcExists, (Object)FSMainOperationsBaseTest.exists(this.fSys, src), (String)"Source exists");
        Assertions.assertEquals((Object)dstExists, (Object)FSMainOperationsBaseTest.exists(this.fSys, dst), (String)"Destination exists");
    }

    private boolean containsTestRootPath(Path path, FileStatus[] filteredPaths) throws IOException {
        Path testRootPath = this.getTestRootPath(this.fSys, path.toString());
        for (int i = 0; i < filteredPaths.length; ++i) {
            if (!testRootPath.equals((Object)filteredPaths[i].getPath())) continue;
            return true;
        }
        return false;
    }
}

