/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DeviceRuntimeSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.MountDeviceSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.MountVolumeSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.VolumeSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.YarnRuntimeType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerRunCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerVolumeCommand;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DeviceMappingManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework.DevicePluginAdapter;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.runtime.ContainerExecutionException;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceResourceDockerRuntimePluginImpl
implements DockerCommandPlugin {
    static final Logger LOG = LoggerFactory.getLogger(DeviceResourceDockerRuntimePluginImpl.class);
    private String resourceName;
    private DevicePlugin devicePlugin;
    private DevicePluginAdapter devicePluginAdapter;
    private int maxCacheSize = 100;
    private Map<ContainerId, Set<Device>> cachedAllocation = Collections.synchronizedMap(new LRUCacheHashMap(this.maxCacheSize, true));
    private Map<ContainerId, DeviceRuntimeSpec> cachedSpec = Collections.synchronizedMap(new LRUCacheHashMap(this.maxCacheSize, true));

    public DeviceResourceDockerRuntimePluginImpl(String resourceName, DevicePlugin devicePlugin, DevicePluginAdapter devicePluginAdapter) {
        this.resourceName = resourceName;
        this.devicePlugin = devicePlugin;
        this.devicePluginAdapter = devicePluginAdapter;
    }

    @Override
    public void updateDockerRunCommand(DockerRunCommand dockerRunCommand, Container container) throws ContainerExecutionException {
        String containerId = container.getContainerId().toString();
        LOG.debug("Try to update docker run command for: {}", (Object)containerId);
        if (!this.requestedDevice(this.resourceName, container)) {
            return;
        }
        DeviceRuntimeSpec deviceRuntimeSpec = this.getRuntimeSpec(container);
        if (deviceRuntimeSpec == null) {
            LOG.warn("The device plugin: " + this.devicePlugin.getClass().getCanonicalName() + " returns null device runtime spec value for container: " + containerId);
            return;
        }
        dockerRunCommand.addRuntime(deviceRuntimeSpec.getContainerRuntime());
        LOG.debug("Handle docker container runtime type: {} for container: {}", (Object)deviceRuntimeSpec.getContainerRuntime(), (Object)containerId);
        Set<MountDeviceSpec> deviceMounts = deviceRuntimeSpec.getDeviceMounts();
        LOG.debug("Handle device mounts: {} for container: {}", deviceMounts, (Object)containerId);
        for (MountDeviceSpec mountDeviceSpec : deviceMounts) {
            dockerRunCommand.addDevice(mountDeviceSpec.getDevicePathInHost(), mountDeviceSpec.getDevicePathInContainer());
        }
        Set<MountVolumeSpec> mountVolumeSpecs = deviceRuntimeSpec.getVolumeMounts();
        LOG.debug("Handle volume mounts: {} for container: {}", mountVolumeSpecs, (Object)containerId);
        for (MountVolumeSpec mountVolumeSpec : mountVolumeSpecs) {
            if (mountVolumeSpec.getReadOnly().booleanValue()) {
                dockerRunCommand.addReadOnlyMountLocation(mountVolumeSpec.getHostPath(), mountVolumeSpec.getMountPath());
                continue;
            }
            dockerRunCommand.addReadWriteMountLocation(mountVolumeSpec.getHostPath(), mountVolumeSpec.getMountPath());
        }
        dockerRunCommand.addEnv(deviceRuntimeSpec.getEnvs());
        LOG.debug("Handle envs: {} for container: {}", deviceRuntimeSpec.getEnvs(), (Object)containerId);
    }

    @Override
    public DockerVolumeCommand getCreateDockerVolumeCommand(Container container) throws ContainerExecutionException {
        if (!this.requestedDevice(this.resourceName, container)) {
            return null;
        }
        DeviceRuntimeSpec deviceRuntimeSpec = this.getRuntimeSpec(container);
        if (deviceRuntimeSpec == null) {
            return null;
        }
        Set<VolumeSpec> volumeClaims = deviceRuntimeSpec.getVolumeSpecs();
        for (VolumeSpec volumeSec : volumeClaims) {
            if (!volumeSec.getVolumeOperation().equals("create")) continue;
            DockerVolumeCommand command = new DockerVolumeCommand("create");
            command.setDriverName(volumeSec.getVolumeDriver());
            command.setVolumeName(volumeSec.getVolumeName());
            LOG.debug("Get volume create request from plugin:{} for container: {}", volumeClaims, (Object)container.getContainerId());
            return command;
        }
        return null;
    }

    @Override
    public DockerVolumeCommand getCleanupDockerVolumesCommand(Container container) throws ContainerExecutionException {
        if (!this.requestedDevice(this.resourceName, container)) {
            return null;
        }
        Set<Device> allocated = this.getAllocatedDevices(container);
        try {
            this.devicePlugin.onDevicesReleased(allocated);
        }
        catch (Exception e) {
            LOG.warn("Exception thrown in onDeviceReleased of " + this.devicePlugin.getClass() + "for container: " + container.getContainerId().toString(), (Throwable)e);
        }
        ContainerId containerId = container.getContainerId();
        this.cachedAllocation.remove(containerId);
        this.cachedSpec.remove(containerId);
        return null;
    }

    protected boolean requestedDevice(String resName, Container container) {
        return DeviceMappingManager.getRequestedDeviceCount(resName, container.getResource()) > 0;
    }

    private Set<Device> getAllocatedDevices(Container container) {
        ContainerId containerId = container.getContainerId();
        Set<Device> allocated = this.cachedAllocation.get(containerId);
        if (allocated != null) {
            return allocated;
        }
        allocated = this.devicePluginAdapter.getDeviceMappingManager().getAllocatedDevices(this.resourceName, containerId);
        LOG.debug("Get allocation from deviceMappingManager: {}, {} for container: {}", new Object[]{allocated, this.resourceName, containerId});
        this.cachedAllocation.put(containerId, allocated);
        return allocated;
    }

    public synchronized DeviceRuntimeSpec getRuntimeSpec(Container container) {
        ContainerId containerId = container.getContainerId();
        DeviceRuntimeSpec deviceRuntimeSpec = this.cachedSpec.get(containerId);
        if (deviceRuntimeSpec == null) {
            Set<Device> allocated = this.getAllocatedDevices(container);
            if (allocated == null || allocated.size() == 0) {
                LOG.error("Cannot get allocation for container:" + containerId);
                return null;
            }
            try {
                deviceRuntimeSpec = this.devicePlugin.onDevicesAllocated(allocated, YarnRuntimeType.RUNTIME_DOCKER);
            }
            catch (Exception e) {
                LOG.error("Exception thrown in onDeviceAllocated of " + this.devicePlugin.getClass() + " for container: " + containerId, (Throwable)e);
            }
            if (deviceRuntimeSpec == null) {
                LOG.error("Null DeviceRuntimeSpec value got from " + this.devicePlugin.getClass() + " for container: " + containerId + ", please check plugin logic");
                return null;
            }
            this.cachedSpec.put(containerId, deviceRuntimeSpec);
        }
        return deviceRuntimeSpec;
    }
}

