/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.shaded.org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.Leader;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumOracleMaj
extends QuorumMaj {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumOracleMaj.class);
    private String oracle = null;
    private final AtomicBoolean needOracle = new AtomicBoolean(true);

    public QuorumOracleMaj(Map<Long, QuorumPeer.QuorumServer> allMembers, String oraclePath) {
        super(allMembers);
        this.setOracle(oraclePath);
    }

    public QuorumOracleMaj(Properties props, String oraclePath) throws QuorumPeerConfig.ConfigException {
        super(props);
        this.setOracle(oraclePath);
    }

    private void setOracle(String path) {
        if (this.oracle == null) {
            this.oracle = path;
            LOG.info("Oracle is set to {}", (Object)path);
        } else {
            LOG.warn("Oracle is already set. Ignore:{}", (Object)path);
        }
    }

    @Override
    public boolean updateNeedOracle(List<LearnerHandler> forwardingFollowers) {
        this.needOracle.set(forwardingFollowers.isEmpty() && super.getVotingMembers().size() == 2);
        return this.needOracle.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean askOracle() {
        InputStreamReader fr = null;
        try {
            fr = new FileReader(FilenameUtils.getFullPath((String)this.oracle) + FilenameUtils.getName((String)this.oracle));
            int read = fr.read();
            LOG.debug("Oracle says:{}", (Object)Character.valueOf((char)read));
            fr.close();
            boolean bl = (char)read == '1';
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.oracle == null) {
                LOG.error("Oracle is not set, return false");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean getNeedOracle() {
        return this.needOracle.get();
    }

    @Override
    public String getOraclePath() {
        return this.oracle;
    }

    @Override
    public boolean overrideQuorumDecision(List<LearnerHandler> forwardingFollowers) {
        return this.updateNeedOracle(forwardingFollowers) && this.askOracle();
    }

    @Override
    public boolean revalidateOutstandingProp(Leader self, ArrayList<Leader.Proposal> outstandingProposal, long lastCommitted) {
        LOG.debug("Start Revalidation outstandingProposals");
        try {
            block2: while (outstandingProposal.size() >= 1) {
                outstandingProposal.sort((o1, o2) -> (int)(o1.getZxid() - o2.getZxid()));
                int i = 0;
                while (i < outstandingProposal.size()) {
                    Leader.Proposal p = outstandingProposal.get(i);
                    if (p.getZxid() <= lastCommitted) continue;
                    LOG.debug("Re-validate outstanding proposal: 0x{} size:{} lastCommitted:{}", new Object[]{Long.toHexString(p.getZxid()), outstandingProposal.size(), Long.toHexString(lastCommitted)});
                    if (!self.tryToCommit(p, p.getZxid(), null)) continue block2;
                    lastCommitted = p.getZxid();
                    outstandingProposal.remove(p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        LOG.debug("Finish Revalidation outstandingProposals");
        return true;
    }

    @Override
    public boolean revalidateVoteset(SyncedLearnerTracker voteSet, boolean timeout) {
        return voteSet != null && voteSet.hasAllQuorums() && timeout;
    }

    @Override
    public boolean containsQuorum(Set<Long> ackSet) {
        if (this.oracle == null || this.getVotingMembers().size() > 2) {
            return super.containsQuorum(ackSet);
        }
        if (!super.containsQuorum(ackSet)) {
            if (this.getNeedOracle()) {
                LOG.debug("We lose the quorum, but we do not have any valid followers Oracle:{}", (Object)this.askOracle());
                return this.askOracle();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuorumOracleMaj qm = (QuorumOracleMaj)o;
        if (qm.getVersion() == super.getVersion()) {
            return true;
        }
        if (super.getAllMembers().size() != qm.getAllMembers().size()) {
            return false;
        }
        for (QuorumPeer.QuorumServer qs : super.getAllMembers().values()) {
            QuorumPeer.QuorumServer qso = qm.getAllMembers().get(qs.id);
            if (qso != null && qs.equals(qso)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 43;
    }
}

