/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLSocket;
import org.apache.hadoop.shaded.io.netty.buffer.Unpooled;
import org.apache.hadoop.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.hadoop.shaded.org.apache.zookeeper.common.X509Exception;
import org.apache.hadoop.shaded.org.apache.zookeeper.common.X509Util;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.PrependableSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnifiedServerSocket
extends ServerSocket {
    private static final Logger LOG = LoggerFactory.getLogger(UnifiedServerSocket.class);
    private X509Util x509Util;
    private final boolean allowInsecureConnection;

    public UnifiedServerSocket(X509Util x509Util, boolean allowInsecureConnection) throws IOException {
        this.x509Util = x509Util;
        this.allowInsecureConnection = allowInsecureConnection;
    }

    public UnifiedServerSocket(X509Util x509Util, boolean allowInsecureConnection, int port) throws IOException {
        super(port);
        this.x509Util = x509Util;
        this.allowInsecureConnection = allowInsecureConnection;
    }

    public UnifiedServerSocket(X509Util x509Util, boolean allowInsecureConnection, int port, int backlog) throws IOException {
        super(port, backlog);
        this.x509Util = x509Util;
        this.allowInsecureConnection = allowInsecureConnection;
    }

    public UnifiedServerSocket(X509Util x509Util, boolean allowInsecureConnection, int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
        this.x509Util = x509Util;
        this.allowInsecureConnection = allowInsecureConnection;
    }

    @Override
    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        PrependableSocket prependableSocket = new PrependableSocket(null);
        this.implAccept(prependableSocket);
        return new UnifiedSocket(this.x509Util, this.allowInsecureConnection, prependableSocket);
    }

    private static class UnifiedOutputStream
    extends OutputStream {
        private final UnifiedSocket unifiedSocket;
        private OutputStream realOutputStream;

        private UnifiedOutputStream(UnifiedSocket unifiedSocket) {
            this.unifiedSocket = unifiedSocket;
            this.realOutputStream = null;
        }

        @Override
        public void write(int b) throws IOException {
            this.getRealOutputStream().write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.getRealOutputStream().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.getRealOutputStream().write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.getRealOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            this.getRealOutputStream().close();
        }

        private OutputStream getRealOutputStream() throws IOException {
            if (this.realOutputStream == null) {
                this.realOutputStream = this.unifiedSocket.getSocket().getOutputStream();
            }
            return this.realOutputStream;
        }
    }

    private static class UnifiedInputStream
    extends InputStream {
        private final UnifiedSocket unifiedSocket;
        private InputStream realInputStream;

        private UnifiedInputStream(UnifiedSocket unifiedSocket) {
            this.unifiedSocket = unifiedSocket;
            this.realInputStream = null;
        }

        @Override
        public int read() throws IOException {
            return this.getRealInputStream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getRealInputStream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getRealInputStream().read(b, off, len);
        }

        private InputStream getRealInputStream() throws IOException {
            if (this.realInputStream == null) {
                this.realInputStream = this.unifiedSocket.getSocket().getInputStream();
            }
            return this.realInputStream;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getRealInputStream().skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.getRealInputStream().available();
        }

        @Override
        public void close() throws IOException {
            this.getRealInputStream().close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.getRealInputStream().mark(readlimit);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            this.getRealInputStream().reset();
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getRealInputStream().markSupported();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class UnifiedSocket
    extends Socket {
        private final X509Util x509Util;
        private final boolean allowInsecureConnection;
        private PrependableSocket prependableSocket;
        private SSLSocket sslSocket;
        private Mode mode;

        private UnifiedSocket(X509Util x509Util, boolean allowInsecureConnection, PrependableSocket prependableSocket) {
            this.x509Util = x509Util;
            this.allowInsecureConnection = allowInsecureConnection;
            this.prependableSocket = prependableSocket;
            this.sslSocket = null;
            this.mode = Mode.UNKNOWN;
        }

        public boolean isSecureSocket() {
            return this.mode == Mode.TLS;
        }

        public boolean isPlaintextSocket() {
            return this.mode == Mode.PLAINTEXT;
        }

        public boolean isModeKnown() {
            return this.mode != Mode.UNKNOWN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void detectMode() throws IOException {
            byte[] litmus = new byte[5];
            int oldTimeout = -1;
            int bytesRead = 0;
            int newTimeout = this.x509Util.getSslHandshakeTimeoutMillis();
            try {
                oldTimeout = this.prependableSocket.getSoTimeout();
                this.prependableSocket.setSoTimeout(newTimeout);
                bytesRead = this.prependableSocket.getInputStream().read(litmus, 0, litmus.length);
            }
            catch (SocketTimeoutException e) {
                LOG.warn("Socket mode detection timed out after {} ms, assuming PLAINTEXT", (Object)newTimeout);
            }
            finally {
                try {
                    if (oldTimeout != -1) {
                        this.prependableSocket.setSoTimeout(oldTimeout);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to restore old socket timeout value of {} ms", (Object)oldTimeout, (Object)e);
                }
            }
            if (bytesRead < 0) {
                bytesRead = 0;
            }
            if (bytesRead == litmus.length && SslHandler.isEncrypted(Unpooled.wrappedBuffer(litmus), false)) {
                try {
                    this.sslSocket = this.x509Util.createSSLSocket(this.prependableSocket, litmus);
                }
                catch (X509Exception e) {
                    throw new IOException("failed to create SSL context", e);
                }
                this.prependableSocket = null;
                this.mode = Mode.TLS;
                LOG.info("Accepted TLS connection from {} - {} - {}", new Object[]{this.sslSocket.getRemoteSocketAddress(), this.sslSocket.getSession().getProtocol(), this.sslSocket.getSession().getCipherSuite()});
            } else if (this.allowInsecureConnection) {
                this.prependableSocket.prependToInputStream(litmus, 0, bytesRead);
                this.mode = Mode.PLAINTEXT;
                LOG.info("Accepted plaintext connection from {}", (Object)this.prependableSocket.getRemoteSocketAddress());
            } else {
                this.prependableSocket.close();
                this.mode = Mode.PLAINTEXT;
                throw new IOException("Blocked insecure connection attempt");
            }
        }

        private Socket getSocketAllowUnknownMode() {
            if (this.isSecureSocket()) {
                return this.sslSocket;
            }
            return this.prependableSocket;
        }

        private Socket getSocket() throws IOException {
            if (!this.isModeKnown()) {
                this.detectMode();
            }
            if (this.mode == Mode.TLS) {
                return this.sslSocket;
            }
            return this.prependableSocket;
        }

        public SSLSocket getSslSocket() throws IOException {
            if (!this.isModeKnown()) {
                this.detectMode();
            }
            if (!this.isSecureSocket()) {
                throw new SocketException("Socket mode is not TLS");
            }
            return this.sslSocket;
        }

        @Override
        public void connect(SocketAddress endpoint) throws IOException {
            this.getSocketAllowUnknownMode().connect(endpoint);
        }

        @Override
        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            this.getSocketAllowUnknownMode().connect(endpoint, timeout);
        }

        @Override
        public void bind(SocketAddress bindpoint) throws IOException {
            this.getSocketAllowUnknownMode().bind(bindpoint);
        }

        @Override
        public InetAddress getInetAddress() {
            return this.getSocketAllowUnknownMode().getInetAddress();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.getSocketAllowUnknownMode().getLocalAddress();
        }

        @Override
        public int getPort() {
            return this.getSocketAllowUnknownMode().getPort();
        }

        @Override
        public int getLocalPort() {
            return this.getSocketAllowUnknownMode().getLocalPort();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.getSocketAllowUnknownMode().getRemoteSocketAddress();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.getSocketAllowUnknownMode().getLocalSocketAddress();
        }

        @Override
        public SocketChannel getChannel() {
            return this.getSocketAllowUnknownMode().getChannel();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new UnifiedInputStream(this);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new UnifiedOutputStream(this);
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            this.getSocketAllowUnknownMode().setTcpNoDelay(on);
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.getSocketAllowUnknownMode().getTcpNoDelay();
        }

        @Override
        public void setSoLinger(boolean on, int linger) throws SocketException {
            this.getSocketAllowUnknownMode().setSoLinger(on, linger);
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.getSocketAllowUnknownMode().getSoLinger();
        }

        @Override
        public void sendUrgentData(int data) throws IOException {
            this.getSocket().sendUrgentData(data);
        }

        @Override
        public void setOOBInline(boolean on) throws SocketException {
            this.getSocketAllowUnknownMode().setOOBInline(on);
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.getSocketAllowUnknownMode().getOOBInline();
        }

        @Override
        public synchronized void setSoTimeout(int timeout) throws SocketException {
            this.getSocketAllowUnknownMode().setSoTimeout(timeout);
        }

        @Override
        public synchronized int getSoTimeout() throws SocketException {
            return this.getSocketAllowUnknownMode().getSoTimeout();
        }

        @Override
        public synchronized void setSendBufferSize(int size) throws SocketException {
            this.getSocketAllowUnknownMode().setSendBufferSize(size);
        }

        @Override
        public synchronized int getSendBufferSize() throws SocketException {
            return this.getSocketAllowUnknownMode().getSendBufferSize();
        }

        @Override
        public synchronized void setReceiveBufferSize(int size) throws SocketException {
            this.getSocketAllowUnknownMode().setReceiveBufferSize(size);
        }

        @Override
        public synchronized int getReceiveBufferSize() throws SocketException {
            return this.getSocketAllowUnknownMode().getReceiveBufferSize();
        }

        @Override
        public void setKeepAlive(boolean on) throws SocketException {
            this.getSocketAllowUnknownMode().setKeepAlive(on);
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.getSocketAllowUnknownMode().getKeepAlive();
        }

        @Override
        public void setTrafficClass(int tc) throws SocketException {
            this.getSocketAllowUnknownMode().setTrafficClass(tc);
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.getSocketAllowUnknownMode().getTrafficClass();
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.getSocketAllowUnknownMode().setReuseAddress(on);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.getSocketAllowUnknownMode().getReuseAddress();
        }

        @Override
        public synchronized void close() throws IOException {
            this.getSocketAllowUnknownMode().close();
        }

        @Override
        public void shutdownInput() throws IOException {
            this.getSocketAllowUnknownMode().shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.getSocketAllowUnknownMode().shutdownOutput();
        }

        @Override
        public String toString() {
            return "UnifiedSocket[mode=" + this.mode.toString() + "socket=" + this.getSocketAllowUnknownMode().toString() + "]";
        }

        @Override
        public boolean isConnected() {
            return this.getSocketAllowUnknownMode().isConnected();
        }

        @Override
        public boolean isBound() {
            return this.getSocketAllowUnknownMode().isBound();
        }

        @Override
        public boolean isClosed() {
            return this.getSocketAllowUnknownMode().isClosed();
        }

        @Override
        public boolean isInputShutdown() {
            return this.getSocketAllowUnknownMode().isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.getSocketAllowUnknownMode().isOutputShutdown();
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.getSocketAllowUnknownMode().setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        private static enum Mode {
            UNKNOWN,
            PLAINTEXT,
            TLS;

        }
    }
}

