/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.admin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.AuthRequest;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.Command;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.admin.CommandResponse;

public abstract class CommandBase
implements Command {
    private final String primaryName;
    private final Set<String> names;
    private final boolean serverRequired;
    private final AuthRequest authRequest;

    protected CommandBase(List<String> names) {
        this(names, true);
    }

    protected CommandBase(List<String> names, boolean serverRequired) {
        this(names, serverRequired, null);
    }

    protected CommandBase(List<String> names, boolean serverRequired, AuthRequest authRequest) {
        if (authRequest != null && !serverRequired) {
            throw new IllegalArgumentException("An active server is required for auth check");
        }
        this.primaryName = names.get(0);
        this.names = new HashSet<String>(names);
        this.serverRequired = serverRequired;
        this.authRequest = authRequest;
    }

    @Override
    public String getPrimaryName() {
        return this.primaryName;
    }

    @Override
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    public boolean isServerRequired() {
        return this.serverRequired;
    }

    @Override
    public AuthRequest getAuthRequest() {
        return this.authRequest;
    }

    protected CommandResponse initializeResponse() {
        return new CommandResponse(this.primaryName);
    }
}

