/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.javax.ws.rs.ProcessingException;
import org.apache.hadoop.shaded.javax.ws.rs.client.Client;
import org.apache.hadoop.shaded.javax.ws.rs.client.ClientBuilder;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONException;
import org.apache.hadoop.shaded.org.codehaus.jettison.json.JSONObject;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public final class YarnWebServiceUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    private YarnWebServiceUtils() {
    }

    public static JSONObject getNodeInfoFromRMWebService(Configuration conf, String nodeId) throws ProcessingException, IllegalStateException {
        try {
            return WebAppUtils.execOnActiveRM(conf, YarnWebServiceUtils::getNodeInfoFromRM, nodeId);
        }
        catch (IllegalStateException | ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject getNodeInfoFromRM(String webAppAddress, String nodeId) {
        try (Client webServiceClient = ClientBuilder.newClient();){
            JSONObject jSONObject;
            block11: {
                Response response = (Response)webServiceClient.target(webAppAddress).path("ws").path("v1").path("cluster").path("nodes").path(nodeId).request(new String[]{"application/json"}).get(Response.class);
                try {
                    String s = (String)response.readEntity(String.class);
                    jSONObject = new JSONObject(s);
                    if (response == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
                response.close();
            }
            return jSONObject;
        }
    }

    public static String toJson(Object obj, Class<?> klass) throws Exception {
        return mapper.writerFor(klass).writeValueAsString(obj);
    }
}

