/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.shaded.javax.ws.rs.client.Client;
import org.apache.hadoop.shaded.javax.ws.rs.client.ClientBuilder;
import org.apache.hadoop.shaded.javax.ws.rs.core.Configuration;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.ClientConfig;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.spi.ConnectorProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class WebServiceClient {
    private static SSLFactory sslFactory = null;
    private static volatile WebServiceClient instance = null;
    private static boolean isHttps = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(org.apache.hadoop.conf.Configuration conf) throws Exception {
        if (instance != null) return;
        Class<WebServiceClient> clazz = WebServiceClient.class;
        synchronized (WebServiceClient.class) {
            if (instance != null) return;
            isHttps = YarnConfiguration.useHttps(conf);
            if (isHttps) {
                WebServiceClient.createSSLFactory(conf);
            }
            instance = new WebServiceClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static WebServiceClient getWebServiceClient() {
        return instance;
    }

    @VisibleForTesting
    SSLFactory getSSLFactory() {
        return sslFactory;
    }

    private static SSLFactory createSSLFactory(org.apache.hadoop.conf.Configuration conf) throws Exception {
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        return sslFactory;
    }

    public Client createClient() {
        ClientConfig cc = new ClientConfig();
        cc.connectorProvider((ConnectorProvider)this.getHttpURLConnectionFactory());
        return ClientBuilder.newClient((Configuration)cc);
    }

    @VisibleForTesting
    protected HttpUrlConnectorProvider getHttpURLConnectionFactory() {
        return new HttpUrlConnectorProvider().connectionFactory(url -> {
            HttpURLConnection conn;
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            try {
                HttpURLConnection.setFollowRedirects(false);
                conn = isHttps ? new AuthenticatedURL(new KerberosAuthenticator(), sslFactory).openConnection(url, token) : new AuthenticatedURL().openConnection(url, token);
            }
            catch (AuthenticationException e) {
                throw new IOException(e);
            }
            return conn;
        });
    }

    public static synchronized void destroy() {
        if (sslFactory != null) {
            sslFactory.destroy();
        }
        instance = null;
    }
}

