/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.nodelabels.NodeLabelsStore;
import org.apache.hadoop.yarn.nodelabels.store.AbstractFSNodeStore;
import org.apache.hadoop.yarn.nodelabels.store.FSStoreOpHandler;
import org.apache.hadoop.yarn.nodelabels.store.op.AddClusterLabelOp;
import org.apache.hadoop.yarn.nodelabels.store.op.NodeToLabelOp;
import org.apache.hadoop.yarn.nodelabels.store.op.RemoveClusterLabelOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemNodeLabelsStore
extends AbstractFSNodeStore<CommonNodeLabelsManager>
implements NodeLabelsStore {
    protected static final Logger LOG = LoggerFactory.getLogger(FileSystemNodeLabelsStore.class);
    protected static final String DEFAULT_DIR_NAME = "node-labels";
    protected static final String MIRROR_FILENAME = "nodelabel.mirror";
    protected static final String EDITLOG_FILENAME = "nodelabel.editlog";

    FileSystemNodeLabelsStore() {
        super(FSStoreOpHandler.StoreType.NODE_LABEL_STORE);
    }

    private String getDefaultFSNodeLabelsRootDir() throws IOException {
        return "file:///tmp/hadoop-yarn-" + UserGroupInformation.getCurrentUser().getShortUserName() + "/node-labels";
    }

    @Override
    public void init(Configuration conf, CommonNodeLabelsManager mgr) throws Exception {
        AbstractFSNodeStore.StoreSchema schema = new AbstractFSNodeStore.StoreSchema(EDITLOG_FILENAME, MIRROR_FILENAME);
        this.initStore(conf, new Path(conf.get("yarn.node-labels.fs-store.root-dir", this.getDefaultFSNodeLabelsRootDir())), schema, mgr);
    }

    @Override
    public void close() throws IOException {
        super.closeFSStore();
    }

    @Override
    public void updateNodeToLabelsMappings(Map<NodeId, Set<String>> nodeToLabels) throws IOException {
        NodeToLabelOp op = new NodeToLabelOp();
        this.writeToLog(op.setNodeToLabels(nodeToLabels));
    }

    @Override
    public void storeNewClusterNodeLabels(List<NodeLabel> labels) throws IOException {
        AddClusterLabelOp op = new AddClusterLabelOp();
        this.writeToLog(op.setLabels(labels));
    }

    @Override
    public void removeClusterNodeLabels(Collection<String> labels) throws IOException {
        RemoveClusterLabelOp op = new RemoveClusterLabelOp();
        this.writeToLog(op.setLabels(labels));
    }

    @Override
    public void recover() throws YarnException, IOException {
        super.recoverFromStore();
    }
}

