/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class ExtendedLogMetaRequest {
    private final String user;
    private final String appId;
    private final String containerId;
    private final MatchExpression nodeId;
    private final MatchExpression fileName;
    private final ComparisonCollection fileSize;
    private final ComparisonCollection modificationTime;

    public ExtendedLogMetaRequest(String user, String appId, String containerId, MatchExpression nodeId, MatchExpression fileName, ComparisonCollection fileSize, ComparisonCollection modificationTime) {
        this.user = user;
        this.appId = appId;
        this.containerId = containerId;
        this.nodeId = nodeId;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.modificationTime = modificationTime;
    }

    public String getUser() {
        return this.user;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public MatchExpression getNodeId() {
        return this.nodeId;
    }

    public MatchExpression getFileName() {
        return this.fileName;
    }

    public ComparisonCollection getFileSize() {
        return this.fileSize;
    }

    public ComparisonCollection getModificationTime() {
        return this.modificationTime;
    }

    public static class MatchExpression {
        private Pattern expression;

        public MatchExpression(String expression) {
            this.expression = expression != null ? Pattern.compile(expression) : null;
        }

        public boolean match(String value) {
            return this.expression == null || this.expression.matcher(value).matches();
        }

        public String toString() {
            return this.expression != null ? this.expression.pattern() : "";
        }
    }

    public static class ComparisonCollection {
        private List<ComparisonExpression> comparisonExpressions;

        public ComparisonCollection(Set<String> expressions) {
            if (expressions == null) {
                this.comparisonExpressions = Collections.emptyList();
            } else {
                List equalExpressions = expressions.stream().filter(e -> !e.startsWith(">") && !e.startsWith("<")).collect(Collectors.toList());
                if (equalExpressions.size() > 1) {
                    throw new IllegalArgumentException("Can not process more, than one exact match. Matches: " + String.join((CharSequence)" ", equalExpressions));
                }
                this.comparisonExpressions = expressions.stream().map(ComparisonExpression::new).collect(Collectors.toList());
            }
        }

        public boolean match(Long value) {
            return this.match(value, true);
        }

        public boolean match(String value) {
            if (value == null) {
                return true;
            }
            return this.match(Long.valueOf(value), true);
        }

        public boolean match(Long value, boolean defaultValue) {
            if (this.comparisonExpressions.isEmpty()) {
                return defaultValue;
            }
            return this.comparisonExpressions.stream().allMatch(expr -> expr.match(value));
        }
    }

    public static class ComparisonExpression {
        public static final String GREATER_OPERATOR = ">";
        public static final String LESSER_OPERATOR = "<";
        private String expression;
        private Predicate<Long> comparisonFn;
        private Long convertedValue;

        public ComparisonExpression(String expression) {
            if (expression == null) {
                return;
            }
            if (expression.startsWith(GREATER_OPERATOR)) {
                this.convertedValue = Long.parseLong(expression.substring(1));
                this.comparisonFn = a -> a > this.convertedValue;
            } else if (expression.startsWith(LESSER_OPERATOR)) {
                this.convertedValue = Long.parseLong(expression.substring(1));
                this.comparisonFn = a -> a < this.convertedValue;
            } else {
                this.convertedValue = Long.parseLong(expression);
                this.comparisonFn = a -> a.equals(this.convertedValue);
            }
            this.expression = expression;
        }

        public boolean match(String value) {
            return this.match(Long.valueOf(value), true);
        }

        public boolean match(Long value) {
            return this.match(value, true);
        }

        public boolean match(Long value, boolean defaultValue) {
            if (this.expression == null) {
                return defaultValue;
            }
            return this.comparisonFn.test(value);
        }

        public String toString() {
            return this.convertedValue != null ? String.valueOf(this.convertedValue) : "";
        }
    }

    public static class ExtendedLogMetaRequestBuilder {
        private String user;
        private String appId;
        private String containerId;
        private MatchExpression nodeId = new MatchExpression(null);
        private MatchExpression fileName = new MatchExpression(null);
        private ComparisonCollection fileSize = new ComparisonCollection(null);
        private ComparisonCollection modificationTime = new ComparisonCollection(null);

        public ExtendedLogMetaRequestBuilder setUser(String userName) {
            this.user = userName;
            return this;
        }

        public ExtendedLogMetaRequestBuilder setAppId(String applicationId) {
            this.appId = applicationId;
            return this;
        }

        public ExtendedLogMetaRequestBuilder setContainerId(String container) {
            this.containerId = container;
            return this;
        }

        public ExtendedLogMetaRequestBuilder setNodeId(String node) {
            try {
                this.nodeId = new MatchExpression(node);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Node Id expression is invalid", e);
            }
            return this;
        }

        public ExtendedLogMetaRequestBuilder setFileName(String file) {
            try {
                this.fileName = new MatchExpression(file);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Filename expression is invalid", e);
            }
            return this;
        }

        public ExtendedLogMetaRequestBuilder setFileSize(Set<String> fileSizes) {
            this.fileSize = new ComparisonCollection(fileSizes);
            return this;
        }

        public ExtendedLogMetaRequestBuilder setModificationTime(Set<String> modificationTimes) {
            this.modificationTime = new ComparisonCollection(modificationTimes);
            return this;
        }

        public boolean isUserSet() {
            return this.user != null;
        }

        public ExtendedLogMetaRequest build() {
            return new ExtendedLogMetaRequest(this.user, this.appId, this.containerId, this.nodeId, this.fileName, this.fileSize, this.modificationTime);
        }
    }
}

