/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.DefaultParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.shaded.org.apache.commons.cli.MissingArgumentException;
import org.apache.hadoop.shaded.org.apache.commons.cli.Option;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.shaded.org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.shaded.org.apache.commons.collections4.MapUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.util.FormattingCLIUtils;
import org.apache.hadoop.yarn.client.util.MemoryPageUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationApplicationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationApplicationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusters;
import org.apache.hadoop.yarn.server.api.protocolrecords.FederationQueueWeight;
import org.apache.hadoop.yarn.server.api.protocolrecords.FederationSubCluster;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetSubClustersRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetSubClustersResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.QueryFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.QueryFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RouterCLI
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RouterCLI.class);
    private static final String SEMICOLON = ";";
    private static final String CMD_EMPTY = "";
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_ERROR = -1;
    private static final String CMD_HELP = "-help";
    private static final String DEREGISTER_SUBCLUSTER_TITLE = "Yarn Federation Deregister SubCluster";
    private static final List<String> DEREGISTER_SUBCLUSTER_HEADER = Arrays.asList("SubCluster Id", "Deregister State", "Last HeartBeatTime", "Information", "SubCluster State");
    private static final String OPTION_SC = "sc";
    private static final String OPTION_SUBCLUSTERID = "subClusterId";
    private static final String OPTION_GET_SUBCLUSTERS = "getSubClusters";
    private static final String OPTION_DEREGISTER_SUBCLUSTER = "deregisterSubCluster";
    private static final String CMD_SUBCLUSTER = "-subCluster";
    private static final String CMD_DEREGISTER_SUBCLUSTER = "-deregisterSubCluster";
    protected static final HAAdmin.UsageInfo DEREGISTER_SUBCLUSTER_USAGE = new HAAdmin.UsageInfo("-deregisterSubCluster <-sc|--subClusterId>", "This command is used to deregister subCluster, If the interval between the heartbeat time of the subCluster andthe current time exceeds the timeout period, set the state of the subCluster to SC_LOST.");
    protected static final String DEREGISTER_SUBCLUSTER_EXAMPLE_1 = "yarn routeradmin -subCluster -deregisterSubCluster -sc SC-1";
    protected static final String DEREGISTER_SUBCLUSTER_EXAMPLE_2 = "yarn routeradmin -subCluster -deregisterSubCluster --subClusterId SC-1";
    protected static final String DEREGISTER_SUBCLUSTER_HELP_INFO = "deregister subCluster, If the interval between the heartbeat time of the subCluster andthe current time exceeds the timeout period, set the state of the subCluster to SC_LOST.";
    protected static final HAAdmin.UsageInfo GET_SUBCLUSTER_USAGE = new HAAdmin.UsageInfo("-getSubClusters", "This command is used to get information about all subclusters.");
    private static final String GET_SUBCLUSTER_TITLE = "Yarn Federation SubCluster";
    private static final List<String> GET_SUBCLUSTER_HEADER = Arrays.asList("SubCluster Id", "SubCluster State", "Last HeartBeatTime");
    protected static final String GET_SUBCLUSTER_EXAMPLE = "yarn routeradmin -subCluster -getSubClusters";
    protected static final RouterCmdUsageInfos SUBCLUSTER_USAGEINFOS = new RouterCmdUsageInfos().addUsageInfo(DEREGISTER_SUBCLUSTER_USAGE).addExampleDescs(RouterCLI.DEREGISTER_SUBCLUSTER_USAGE.args, "If we want to deregisterSubCluster SC-1").addExample(RouterCLI.DEREGISTER_SUBCLUSTER_USAGE.args, "yarn routeradmin -subCluster -deregisterSubCluster -sc SC-1").addExample(RouterCLI.DEREGISTER_SUBCLUSTER_USAGE.args, "yarn routeradmin -subCluster -deregisterSubCluster --subClusterId SC-1").addUsageInfo(GET_SUBCLUSTER_USAGE).addExampleDescs(RouterCLI.GET_SUBCLUSTER_USAGE.args, "If we want to get information about all subClusters in Federation").addExample(RouterCLI.GET_SUBCLUSTER_USAGE.args, "yarn routeradmin -subCluster -getSubClusters");
    private static final String CMD_POLICY = "-policy";
    private static final String OPTION_S = "s";
    private static final String OPTION_SAVE = "save";
    private static final String OPTION_BATCH_S = "bs";
    private static final String OPTION_BATCH_SAVE = "batch-save";
    private static final String OPTION_FORMAT = "format";
    private static final String FORMAT_XML = "xml";
    private static final String OPTION_FILE = "f";
    private static final String OPTION_INPUT_FILE = "input-file";
    private static final String OPTION_L = "l";
    private static final String OPTION_LIST = "list";
    private static final String OPTION_PAGE_SIZE = "pageSize";
    private static final String OPTION_CURRENT_PAGE = "currentPage";
    private static final String OPTION_QUEUE = "queue";
    private static final String OPTION_QUEUES = "queues";
    private static final String OPTION_D = "d";
    private static final String OPTION_DELETE = "delete";
    private static final String XML_TAG_SUBCLUSTERIDINFO = "subClusterIdInfo";
    private static final String XML_TAG_AMRMPOLICYWEIGHTS = "amrmPolicyWeights";
    private static final String XML_TAG_ROUTERPOLICYWEIGHTS = "routerPolicyWeights";
    private static final String XML_TAG_HEADROOMALPHA = "headroomAlpha";
    private static final String XML_TAG_FEDERATION_WEIGHTS = "federationWeights";
    private static final String XML_TAG_QUEUE = "queue";
    private static final String XML_TAG_NAME = "name";
    private static final String LIST_POLICIES_TITLE = "Yarn Federation Queue Policies";
    private static final List<String> LIST_POLICIES_HEADER = Arrays.asList("Queue Name", "AMRM Weight", "Router Weight");
    protected static final HAAdmin.UsageInfo POLICY_SAVE_USAGE = new HAAdmin.UsageInfo("-s|--save (<queue;router weight;amrm weight;headroomalpha>)", "This command is used to save the policy information of the queue, including queue and weight information.");
    protected static final String POLICY_SAVE_USAGE_EXAMPLE_DESC = "We have two sub-clusters, SC-1 and SC-2. \\We want to configure a weight policy for the 'root.a' queue. \\The Router Weight is set to SC-1 with a weight of 0.7 and SC-2 with a weight of 0.3. \\The AMRM Weight is set SC-1 to 0.6 and SC-2 to 0.4. \\We are using the default value of 0.1 for headroomalpha.";
    protected static final String POLICY_SAVE_USAGE_EXAMPLE_1 = "yarn routeradmin -policy -s root.a;SC-1:0.7,SC-2:0.3;SC-1:0.6,SC-2:0.4;1.0";
    protected static final String POLICY_SAVE_USAGE_EXAMPLE_2 = "yarn routeradmin -policy --save root.a;SC-1:0.7,SC-2:0.3;SC-1:0.6,SC-2:0.4;1.0";
    protected static final HAAdmin.UsageInfo POLICY_BATCH_SAVE_USAGE = new HAAdmin.UsageInfo("-bs|--batch-save (--format <xml>) (-f|--input-file <fileName>)", "This command can batch load weight information for queues based on the provided `federation-weights.xml` file.");
    protected static final String POLICY_BATCH_SAVE_USAGE_EXAMPLE_DESC = "We have two sub-clusters, SC-1 and SC-2. \\We would like to configure weights for 'root.a' and 'root.b' queues. \\We can set the weights for 'root.a' and 'root.b' in the 'federation-weights.xml' file. \\and then use the batch-save command to save the configurations in bulk.";
    protected static final String POLICY_BATCH_SAVE_USAGE_EXAMPLE_1 = "yarn routeradmin -policy -bs --format xml -f federation-weights.xml";
    protected static final String POLICY_BATCH_SAVE_USAGE_EXAMPLE_2 = "yarn routeradmin -policy --batch-save --format xml -f federation-weights.xml";
    protected static final HAAdmin.UsageInfo POLICY_LIST_USAGE = new HAAdmin.UsageInfo("-l|--list [--pageSize][--currentPage][--queue][--queues]", "This command is used to display the configured queue weight information.");
    protected static final String POLICY_LIST_USAGE_EXAMPLE_DESC = "We can display the list of already configured queue weight information. \\We can use the --queue option to query the weight information for a specific queue \\ or use the --queues option to query the weight information for multiple queues. \\";
    protected static final String POLICY_LIST_USAGE_EXAMPLE_1 = "yarn routeradmin -policy -l --pageSize 20 --currentPage 1 --queue root.a";
    protected static final String POLICY_LIST_USAGE_EXAMPLE_2 = "yarn routeradmin -policy -list --pageSize 20 --currentPage 1 --queues root.a,root.b";
    protected static final HAAdmin.UsageInfo POLICY_DELETE_USAGE = new HAAdmin.UsageInfo("-d|--delete [--queue]", "This command is used to delete the policy of the queue.");
    protected static final String POLICY_DELETE_USAGE_EXAMPLE_DESC = "We delete the weight information of root.a. \\We can use --queue to specify the name of the queue.";
    protected static final String POLICY_DELETE_USAGE_EXAMPLE1 = "yarn routeradmin -policy -d --queue root.a";
    protected static final String POLICY_DELETE_USAGE_EXAMPLE2 = "yarn routeradmin -policy --delete --queue root.a";
    protected static final RouterCmdUsageInfos POLICY_USAGEINFOS = new RouterCmdUsageInfos().addUsageInfo(POLICY_SAVE_USAGE).addExampleDescs(RouterCLI.POLICY_SAVE_USAGE.args, "We have two sub-clusters, SC-1 and SC-2. \\We want to configure a weight policy for the 'root.a' queue. \\The Router Weight is set to SC-1 with a weight of 0.7 and SC-2 with a weight of 0.3. \\The AMRM Weight is set SC-1 to 0.6 and SC-2 to 0.4. \\We are using the default value of 0.1 for headroomalpha.").addExample(RouterCLI.POLICY_SAVE_USAGE.args, "yarn routeradmin -policy -s root.a;SC-1:0.7,SC-2:0.3;SC-1:0.6,SC-2:0.4;1.0").addExample(RouterCLI.POLICY_SAVE_USAGE.args, "yarn routeradmin -policy --save root.a;SC-1:0.7,SC-2:0.3;SC-1:0.6,SC-2:0.4;1.0").addUsageInfo(POLICY_BATCH_SAVE_USAGE).addExampleDescs(RouterCLI.POLICY_BATCH_SAVE_USAGE.args, "We have two sub-clusters, SC-1 and SC-2. \\We would like to configure weights for 'root.a' and 'root.b' queues. \\We can set the weights for 'root.a' and 'root.b' in the 'federation-weights.xml' file. \\and then use the batch-save command to save the configurations in bulk.").addExample(RouterCLI.POLICY_BATCH_SAVE_USAGE.args, "yarn routeradmin -policy -bs --format xml -f federation-weights.xml").addExample(RouterCLI.POLICY_BATCH_SAVE_USAGE.args, "yarn routeradmin -policy --batch-save --format xml -f federation-weights.xml").addUsageInfo(POLICY_LIST_USAGE).addExampleDescs(RouterCLI.POLICY_LIST_USAGE.args, "We can display the list of already configured queue weight information. \\We can use the --queue option to query the weight information for a specific queue \\ or use the --queues option to query the weight information for multiple queues. \\").addExample(RouterCLI.POLICY_LIST_USAGE.args, "yarn routeradmin -policy -l --pageSize 20 --currentPage 1 --queue root.a").addExample(RouterCLI.POLICY_LIST_USAGE.args, "yarn routeradmin -policy -list --pageSize 20 --currentPage 1 --queues root.a,root.b").addUsageInfo(POLICY_DELETE_USAGE).addExampleDescs(RouterCLI.POLICY_DELETE_USAGE.args, "We delete the weight information of root.a. \\We can use --queue to specify the name of the queue.").addExample(RouterCLI.POLICY_DELETE_USAGE.args, "yarn routeradmin -policy -d --queue root.a").addExample(RouterCLI.POLICY_DELETE_USAGE.args, "yarn routeradmin -policy --delete --queue root.a");
    private static final String CMD_APPLICATION = "-application";
    protected static final HAAdmin.UsageInfo APPLICATION_DELETE_USAGE = new HAAdmin.UsageInfo("--delete <application_id>", "This command is used to delete the specified application.");
    protected static final String APPLICATION_DELETE_USAGE_EXAMPLE_DESC = "If we want to delete application_1440536969523_0001.";
    protected static final String APPLICATION_DELETE_USAGE_EXAMPLE_1 = "yarn routeradmin -application --delete application_1440536969523_0001";
    protected static final RouterCmdUsageInfos APPLICATION_USAGEINFOS = new RouterCmdUsageInfos().addUsageInfo(APPLICATION_DELETE_USAGE).addExampleDescs(RouterCLI.APPLICATION_DELETE_USAGE.args, "If we want to delete application_1440536969523_0001.").addExample(RouterCLI.APPLICATION_DELETE_USAGE.args, "yarn routeradmin -application --delete application_1440536969523_0001");
    private static final String OPTION_DELETE_APP = "delete";
    protected static final Map<String, RouterCmdUsageInfos> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-subCluster", (Object)SUBCLUSTER_USAGEINFOS).put((Object)"-policy", (Object)POLICY_USAGEINFOS).put((Object)"-application", (Object)APPLICATION_USAGEINFOS).build();

    public RouterCLI() {
    }

    public RouterCLI(Configuration conf) {
        super(conf);
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        RouterCmdUsageInfos routerUsageInfo = ADMIN_USAGE.get(cmd);
        if (routerUsageInfo == null) {
            return;
        }
        builder.append("[").append(cmd).append("]\n");
        if (!routerUsageInfo.helpInfos.isEmpty()) {
            builder.append("\t Description: \n");
            for (String helpInfo : routerUsageInfo.helpInfos) {
                builder.append("\t\t").append(helpInfo).append("\n\n");
            }
        }
        if (!routerUsageInfo.usageInfos.isEmpty()) {
            builder.append("\t UsageInfos: \n");
            for (HAAdmin.UsageInfo usageInfo : routerUsageInfo.usageInfos) {
                builder.append("\t\t").append(usageInfo.args).append(": ").append("\n\t\t").append(usageInfo.help).append("\n\n");
            }
        }
        if (MapUtils.isNotEmpty(routerUsageInfo.examples)) {
            builder.append("\t Examples: \n");
            int count = 1;
            for (Map.Entry<String, List<String>> example : routerUsageInfo.examples.entrySet()) {
                String keyCmd = example.getKey();
                builder.append("\t\t").append("Cmd:").append(count).append(". ").append(keyCmd).append(": \n\n");
                List<String> exampleDescs = routerUsageInfo.exampleDescs.get(keyCmd);
                if (CollectionUtils.isNotEmpty(exampleDescs)) {
                    builder.append("\t\t").append("Cmd Requirement Description:\n");
                    for (String value : exampleDescs) {
                        String[] valueDescs;
                        for (String valueDesc : valueDescs = StringUtils.split((String)value, (String)"\\")) {
                            builder.append("\t\t").append(valueDesc).append("\n");
                        }
                    }
                }
                builder.append("\n");
                List<String> valueExamples = example.getValue();
                if (CollectionUtils.isNotEmpty(valueExamples)) {
                    builder.append("\t\t").append("Cmd Examples:\n");
                    for (String valueExample : valueExamples) {
                        builder.append("\t\t").append(valueExample).append("\n");
                    }
                }
                builder.append("\n");
                ++count;
            }
        }
    }

    private static void printHelp() {
        StringBuilder summary = new StringBuilder();
        summary.append("routeradmin is the command to execute ").append("YARN Federation administrative commands.\n").append("The full syntax is: \n\n").append("routeradmin\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RouterCLI.buildHelpMsg(cmdKey, helpBuilder);
            helpBuilder.append("\n");
        }
        helpBuilder.append("   -help [cmd]: Displays help for the given command or all commands").append(" if none is specified.");
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage(System.out);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return ClientRMProxy.createRMProxy(conf, ResourceManagerAdministrationProtocol.class);
    }

    private static void buildUsageMsg(StringBuilder builder) {
        builder.append("routeradmin is only used in Yarn Federation Mode.\n");
        builder.append("Usage: routeradmin\n");
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RouterCLI.buildHelpMsg(cmdKey, builder);
            builder.append("\n");
        }
        builder.append("   -help [cmd]\n");
    }

    private static void printUsage(String cmd) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd)) {
            RouterCLI.buildHelpMsg(cmd, usageBuilder);
        } else {
            RouterCLI.buildUsageMsg(usageBuilder);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage(System.err);
    }

    private int handleSubCluster(String[] args) throws ParseException, IOException, YarnException {
        CommandLine cliParser;
        Options opts = new Options();
        opts.addOption("subCluster", false, "We provide a set of commands for SubCluster Include deregisterSubCluster, get SubClusters.");
        opts.addOption(OPTION_DEREGISTER_SUBCLUSTER, false, "Deregister YARN subCluster, if subCluster Heartbeat Timeout.");
        opts.addOption(OPTION_GET_SUBCLUSTERS, false, "Get information about all subClusters of Federation.");
        Option subClusterOpt = new Option(OPTION_SC, OPTION_SUBCLUSTERID, true, "The subCluster can be specified using either the '-sc' or '--subCluster' option.  If the subCluster's Heartbeat Timeout, it will be marked as 'SC_LOST'.");
        subClusterOpt.setOptionalArg(true);
        opts.addOption(subClusterOpt);
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options");
            RouterCLI.printUsage(args[0]);
            return -1;
        }
        if (cliParser.hasOption(OPTION_DEREGISTER_SUBCLUSTER)) {
            String subClusterId = null;
            if ((cliParser.hasOption(OPTION_SC) || cliParser.hasOption(OPTION_SUBCLUSTERID)) && (subClusterId = cliParser.getOptionValue(OPTION_SC)) == null) {
                subClusterId = cliParser.getOptionValue(OPTION_SUBCLUSTERID);
            }
            return this.handleDeregisterSubCluster(subClusterId);
        }
        if (cliParser.hasOption(OPTION_GET_SUBCLUSTERS)) {
            return this.handleGetSubClusters();
        }
        RouterCLI.printUsage(args[0]);
        return -1;
    }

    private int handleGetSubClusters() throws IOException, YarnException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        GetSubClustersRequest request = GetSubClustersRequest.newInstance();
        GetSubClustersResponse response = adminProtocol.getFederationSubClusters(request);
        FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(GET_SUBCLUSTER_TITLE).addHeaders(GET_SUBCLUSTER_HEADER);
        List<FederationSubCluster> federationSubClusters = response.getFederationSubClusters();
        federationSubClusters.forEach(federationSubCluster -> {
            String responseSubClusterId = federationSubCluster.getSubClusterId();
            String state = federationSubCluster.getSubClusterState();
            String lastHeartBeatTime = federationSubCluster.getLastHeartBeatTime();
            formattingCLIUtils.addLine(responseSubClusterId, state, lastHeartBeatTime);
        });
        writer.print(formattingCLIUtils.render());
        writer.flush();
        return 0;
    }

    private int handleDeregisterSubCluster(String subClusterId) throws IOException, YarnException, ParseException {
        if (StringUtils.isNotBlank((CharSequence)subClusterId)) {
            return this.deregisterSubCluster(subClusterId);
        }
        return this.deregisterSubCluster();
    }

    private int deregisterSubCluster(String subClusterId) throws IOException, YarnException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        DeregisterSubClusterRequest request = DeregisterSubClusterRequest.newInstance(subClusterId);
        DeregisterSubClusterResponse response = adminProtocol.deregisterSubCluster(request);
        FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(DEREGISTER_SUBCLUSTER_TITLE).addHeaders(DEREGISTER_SUBCLUSTER_HEADER);
        List<DeregisterSubClusters> deregisterSubClusters = response.getDeregisterSubClusters();
        deregisterSubClusters.forEach(deregisterSubCluster -> {
            String responseSubClusterId = deregisterSubCluster.getSubClusterId();
            String deregisterState = deregisterSubCluster.getDeregisterState();
            String lastHeartBeatTime = deregisterSubCluster.getLastHeartBeatTime();
            String info = deregisterSubCluster.getInformation();
            String subClusterState = deregisterSubCluster.getSubClusterState();
            formattingCLIUtils.addLine(responseSubClusterId, deregisterState, lastHeartBeatTime, info, subClusterState);
        });
        writer.print(formattingCLIUtils.render());
        writer.flush();
        return 0;
    }

    private int deregisterSubCluster() throws IOException, YarnException {
        this.deregisterSubCluster(CMD_EMPTY);
        return 0;
    }

    private int handlePolicy(String[] args) throws IOException, YarnException, ParseException {
        CommandLine cliParser;
        Options opts = new Options();
        opts.addOption("policy", false, "We provide a set of commands for Policy Include list policies, save policies, batch save policies.");
        Option saveOpt = new Option(OPTION_S, OPTION_SAVE, true, "We will save the policy information of the queue, including queue and weight information");
        saveOpt.setOptionalArg(true);
        Option batchSaveOpt = new Option(OPTION_BATCH_S, OPTION_BATCH_SAVE, false, "We will save queue policies in bulk, where users can provide XML files containing the policies. This command will parse the file contents and store the results in the FederationStateStore.");
        Option formatOpt = new Option(null, OPTION_FORMAT, true, "Users can specify the file format using this option. Currently, there are one supported file formats: XML.These files contain the policy information for storing queue policies.");
        Option fileOpt = new Option(OPTION_FILE, OPTION_INPUT_FILE, true, "The location of the input configuration file. ");
        formatOpt.setOptionalArg(true);
        Option listOpt = new Option(OPTION_L, OPTION_LIST, false, "We can display the configured queue strategy according to the parameters.");
        Option pageSizeOpt = new Option(null, OPTION_PAGE_SIZE, true, "The number of policies displayed per page.");
        Option currentPageOpt = new Option(null, OPTION_CURRENT_PAGE, true, "Since users may configure numerous policies, we will choose to display them in pages. This parameter represents the page number to be displayed.");
        Option queueOpt = new Option(null, "queue", true, "the queue we need to filter. example: root.a");
        Option queuesOpt = new Option(null, OPTION_QUEUES, true, "list of queues to filter. example: root.a,root.b,root.c");
        Option deleteOpt = new Option(OPTION_D, "delete", false, CMD_EMPTY);
        opts.addOption(saveOpt);
        opts.addOption(batchSaveOpt);
        opts.addOption(formatOpt);
        opts.addOption(fileOpt);
        opts.addOption(listOpt);
        opts.addOption(pageSizeOpt);
        opts.addOption(currentPageOpt);
        opts.addOption(queueOpt);
        opts.addOption(queuesOpt);
        opts.addOption(deleteOpt);
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options");
            RouterCLI.printUsage(args[0]);
            return -1;
        }
        if (cliParser.hasOption(OPTION_S) || cliParser.hasOption(OPTION_SAVE)) {
            String policy = cliParser.getOptionValue(OPTION_S);
            if (StringUtils.isBlank((CharSequence)policy)) {
                policy = cliParser.getOptionValue(OPTION_SAVE);
            }
            return this.handleSavePolicy(policy);
        }
        if (cliParser.hasOption(OPTION_BATCH_S) || cliParser.hasOption(OPTION_BATCH_SAVE)) {
            String format = null;
            if (cliParser.hasOption(OPTION_FORMAT) && (StringUtils.isBlank((CharSequence)(format = cliParser.getOptionValue(OPTION_FORMAT))) || !StringUtils.equalsAnyIgnoreCase((CharSequence)format, (CharSequence[])new CharSequence[]{FORMAT_XML}))) {
                System.out.println("We currently only support policy configuration files in XML formats.");
                return -1;
            }
            String filePath = null;
            if ((cliParser.hasOption(OPTION_FILE) || cliParser.hasOption(OPTION_INPUT_FILE)) && StringUtils.isBlank((CharSequence)(filePath = cliParser.getOptionValue(OPTION_FILE)))) {
                filePath = cliParser.getOptionValue(OPTION_INPUT_FILE);
            }
            return this.handBatchSavePolicies(format, filePath);
        }
        if (cliParser.hasOption(OPTION_L) || cliParser.hasOption(OPTION_LIST)) {
            int pageSize = 10;
            if (cliParser.hasOption(OPTION_PAGE_SIZE)) {
                pageSize = Integer.parseInt(cliParser.getOptionValue(OPTION_PAGE_SIZE));
            }
            int currentPage = 1;
            if (cliParser.hasOption(OPTION_CURRENT_PAGE)) {
                currentPage = Integer.parseInt(cliParser.getOptionValue(OPTION_CURRENT_PAGE));
            }
            String queue = null;
            if (cliParser.hasOption("queue")) {
                queue = cliParser.getOptionValue("queue");
            }
            List queues = null;
            if (cliParser.hasOption(OPTION_QUEUES)) {
                String tmpQueues = cliParser.getOptionValue(OPTION_QUEUES);
                queues = Arrays.stream(tmpQueues.split(",")).collect(Collectors.toList());
            }
            return this.handListPolicies(pageSize, currentPage, queue, queues);
        }
        if (cliParser.hasOption(OPTION_D) || cliParser.hasOption("delete")) {
            String queue = cliParser.getOptionValue("queue");
            return this.handDeletePolicy(queue);
        }
        RouterCLI.printUsage(args[0]);
        return -1;
    }

    private int handleSavePolicy(String policy) {
        LOG.info("Save Federation Policy = {}.", (Object)policy);
        try {
            SaveFederationQueuePolicyRequest request = this.parsePolicy(policy);
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            SaveFederationQueuePolicyResponse response = adminProtocol.saveFederationQueuePolicy(request);
            System.out.println(response.getMessage());
            return 0;
        }
        catch (IOException | YarnException e) {
            LOG.error("handleSavePolicy error.", (Throwable)e);
            return -1;
        }
    }

    private int handBatchSavePolicies(String format, String policyFile) {
        if (StringUtils.isBlank((CharSequence)format)) {
            LOG.error("Batch Save Federation Policies. Format is Empty.");
            return -1;
        }
        if (StringUtils.isBlank((CharSequence)policyFile)) {
            LOG.error("Batch Save Federation Policies. policyFile is Empty.");
            return -1;
        }
        LOG.info("Batch Save Federation Policies. Format = {}, PolicyFile = {}.", (Object)format, (Object)policyFile);
        switch (format) {
            case "xml": {
                return this.parseXml2PoliciesAndBatchSavePolicies(policyFile);
            }
        }
        System.out.println("We currently only support XML formats.");
        return -1;
    }

    protected SaveFederationQueuePolicyRequest parsePolicy(String policy) throws YarnException {
        String[] policyItems = policy.split(SEMICOLON);
        if (policyItems == null || policyItems.length != 4) {
            throw new YarnException("The policy cannot be empty or the policy is incorrect. \n Required information to provide: queue,router weight,amrm weight,headroomalpha \n eg. root.a;SC-1:0.7,SC-2:0.3;SC-1:0.7,SC-2:0.3;1.0");
        }
        String queue = policyItems[0];
        String routerWeight = policyItems[1];
        String amrmWeight = policyItems[2];
        String headroomalpha = policyItems[3];
        LOG.info("Policy: [Queue = {}, RouterWeight = {}, AmRmWeight = {}, Headroomalpha = {}]", new Object[]{queue, routerWeight, amrmWeight, headroomalpha});
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid(routerWeight);
        FederationQueueWeight.checkSubClusterQueueWeightRatioValid(amrmWeight);
        FederationQueueWeight.checkHeadRoomAlphaValid(headroomalpha);
        FederationQueueWeight federationQueueWeight = FederationQueueWeight.newInstance(routerWeight, amrmWeight, headroomalpha);
        String policyManager = this.getConf().get("yarn.federation.policy-manager", "org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager");
        SaveFederationQueuePolicyRequest request = SaveFederationQueuePolicyRequest.newInstance(queue, federationQueueWeight, policyManager);
        return request;
    }

    protected int parseXml2PoliciesAndBatchSavePolicies(String policiesXml) {
        try {
            List<FederationQueueWeight> federationQueueWeightsList = this.parsePoliciesByXml(policiesXml);
            MemoryPageUtils memoryPageUtils = new MemoryPageUtils(20);
            federationQueueWeightsList.forEach(federationQueueWeight -> memoryPageUtils.addToMemory(federationQueueWeight));
            int pages = memoryPageUtils.getPages();
            for (int i = 0; i < pages; ++i) {
                List<FederationQueueWeight> federationQueueWeights = memoryPageUtils.readFromMemory(i);
                BatchSaveFederationQueuePoliciesRequest request = BatchSaveFederationQueuePoliciesRequest.newInstance(federationQueueWeights);
                ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
                BatchSaveFederationQueuePoliciesResponse response = adminProtocol.batchSaveFederationQueuePolicies(request);
                System.out.println("page <" + (i + 1) + "> : " + response.getMessage());
            }
        }
        catch (Exception e) {
            LOG.error("BatchSaveFederationQueuePolicies error", (Throwable)e);
        }
        return -1;
    }

    protected List<FederationQueueWeight> parsePoliciesByXml(String policiesXml) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<FederationQueueWeight> weights = new ArrayList<FederationQueueWeight>();
        File xmlFile = new File(policiesXml);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlFile);
        NodeList federationsList = document.getElementsByTagName(XML_TAG_FEDERATION_WEIGHTS);
        for (int i = 0; i < federationsList.getLength(); ++i) {
            Node federationNode = federationsList.item(i);
            if (federationNode.getNodeType() != 1) continue;
            Element federationElement = (Element)federationNode;
            NodeList queueList = federationElement.getElementsByTagName("queue");
            for (int j = 0; j < queueList.getLength(); ++j) {
                Node queueNode = queueList.item(j);
                if (queueNode.getNodeType() != 1) continue;
                Element queueElement = (Element)queueNode;
                String queueName = queueElement.getElementsByTagName(XML_TAG_NAME).item(0).getTextContent();
                String amrmWeight = this.parsePolicyWeightsNode(queueElement, XML_TAG_AMRMPOLICYWEIGHTS);
                String routerWeight = this.parsePolicyWeightsNode(queueElement, XML_TAG_ROUTERPOLICYWEIGHTS);
                String headroomAlpha = queueElement.getElementsByTagName(XML_TAG_HEADROOMALPHA).item(0).getTextContent();
                String policyManager = this.getConf().get("yarn.federation.policy-manager", "org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager");
                LOG.debug("Queue: {}, AmrmPolicyWeights: {}, RouterWeight: {}, HeadroomAlpha: {}.", new Object[]{queueName, amrmWeight, routerWeight, headroomAlpha});
                FederationQueueWeight weight = FederationQueueWeight.newInstance(routerWeight, amrmWeight, headroomAlpha, queueName, policyManager);
                weights.add(weight);
            }
        }
        return weights;
    }

    private String parsePolicyWeightsNode(Element queueElement, String weightType) {
        NodeList amrmPolicyWeightsList = queueElement.getElementsByTagName(weightType);
        Node amrmPolicyWeightsNode = amrmPolicyWeightsList.item(0);
        ArrayList<CallSite> amRmPolicyWeights = new ArrayList<CallSite>();
        if (amrmPolicyWeightsNode.getNodeType() == 1) {
            Element amrmPolicyWeightsElement = (Element)amrmPolicyWeightsNode;
            NodeList subClusterIdInfoList = amrmPolicyWeightsElement.getElementsByTagName(XML_TAG_SUBCLUSTERIDINFO);
            for (int i = 0; i < subClusterIdInfoList.getLength(); ++i) {
                Node subClusterIdInfoNode = subClusterIdInfoList.item(i);
                if (subClusterIdInfoNode.getNodeType() != 1) continue;
                Element subClusterIdInfoElement = (Element)subClusterIdInfoNode;
                String subClusterId = subClusterIdInfoElement.getElementsByTagName("id").item(0).getTextContent();
                String weight = subClusterIdInfoElement.getElementsByTagName("weight").item(0).getTextContent();
                LOG.debug("WeightType[{}] - SubCluster ID: {}, Weight: {}.", new Object[]{weightType, subClusterId, weight});
                amRmPolicyWeights.add((CallSite)((Object)(subClusterId + ":" + weight)));
            }
        }
        return StringUtils.join(amRmPolicyWeights, (String)",");
    }

    protected int handListPolicies(int pageSize, int currentPage, String queue, List<String> queues) {
        LOG.info("List Federation Policies,  pageSize = {}, currentPage = {}, queue = {}, queues = {}", new Object[]{pageSize, currentPage, queue, queues});
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
            QueryFederationQueuePoliciesRequest request = QueryFederationQueuePoliciesRequest.newInstance(pageSize, currentPage, queue, queues);
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            QueryFederationQueuePoliciesResponse response = adminProtocol.listFederationQueuePolicies(request);
            System.out.println("TotalPage = " + response.getTotalPage());
            FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(LIST_POLICIES_TITLE).addHeaders(LIST_POLICIES_HEADER);
            List<FederationQueueWeight> federationQueueWeights = response.getFederationQueueWeights();
            federationQueueWeights.forEach(federationQueueWeight -> {
                String queueName = federationQueueWeight.getQueue();
                String amrmWeight = federationQueueWeight.getAmrmWeight();
                String routerWeight = federationQueueWeight.getRouterWeight();
                formattingCLIUtils.addLine(queueName, amrmWeight, routerWeight);
            });
            writer.print(formattingCLIUtils.render());
            writer.flush();
            return 0;
        }
        catch (IOException | YarnException e) {
            LOG.error("handleSavePolicy error.", (Throwable)e);
            return -1;
        }
    }

    private int handleDeleteApplication(String application) {
        LOG.info("Delete Application = {}.", (Object)application);
        try {
            DeleteFederationApplicationRequest request = DeleteFederationApplicationRequest.newInstance(application);
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            DeleteFederationApplicationResponse response = adminProtocol.deleteFederationApplication(request);
            System.out.println(response.getMessage());
            return 0;
        }
        catch (Exception e) {
            LOG.error("handleSavePolicy error.", (Throwable)e);
            return -1;
        }
    }

    private int handleApplication(String[] args) throws IOException, YarnException, ParseException {
        CommandLine cliParser;
        Options opts = new Options();
        opts.addOption("application", false, "We provide a set of commands to query and clean applications.");
        Option deleteOpt = new Option(null, "delete", true, "We will clean up the provided application.");
        opts.addOption(deleteOpt);
        try {
            cliParser = new DefaultParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            System.out.println("Missing argument for options");
            RouterCLI.printUsage(args[0]);
            return -1;
        }
        if (cliParser.hasOption("delete")) {
            String application = cliParser.getOptionValue("delete");
            return this.handleDeleteApplication(application);
        }
        return 0;
    }

    protected int handDeletePolicy(String queue) {
        LOG.info("Delete {} Policy.", (Object)queue);
        try {
            if (StringUtils.isBlank((CharSequence)queue)) {
                System.err.println("Queue cannot be empty.");
            }
            ArrayList<String> queues = new ArrayList<String>();
            queues.add(queue);
            DeleteFederationQueuePoliciesRequest request = DeleteFederationQueuePoliciesRequest.newInstance(queues);
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            DeleteFederationQueuePoliciesResponse response = adminProtocol.deleteFederationPoliciesByQueues(request);
            System.out.println(response.getMessage());
            return 0;
        }
        catch (Exception e) {
            LOG.error("handDeletePolicy queue = {} error.", (Object)queue, (Object)e);
            return -1;
        }
    }

    @Override
    public int run(String[] args) throws Exception {
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isFederationEnabled = yarnConf.getBoolean("yarn.federation.enabled", false);
        if (args.length < 1 || !isFederationEnabled) {
            RouterCLI.printUsage(CMD_EMPTY);
            return -1;
        }
        String cmd = args[0];
        if (CMD_HELP.equals(cmd)) {
            if (args.length > 1) {
                RouterCLI.printUsage(args[1]);
            } else {
                RouterCLI.printHelp();
            }
            return 0;
        }
        if (CMD_SUBCLUSTER.equals(cmd)) {
            return this.handleSubCluster(args);
        }
        if (CMD_POLICY.equals(cmd)) {
            return this.handlePolicy(args);
        }
        if (CMD_APPLICATION.equals(cmd)) {
            return this.handleApplication(args);
        }
        System.out.println("No related commands found.");
        RouterCLI.printHelp();
        return 0;
    }

    public static HAAdmin.UsageInfo getPolicyBatchSaveUsage() {
        return POLICY_BATCH_SAVE_USAGE;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run(new RouterCLI(), args);
        System.exit(result);
    }

    @VisibleForTesting
    public Map<String, RouterCmdUsageInfos> getAdminUsage() {
        return ADMIN_USAGE;
    }

    static class RouterCmdUsageInfos {
        private List<HAAdmin.UsageInfo> usageInfos = new ArrayList<HAAdmin.UsageInfo>();
        private List<String> helpInfos = new ArrayList<String>();
        private Map<String, List<String>> examples = new LinkedHashMap<String, List<String>>();
        protected Map<String, List<String>> exampleDescs = new LinkedHashMap<String, List<String>>();

        RouterCmdUsageInfos() {
        }

        public RouterCmdUsageInfos addUsageInfo(HAAdmin.UsageInfo usageInfo) {
            this.usageInfos.add(usageInfo);
            return this;
        }

        public RouterCmdUsageInfos addHelpInfo(String helpInfo) {
            this.helpInfos.add(helpInfo);
            return this;
        }

        private RouterCmdUsageInfos addExample(String cmd, String example) {
            List exampleList = this.examples.getOrDefault(cmd, new ArrayList());
            exampleList.add(example);
            this.examples.put(cmd, exampleList);
            return this;
        }

        private RouterCmdUsageInfos addExampleDescs(String cmd, String exampleDesc) {
            List exampleDescList = this.exampleDescs.getOrDefault(cmd, new ArrayList());
            exampleDescList.add(exampleDesc);
            this.exampleDescs.put(cmd, exampleDescList);
            return this;
        }

        public Map<String, List<String>> getExamples() {
            return this.examples;
        }
    }
}

