/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class GpgCLI
extends Configured
implements Tool {
    public GpgCLI() {
    }

    public GpgCLI(Configuration conf) {
        super(conf);
    }

    private static void printHelp() {
        StringBuilder summary = new StringBuilder();
        summary.append("gpgadmin command line for YARN Federation Policy management.\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        helpBuilder.append(" -help [cmd]: Displays help for the given command or all commands if none is specified.");
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage(System.out);
    }

    private static void printUsage() {
        StringBuilder usageBuilder = new StringBuilder();
        GpgCLI.buildUsageMsg(usageBuilder);
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage(System.err);
    }

    private static void buildUsageMsg(StringBuilder builder) {
        builder.append("gpgadmin is only used in Yarn Federation Mode.\n");
        builder.append("Usage: gpgadmin\n");
        builder.append("   -help [cmd]\n");
    }

    @Override
    public int run(String[] args) throws Exception {
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isFederationEnabled = yarnConf.getBoolean("yarn.federation.enabled", false);
        if (args.length < 1 || !isFederationEnabled) {
            GpgCLI.printUsage();
            return -1;
        }
        String cmd = args[0];
        if ("-help".equals(cmd)) {
            GpgCLI.printHelp();
            return 0;
        }
        return 0;
    }
}

