/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.Flushable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hadoop.shaded.javax.ws.rs.client.Client;
import org.apache.hadoop.shaded.javax.ws.rs.client.Entity;
import org.apache.hadoop.shaded.javax.ws.rs.client.WebTarget;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.net.jodah.failsafe.Failsafe;
import org.apache.hadoop.shaded.net.jodah.failsafe.Policy;
import org.apache.hadoop.shaded.net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.api.records.timeline.reader.TimelinePutResponseReader;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineDomainWriter;
import org.apache.hadoop.yarn.api.records.timeline.writer.TimelineEntitiesWriter;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TimelineWriter
implements Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineWriter.class);
    private final UserGroupInformation authUgi;
    private final Client client;
    private final URI resURI;
    private final RetryPolicy<Object> retryPolicy;

    public TimelineWriter(UserGroupInformation authUgi, Client client, URI resURI, RetryPolicy<Object> retryPolicy) {
        this.authUgi = authUgi;
        this.client = client;
        this.resURI = resURI;
        this.retryPolicy = retryPolicy;
    }

    public void close() throws Exception {
    }

    @Override
    public void flush() throws IOException {
    }

    public String toString() {
        return "Timeline writer posting to " + this.resURI;
    }

    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        TimelineEntities entitiesContainer = new TimelineEntities();
        for (TimelineEntity entity : entities) {
            if (entity.getEntityId() == null || entity.getEntityType() == null) {
                throw new YarnException("Incomplete entity without entity id/type");
            }
            entitiesContainer.addEntity(entity);
        }
        Response resp = this.doPosting(entitiesContainer, null);
        return (TimelinePutResponse)resp.readEntity(TimelinePutResponse.class);
    }

    public void putDomain(TimelineDomain domain) throws IOException, YarnException {
        this.doPosting(domain, "domain");
    }

    public abstract TimelinePutResponse putEntities(ApplicationAttemptId var1, TimelineEntityGroupId var2, TimelineEntity ... var3) throws IOException, YarnException;

    public abstract void putDomain(ApplicationAttemptId var1, TimelineDomain var2) throws IOException, YarnException;

    private Response doPosting(Object obj, String path) throws IOException, YarnException {
        Response resp;
        try {
            resp = this.authUgi.doAs(() -> this.doPostingObject(obj, path));
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (InterruptedException ie) {
            throw (IOException)new InterruptedIOException().initCause(ie);
        }
        if (resp == null || resp.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            Object msg = "Failed to get the response from the timeline server.";
            LOG.error((String)msg);
            if (resp != null) {
                msg = (String)msg + " HTTP error code: " + resp.getStatus();
                LOG.debug("HTTP error code: {} Server response : \n{}", (Object)resp.getStatus(), resp.readEntity(String.class));
            }
            throw new YarnException((String)msg);
        }
        return resp;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Response doPostingObject(Object object, String path) throws JsonProcessingException {
        WebTarget webTarget = ((Client)((Client)((Client)this.client.register(TimelineEntitiesWriter.class)).register(TimelineDomainWriter.class)).register(TimelinePutResponseReader.class)).target(this.resURI);
        if (path == null) {
            LOG.debug("POST to {}", (Object)this.resURI);
            Response r = (Response)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> (Response)webTarget.request(new String[]{"application/json"}).post(Entity.entity((Object)object, (String)"application/json"), Response.class));
            r.bufferEntity();
            return r;
        }
        if (path.equals("domain")) {
            LOG.debug("PUT to {}/{}", (Object)this.resURI, (Object)path);
            Response r = (Response)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> (Response)webTarget.path(path).request(new String[]{"application/json"}).put(Entity.entity((Object)object, (String)"application/json"), Response.class));
            r.bufferEntity();
            return r;
        }
        throw new YarnRuntimeException("Unknown resource type");
    }
}

