/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticator;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.javax.ws.rs.ProcessingException;
import org.apache.hadoop.shaded.javax.ws.rs.client.Client;
import org.apache.hadoop.shaded.javax.ws.rs.client.ClientBuilder;
import org.apache.hadoop.shaded.net.jodah.failsafe.Failsafe;
import org.apache.hadoop.shaded.net.jodah.failsafe.Policy;
import org.apache.hadoop.shaded.net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.ClientConfig;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.apache.hadoop.shaded.org.glassfish.jersey.client.spi.ConnectorProvider;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineConnector
extends AbstractService {
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Logger LOG = LoggerFactory.getLogger(TimelineConnector.class);
    private int socketTimeOut = 60000;
    private SSLFactory sslFactory;
    Client client;
    private ConnectionConfigurator connConfigurator;
    private DelegationTokenAuthenticator authenticator;
    private DelegationTokenAuthenticatedURL.Token token;
    private UserGroupInformation authUgi;
    private String doAsUser;
    private boolean requireConnectionRetry;
    private RetryPolicy<Object> retryPolicy;
    private ConnectionConfigurator defaultTimeoutConnConfigurator = conn -> {
        TimelineConnector.setTimeouts(conn, this.socketTimeOut);
        return conn;
    };

    public TimelineConnector(boolean requireConnectionRetry, UserGroupInformation authUgi, String doAsUser, DelegationTokenAuthenticatedURL.Token token) {
        super("TimelineConnector");
        this.requireConnectionRetry = requireConnectionRetry;
        this.authUgi = authUgi;
        this.doAsUser = doAsUser;
        this.token = token;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        ClientConfig cc = new ClientConfig();
        cc.register(YarnJacksonJaxbJsonProvider.class);
        if (YarnConfiguration.useHttps(conf)) {
            this.sslFactory = this.getSSLFactory(conf);
            this.connConfigurator = this.getConnConfigurator(this.sslFactory);
        } else {
            this.connConfigurator = this.defaultTimeoutConnConfigurator;
        }
        String defaultAuth = UserGroupInformation.isSecurityEnabled() ? "kerberos" : "simple";
        String authType = conf.get("yarn.timeline-service.http-authentication.type", defaultAuth);
        this.authenticator = authType.equals("kerberos") ? new KerberosDelegationTokenAuthenticator() : new PseudoDelegationTokenAuthenticator();
        this.authenticator.setConnectionConfigurator(this.connConfigurator);
        this.retryPolicy = this.createRetryPolicy(conf);
        cc.connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider().connectionFactory((HttpUrlConnectorProvider.ConnectionFactory)new TimelineURLConnectionFactory(this.authUgi, this.authenticator, this.connConfigurator, this.token, this.doAsUser)));
        this.client = ClientBuilder.newClient((org.apache.hadoop.shaded.javax.ws.rs.core.Configuration)cc);
    }

    private ConnectionConfigurator getConnConfigurator(SSLFactory sslFactoryObj) {
        try {
            return TimelineConnector.initSslConnConfigurator(this.socketTimeOut, sslFactoryObj);
        }
        catch (Exception e) {
            LOG.debug("Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            return this.defaultTimeoutConnConfigurator;
        }
    }

    private static ConnectionConfigurator initSslConnConfigurator(final int timeout, SSLFactory sslFactory) throws IOException, GeneralSecurityException {
        final SSLSocketFactory sf = sslFactory.createSSLSocketFactory();
        final HostnameVerifier hv = sslFactory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            @Override
            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                TimelineConnector.setTimeouts(conn, timeout);
                return conn;
            }
        };
    }

    protected SSLFactory getSSLFactory(Configuration conf) throws GeneralSecurityException, IOException {
        SSLFactory newSSLFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        newSSLFactory.init();
        return newSSLFactory;
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }

    public static URI constructResURI(Configuration conf, String address, String uri) {
        return URI.create(JOINER.join((Object)(YarnConfiguration.useHttps(conf) ? "https://" : "http://"), (Object)address, new Object[]{uri}));
    }

    DelegationTokenAuthenticatedURL getDelegationTokenAuthenticatedURL() {
        return new DelegationTokenAuthenticatedURL(this.authenticator, this.connConfigurator);
    }

    @Override
    protected void serviceStop() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
    }

    public Client getClient() {
        return this.client;
    }

    public Object operateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException, YarnException {
        TimelineClientRetryOp tokenRetryOp = this.createRetryOpForOperateDelegationToken(action);
        return Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(tokenRetryOp::run);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    TimelineClientRetryOp createRetryOpForOperateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException {
        return new TimelineClientRetryOpForOperateDelegationToken(this.authUgi, action);
    }

    private RetryPolicy<Object> createRetryPolicy(Configuration conf) {
        Preconditions.checkArgument(conf.getInt("yarn.timeline-service.client.max-retries", 30) >= -1, "%s property value should be greater than or equal to -1", "yarn.timeline-service.client.max-retries");
        Preconditions.checkArgument(conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L) > 0L, "%s property value should be greater than zero", "yarn.timeline-service.client.retry-interval-ms");
        int maxRetries = 0;
        if (this.requireConnectionRetry) {
            maxRetries = conf.getInt("yarn.timeline-service.client.max-retries", 30);
        }
        long retryInterval = conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L);
        return ((RetryPolicy)((RetryPolicy)new RetryPolicy().handle(new Class[]{IOException.class, RuntimeException.class})).handleIf(e -> e instanceof ProcessingException && (e.getCause() instanceof ConnectException || e.getCause() instanceof SocketTimeoutException || e.getCause() instanceof SocketException))).withDelay(Duration.ofMillis(retryInterval)).withMaxRetries(maxRetries);
    }

    RetryPolicy<Object> getRetryPolicy() {
        return this.retryPolicy;
    }

    @VisibleForTesting
    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
    }

    private static class TimelineURLConnectionFactory
    implements HttpUrlConnectorProvider.ConnectionFactory {
        private DelegationTokenAuthenticator authenticator;
        private UserGroupInformation authUgi;
        private ConnectionConfigurator connConfigurator;
        private DelegationTokenAuthenticatedURL.Token token;
        private String doAsUser;

        TimelineURLConnectionFactory(UserGroupInformation authUgi, DelegationTokenAuthenticator authenticator, ConnectionConfigurator connConfigurator, DelegationTokenAuthenticatedURL.Token token, String doAsUser) {
            this.authUgi = authUgi;
            this.authenticator = authenticator;
            this.connConfigurator = connConfigurator;
            this.token = token;
            this.doAsUser = doAsUser;
        }

        public HttpURLConnection getConnection(URL url) throws IOException {
            this.authUgi.checkTGTAndReloginFromKeytab();
            try {
                return new DelegationTokenAuthenticatedURL(this.authenticator, this.connConfigurator).openConnection(url, this.token, this.doAsUser);
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
            catch (AuthenticationException ae) {
                throw new IOException(ae);
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static abstract class TimelineClientRetryOp {
        public abstract Object run() throws IOException;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class TimelineClientRetryOpForOperateDelegationToken
    extends TimelineClientRetryOp {
        private final UserGroupInformation authUgi;
        private final PrivilegedExceptionAction<?> action;

        public TimelineClientRetryOpForOperateDelegationToken(UserGroupInformation authUgi, PrivilegedExceptionAction<?> action) {
            this.authUgi = authUgi;
            this.action = action;
        }

        @Override
        public Object run() throws IOException {
            this.authUgi.checkTGTAndReloginFromKeytab();
            try {
                return this.authUgi.doAs(this.action);
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }
}

