/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class GetNodesToAttributesResponsePBImpl
extends GetNodesToAttributesResponse {
    private YarnServiceProtos.GetNodesToAttributesResponseProto proto = YarnServiceProtos.GetNodesToAttributesResponseProto.getDefaultInstance();
    private YarnServiceProtos.GetNodesToAttributesResponseProto.Builder builder = null;
    private boolean viaProto = false;
    private Map<String, Set<NodeAttribute>> nodesToAttributes;

    public GetNodesToAttributesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetNodesToAttributesResponseProto.newBuilder();
    }

    public GetNodesToAttributesResponsePBImpl(YarnServiceProtos.GetNodesToAttributesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void initNodesToAttributes() {
        if (this.nodesToAttributes != null) {
            return;
        }
        YarnServiceProtos.GetNodesToAttributesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeToAttributesProto> list = p.getNodesToAttributesList();
        this.nodesToAttributes = new HashMap<String, Set<NodeAttribute>>();
        for (YarnProtos.NodeToAttributesProto c : list) {
            HashSet<NodeAttributePBImpl> attributes = new HashSet<NodeAttributePBImpl>();
            for (YarnProtos.NodeAttributeProto nodeAttrProto : c.getNodeAttributesList()) {
                attributes.add(new NodeAttributePBImpl(nodeAttrProto));
            }
            this.nodesToAttributes.put(c.getNode(), attributes);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetNodesToAttributesResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addNodesToAttributesToProto() {
        this.maybeInitBuilder();
        this.builder.clearNodesToAttributes();
        if (this.nodesToAttributes == null) {
            return;
        }
        Iterable iterable = () -> new Iterator<YarnProtos.NodeToAttributesProto>(){
            private Iterator<Map.Entry<String, Set<NodeAttribute>>> iter;
            {
                this.iter = GetNodesToAttributesResponsePBImpl.this.nodesToAttributes.entrySet().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public YarnProtos.NodeToAttributesProto next() {
                Map.Entry<String, Set<NodeAttribute>> now = this.iter.next();
                HashSet<YarnProtos.NodeAttributeProto> protoSet = new HashSet<YarnProtos.NodeAttributeProto>();
                for (NodeAttribute nodeAttribute : now.getValue()) {
                    protoSet.add(GetNodesToAttributesResponsePBImpl.this.convertToProtoFormat(nodeAttribute));
                }
                return YarnProtos.NodeToAttributesProto.newBuilder().setNode(now.getKey()).addAllNodeAttributes(protoSet).build();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }
        };
        this.builder.addAllNodesToAttributes(iterable);
    }

    private NodeAttributePBImpl convertFromProtoFormat(YarnProtos.NodeAttributeProto p) {
        return new NodeAttributePBImpl(p);
    }

    private YarnProtos.NodeAttributeProto convertToProtoFormat(NodeAttribute t) {
        return ((NodeAttributePBImpl)t).getProto();
    }

    private void mergeLocalToBuilder() {
        if (this.nodesToAttributes != null) {
            this.addNodesToAttributesToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnServiceProtos.GetNodesToAttributesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetNodesToAttributesResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public void setNodeToAttributes(Map<String, Set<NodeAttribute>> map) {
        this.initNodesToAttributes();
        this.nodesToAttributes.clear();
        this.nodesToAttributes.putAll(map);
    }

    @Override
    public Map<String, Set<NodeAttribute>> getNodeToAttributes() {
        this.initNodesToAttributes();
        return this.nodesToAttributes;
    }
}

