/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.SignalUtil;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum SignalLogger {
    INSTANCE;

    private boolean registered = false;

    public void register(Logger log) {
        if (this.registered) {
            throw new IllegalStateException("Can't re-install the signal handlers.");
        }
        this.registered = true;
        StringBuilder bld = new StringBuilder();
        bld.append("registered UNIX signal handlers for [");
        String[] SIGNALS = new String[]{"TERM", "HUP", "INT"};
        String separator = "";
        for (String signalName : SIGNALS) {
            try {
                new Handler(signalName, log);
                bld.append(separator).append(signalName);
                separator = ", ";
            }
            catch (Exception e) {
                log.debug("Error: ", (Throwable)e);
            }
        }
        bld.append("]");
        log.info(bld.toString());
    }

    private static class Handler
    implements SignalUtil.Handler {
        private final Logger log;
        private final SignalUtil.Handler prevHandler;

        Handler(String name, Logger log) {
            this.log = log;
            this.prevHandler = SignalUtil.handle(new SignalUtil.Signal(name), this);
        }

        @Override
        public void handle(SignalUtil.Signal signal) {
            this.log.error("RECEIVED SIGNAL {}: SIG{}", (Object)signal.getNumber(), (Object)signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

