/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce", "YARN", "HBase"})
@InterfaceStability.Evolving
public final class SaslMechanismFactory {
    static final Logger LOG = LoggerFactory.getLogger(SaslMechanismFactory.class);
    private static final String SASL_MECHANISM_ENV = "HADOOP_SASL_MECHANISM";
    private static volatile String mechanism;

    private static synchronized String getSynchronously() {
        String envValue = System.getenv(SASL_MECHANISM_ENV);
        LOG.debug("{} = {} (env)", (Object)SASL_MECHANISM_ENV, (Object)envValue);
        Configuration conf = new Configuration();
        String confValue = conf.get("hadoop.security.sasl.mechanism", "DIGEST-MD5");
        LOG.debug("{} = {} (conf)", (Object)"hadoop.security.sasl.mechanism", (Object)confValue);
        mechanism = envValue != null ? envValue : (confValue != null ? confValue : "DIGEST-MD5");
        LOG.debug("SASL_MECHANISM = {} (effective)", (Object)mechanism);
        return mechanism;
    }

    public static String getMechanism() {
        String value = mechanism;
        return value != null ? value : SaslMechanismFactory.getSynchronously();
    }

    public static boolean isDefaultMechanism(String saslMechanism) {
        return "DIGEST-MD5".equals(saslMechanism);
    }

    public static boolean isDigestMechanism(String saslMechanism) {
        return saslMechanism.startsWith("DIGEST-");
    }

    private SaslMechanismFactory() {
    }

    public static void main(String[] args) {
        System.out.println("SASL_MECHANISM = " + SaslMechanismFactory.getMechanism());
    }
}

