/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.SimpleTcpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTcpClientHandler
extends ChannelInboundHandlerAdapter {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleTcpClient.class);
    protected final XDR request;

    public SimpleTcpClientHandler(XDR request) {
        this.request = request;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sending PRC request");
        }
        ByteBuf outBuf = XDR.writeMessageTcp(this.request, true);
        ctx.channel().writeAndFlush((Object)outBuf);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ctx.channel().close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.warn("Unexpected exception from downstream: ", cause.getCause());
        ctx.channel().close();
    }
}

