/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.util.Arrays;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.SimpleTcpClient;
import org.apache.hadoop.oncrpc.SimpleTcpClientHandler;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationClient
extends SimpleTcpClient {
    public static final Logger LOG = LoggerFactory.getLogger(RegistrationClient.class);

    public RegistrationClient(String host, int port, XDR request) {
        super(host, port, request);
    }

    static class RegistrationClientHandler
    extends SimpleTcpClientHandler {
        public RegistrationClientHandler(XDR request) {
            super(request);
        }

        private boolean validMessageLength(int len) {
            if (len < 28) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Portmap mapping registration failed, the response size is less than 28 bytes:" + len);
                }
                return false;
            }
            return true;
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ByteBuf buf = (ByteBuf)msg;
            if (!this.validMessageLength(buf.readableBytes())) {
                ctx.channel().close();
                return;
            }
            byte[] fragmentHeader = Arrays.copyOfRange(buf.array(), 0, 4);
            int fragmentSize = XDR.fragmentSize(fragmentHeader);
            boolean isLast = XDR.isLastFragment(fragmentHeader);
            assert (fragmentSize == 28 && isLast);
            XDR xdr = new XDR();
            xdr.writeFixedOpaque(Arrays.copyOfRange(buf.array(), 4, buf.readableBytes()));
            RpcReply reply = RpcReply.read(xdr);
            if (reply.getState() == RpcReply.ReplyState.MSG_ACCEPTED) {
                RpcAcceptedReply acceptedReply = (RpcAcceptedReply)reply;
                this.handle(acceptedReply, xdr);
            } else {
                RpcDeniedReply deniedReply = (RpcDeniedReply)reply;
                this.handle(deniedReply);
            }
            ctx.channel().close();
        }

        private void handle(RpcDeniedReply deniedReply) {
            LOG.warn("Portmap mapping registration request was denied , " + deniedReply);
        }

        private void handle(RpcAcceptedReply acceptedReply, XDR xdr) {
            RpcAcceptedReply.AcceptState acceptState = acceptedReply.getAcceptState();
            assert (acceptState == RpcAcceptedReply.AcceptState.SUCCESS);
            boolean answer = xdr.readBoolean();
            if (!answer) {
                LOG.warn("Portmap mapping registration failed, accept state:" + acceptState);
            }
            LOG.info("Portmap mapping registration succeeded");
        }
    }
}

