/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TupleWritable
implements Writable,
Iterable<Writable> {
    protected BitSet written;
    private Writable[] values;

    public TupleWritable() {
        this.written = new BitSet(0);
    }

    public TupleWritable(Writable[] vals) {
        this.written = new BitSet(vals.length);
        this.values = vals;
    }

    public boolean has(int i) {
        return this.written.get(i);
    }

    public Writable get(int i) {
        return this.values[i];
    }

    public int size() {
        return this.values.length;
    }

    public boolean equals(Object other) {
        if (other instanceof TupleWritable) {
            TupleWritable that = (TupleWritable)other;
            if (!this.written.equals(that.written)) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.has(i) || this.values[i].equals(that.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return this.written.hashCode();
    }

    @Override
    public Iterator<Writable> iterator() {
        final TupleWritable t = this;
        return new Iterator<Writable>(){
            int bitIndex;
            {
                this.bitIndex = TupleWritable.this.written.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.bitIndex >= 0;
            }

            @Override
            public Writable next() {
                int returnIndex = this.bitIndex;
                if (returnIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.bitIndex = TupleWritable.this.written.nextSetBit(this.bitIndex + 1);
                return t.get(returnIndex);
            }

            @Override
            public void remove() {
                if (!TupleWritable.this.written.get(this.bitIndex)) {
                    throw new IllegalStateException("Attempt to remove non-existent val");
                }
                TupleWritable.this.written.clear(this.bitIndex);
            }
        };
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < this.values.length; ++i) {
            buf.append(this.has(i) ? this.values[i].toString() : "");
            buf.append(",");
        }
        if (this.values.length != 0) {
            buf.setCharAt(buf.length() - 1, ']');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        WritableUtils.writeVInt(out, this.values.length);
        TupleWritable.writeBitSet(out, this.values.length, this.written);
        for (i = 0; i < this.values.length; ++i) {
            Text.writeString(out, this.values[i].getClass().getName());
        }
        for (i = 0; i < this.values.length; ++i) {
            if (!this.has(i)) continue;
            this.values[i].write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int card = WritableUtils.readVInt(in);
        this.values = new Writable[card];
        TupleWritable.readBitSet(in, card, this.written);
        Class[] cls = new Class[card];
        try {
            int i;
            for (i = 0; i < card; ++i) {
                cls[i] = Class.forName(Text.readString(in)).asSubclass(Writable.class);
            }
            for (i = 0; i < card; ++i) {
                this.values[i] = cls[i].equals(NullWritable.class) ? NullWritable.get() : (Writable)cls[i].newInstance();
                if (!this.has(i)) continue;
                this.values[i].readFields(in);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed tuple init", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed tuple init", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Failed tuple init", e);
        }
    }

    void setWritten(int i) {
        this.written.set(i);
    }

    void clearWritten(int i) {
        this.written.clear(i);
    }

    void clearWritten() {
        this.written.clear();
    }

    private static final void writeBitSet(DataOutput stream, int nbits, BitSet bitSet) throws IOException {
        long bits = 0L;
        int bitSetIndex = bitSet.nextSetBit(0);
        while (bitSetIndex >= 0 && bitSetIndex < 64) {
            bits |= 1L << bitSetIndex;
            bitSetIndex = bitSet.nextSetBit(bitSetIndex + 1);
        }
        WritableUtils.writeVLong(stream, bits);
        if (nbits > 64) {
            bits = 0L;
            int lastWordWritten = 0;
            while (bitSetIndex >= 0 && bitSetIndex < nbits) {
                int bitsIndex = bitSetIndex % 8;
                int word = (bitSetIndex - 64) / 8;
                if (word > lastWordWritten) {
                    stream.writeByte((byte)bits);
                    bits = 0L;
                    ++lastWordWritten;
                    while (lastWordWritten < word) {
                        stream.writeByte((byte)bits);
                        ++lastWordWritten;
                    }
                }
                bits |= 1L << bitsIndex;
                bitSetIndex = bitSet.nextSetBit(bitSetIndex + 1);
            }
            stream.writeByte((byte)bits);
        }
    }

    private static final void readBitSet(DataInput stream, int nbits, BitSet bitSet) throws IOException {
        bitSet.clear();
        long last = 0L;
        for (long initialBits = WritableUtils.readVLong(stream); 0L != initialBits; initialBits ^= last) {
            last = Long.lowestOneBit(initialBits);
            bitSet.set(Long.numberOfTrailingZeros(last));
        }
        for (int offset = 64; offset < nbits; offset += 8) {
            byte bits = stream.readByte();
            while (0 != bits) {
                last = Long.lowestOneBit(bits);
                bits = (byte)((long)bits ^ last);
                bitSet.set(Long.numberOfTrailingZeros(last) + offset);
            }
        }
    }
}

