/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class PassthroughCodec
implements Configurable,
CompressionCodec {
    private static final Logger LOG = LoggerFactory.getLogger(PassthroughCodec.class);
    public static final String CLASSNAME = "org.apache.hadoop.io.compress.PassthroughCodec";
    public static final String OPT_EXTENSION = "org.apache.hadoop.shaded.io.compress.passthrough.extension";
    public static final String DEFAULT_EXTENSION = ".passthrough";
    private Configuration conf;
    private String extension = ".passthrough";

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        String ex = conf.getTrimmed(OPT_EXTENSION, DEFAULT_EXTENSION);
        this.extension = ex.startsWith(".") ? ex : "." + ex;
    }

    @Override
    public String getDefaultExtension() {
        LOG.info("Registering fake codec for extension {}", (Object)this.extension);
        return this.extension;
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Compressor createCompressor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, null);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return new PassthroughDecompressorStream(in);
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return StubDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        return new StubDecompressor();
    }

    protected static final class PassthroughDecompressorStream
    extends DecompressorStream {
        private final InputStream input;

        PassthroughDecompressorStream(InputStream input) throws IOException {
            super(input);
            this.input = input;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }

        @Override
        public int read() throws IOException {
            return this.input.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }
    }

    protected static final class StubDecompressor
    implements Decompressor {
        protected StubDecompressor() {
        }

        @Override
        public void setInput(byte[] b, int off, int len) {
        }

        @Override
        public boolean needsInput() {
            return false;
        }

        @Override
        public void setDictionary(byte[] b, int off, int len) {
        }

        @Override
        public boolean needsDictionary() {
            return false;
        }

        @Override
        public boolean finished() {
            return false;
        }

        @Override
        public int decompress(byte[] b, int off, int len) throws IOException {
            return 0;
        }

        @Override
        public int getRemaining() {
            return 0;
        }

        @Override
        public void reset() {
        }

        @Override
        public void end() {
        }
    }
}

