/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockChecksumOptions;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.StripedBlockInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtocol;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.Message;
import org.apache.hadoop.tracing.Span;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.tracing.Tracer;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Sender
implements DataTransferProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(Sender.class);
    private final DataOutputStream out;

    public Sender(DataOutputStream out) {
        this.out = out;
    }

    private static void op(DataOutput out, Op op) throws IOException {
        out.writeShort(28);
        op.write(out);
    }

    private static void send(DataOutputStream out, Op opcode, Message proto) throws IOException {
        LOG.trace("Sending DataTransferOp {}: {}", (Object)proto.getClass().getSimpleName(), (Object)proto);
        Sender.op(out, opcode);
        proto.writeDelimitedTo((OutputStream)out);
        out.flush();
    }

    private static DataTransferProtos.CachingStrategyProto getCachingStrategy(CachingStrategy cachingStrategy) {
        DataTransferProtos.CachingStrategyProto.Builder builder = DataTransferProtos.CachingStrategyProto.newBuilder();
        if (cachingStrategy.getReadahead() != null) {
            builder.setReadahead(cachingStrategy.getReadahead());
        }
        if (cachingStrategy.getDropBehind() != null) {
            builder.setDropBehind(cachingStrategy.getDropBehind());
        }
        return builder.build();
    }

    @Override
    public void readBlock(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, String clientName, long blockOffset, long length, boolean sendChecksum, CachingStrategy cachingStrategy) throws IOException {
        DataTransferProtos.OpReadBlockProto proto = DataTransferProtos.OpReadBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildClientHeader(blk, clientName, blockToken)).setOffset(blockOffset).setLen(length).setSendChecksums(sendChecksum).setCachingStrategy(Sender.getCachingStrategy(cachingStrategy)).build();
        Sender.send(this.out, Op.READ_BLOCK, (Message)proto);
    }

    @Override
    public void writeBlock(ExtendedBlock blk, StorageType storageType, Token<BlockTokenIdentifier> blockToken, String clientName, DatanodeInfo[] targets, StorageType[] targetStorageTypes, DatanodeInfo source, BlockConstructionStage stage, int pipelineSize, long minBytesRcvd, long maxBytesRcvd, long latestGenerationStamp, DataChecksum requestedChecksum, CachingStrategy cachingStrategy, boolean allowLazyPersist, boolean pinning, boolean[] targetPinnings, String storageId, String[] targetStorageIds) throws IOException {
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtoUtil.buildClientHeader(blk, clientName, blockToken);
        DataTransferProtos.ChecksumProto checksumProto = DataTransferProtoUtil.toProto(requestedChecksum);
        DataTransferProtos.OpWriteBlockProto.Builder proto = DataTransferProtos.OpWriteBlockProto.newBuilder().setHeader(header).setStorageType(PBHelperClient.convertStorageType(storageType)).addAllTargets(PBHelperClient.convert(targets, 1)).addAllTargetStorageTypes(PBHelperClient.convertStorageTypes(targetStorageTypes, 1)).setStage(DataTransferProtoUtil.toProto(stage)).setPipelineSize(pipelineSize).setMinBytesRcvd(minBytesRcvd).setMaxBytesRcvd(maxBytesRcvd).setLatestGenerationStamp(latestGenerationStamp).setRequestedChecksum(checksumProto).setCachingStrategy(Sender.getCachingStrategy(cachingStrategy)).setAllowLazyPersist(allowLazyPersist).setPinning(pinning).addAllTargetPinnings(PBHelperClient.convert(targetPinnings, 1)).addAllTargetStorageIds(PBHelperClient.convert(targetStorageIds, 1));
        if (source != null) {
            proto.setSource(PBHelperClient.convertDatanodeInfo(source));
        }
        if (storageId != null) {
            proto.setStorageId(storageId);
        }
        Sender.send(this.out, Op.WRITE_BLOCK, (Message)proto.build());
    }

    @Override
    public void transferBlock(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, String clientName, DatanodeInfo[] targets, StorageType[] targetStorageTypes, String[] targetStorageIds) throws IOException {
        DataTransferProtos.OpTransferBlockProto proto = DataTransferProtos.OpTransferBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildClientHeader(blk, clientName, blockToken)).addAllTargets(PBHelperClient.convert(targets)).addAllTargetStorageTypes(PBHelperClient.convertStorageTypes(targetStorageTypes)).addAllTargetStorageIds(Arrays.asList(targetStorageIds)).build();
        Sender.send(this.out, Op.TRANSFER_BLOCK, (Message)proto);
    }

    @Override
    public void requestShortCircuitFds(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, ShortCircuitShm.SlotId slotId, int maxVersion, boolean supportsReceiptVerification) throws IOException {
        DataTransferProtos.OpRequestShortCircuitAccessProto.Builder builder = DataTransferProtos.OpRequestShortCircuitAccessProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setMaxVersion(maxVersion);
        if (slotId != null) {
            builder.setSlotId(PBHelperClient.convert(slotId));
        }
        builder.setSupportsReceiptVerification(supportsReceiptVerification);
        DataTransferProtos.OpRequestShortCircuitAccessProto proto = builder.build();
        Sender.send(this.out, Op.REQUEST_SHORT_CIRCUIT_FDS, (Message)proto);
    }

    @Override
    public void releaseShortCircuitFds(ShortCircuitShm.SlotId slotId) throws IOException {
        DataTransferProtos.ReleaseShortCircuitAccessRequestProto.Builder builder = DataTransferProtos.ReleaseShortCircuitAccessRequestProto.newBuilder().setSlotId(PBHelperClient.convert(slotId));
        Span span = Tracer.getCurrentSpan();
        if (span != null) {
            DataTransferProtos.DataTransferTraceInfoProto.Builder traceInfoProtoBuilder = DataTransferProtos.DataTransferTraceInfoProto.newBuilder().setSpanContext(TraceUtils.spanContextToByteString(span.getContext()));
            builder.setTraceInfo(traceInfoProtoBuilder);
        }
        DataTransferProtos.ReleaseShortCircuitAccessRequestProto proto = builder.build();
        Sender.send(this.out, Op.RELEASE_SHORT_CIRCUIT_FDS, (Message)proto);
    }

    @Override
    public void requestShortCircuitShm(String clientName) throws IOException {
        DataTransferProtos.ShortCircuitShmRequestProto.Builder builder = DataTransferProtos.ShortCircuitShmRequestProto.newBuilder().setClientName(clientName);
        Span span = Tracer.getCurrentSpan();
        if (span != null) {
            DataTransferProtos.DataTransferTraceInfoProto.Builder traceInfoProtoBuilder = DataTransferProtos.DataTransferTraceInfoProto.newBuilder().setSpanContext(TraceUtils.spanContextToByteString(span.getContext()));
            builder.setTraceInfo(traceInfoProtoBuilder);
        }
        DataTransferProtos.ShortCircuitShmRequestProto proto = builder.build();
        Sender.send(this.out, Op.REQUEST_SHORT_CIRCUIT_SHM, (Message)proto);
    }

    @Override
    public void replaceBlock(ExtendedBlock blk, StorageType storageType, Token<BlockTokenIdentifier> blockToken, String delHint, DatanodeInfo source, String storageId) throws IOException {
        DataTransferProtos.OpReplaceBlockProto.Builder proto = DataTransferProtos.OpReplaceBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setStorageType(PBHelperClient.convertStorageType(storageType)).setDelHint(delHint).setSource(PBHelperClient.convertDatanodeInfo(source));
        if (storageId != null) {
            proto.setStorageId(storageId);
        }
        Sender.send(this.out, Op.REPLACE_BLOCK, (Message)proto.build());
    }

    @Override
    public void copyBlock(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) throws IOException {
        DataTransferProtos.OpCopyBlockProto proto = DataTransferProtos.OpCopyBlockProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).build();
        Sender.send(this.out, Op.COPY_BLOCK, (Message)proto);
    }

    @Override
    public void blockChecksum(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken, BlockChecksumOptions blockChecksumOptions) throws IOException {
        DataTransferProtos.OpBlockChecksumProto proto = DataTransferProtos.OpBlockChecksumProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setBlockChecksumOptions(PBHelperClient.convert(blockChecksumOptions)).build();
        Sender.send(this.out, Op.BLOCK_CHECKSUM, (Message)proto);
    }

    @Override
    public void blockGroupChecksum(StripedBlockInfo stripedBlockInfo, Token<BlockTokenIdentifier> blockToken, long requestedNumBytes, BlockChecksumOptions blockChecksumOptions) throws IOException {
        DataTransferProtos.OpBlockGroupChecksumProto proto = DataTransferProtos.OpBlockGroupChecksumProto.newBuilder().setHeader(DataTransferProtoUtil.buildBaseHeader(stripedBlockInfo.getBlock(), blockToken)).setDatanodes(PBHelperClient.convertToProto(stripedBlockInfo.getDatanodes())).addAllBlockTokens(PBHelperClient.convert(stripedBlockInfo.getBlockTokens())).addAllBlockIndices(PBHelperClient.convertBlockIndices(stripedBlockInfo.getBlockIndices())).setEcPolicy(PBHelperClient.convertErasureCodingPolicy(stripedBlockInfo.getErasureCodingPolicy())).setRequestedNumBytes(requestedNumBytes).setBlockChecksumOptions(PBHelperClient.convert(blockChecksumOptions)).build();
        Sender.send(this.out, Op.BLOCK_GROUP_CHECKSUM, (Message)proto);
    }
}

