/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.UnknownCipherSuiteException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.KMSUtil;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HdfsKMSUtil {
    private static final String DFS_KMS_PREFIX = "dfs-kms-";
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";

    private HdfsKMSUtil() {
    }

    public static KeyProvider createKeyProvider(Configuration conf) throws IOException {
        return KMSUtil.createKeyProvider(conf, keyProviderUriKeyName);
    }

    public static CryptoProtocolVersion getCryptoProtocolVersion(FileEncryptionInfo feInfo) throws IOException {
        CryptoProtocolVersion version = feInfo.getCryptoProtocolVersion();
        if (!CryptoProtocolVersion.supports(version)) {
            throw new IOException("Client does not support specified CryptoProtocolVersion " + version.getDescription() + " version number" + version.getVersion());
        }
        return version;
    }

    public static CryptoCodec getCryptoCodec(Configuration conf, FileEncryptionInfo feInfo) throws IOException {
        CipherSuite suite = feInfo.getCipherSuite();
        if (suite.equals((Object)CipherSuite.UNKNOWN)) {
            throw new IOException("NameNode specified unknown CipherSuite with ID " + suite.getUnknownValue() + ", cannot instantiate CryptoCodec.");
        }
        CryptoCodec codec = CryptoCodec.getInstance(conf, suite);
        if (codec == null) {
            throw new UnknownCipherSuiteException("No configuration found for the cipher suite " + suite.getConfigSuffix() + " prefixed with hadoop.security.crypto.codec.classes. Please see the example configuration hadoop.security.crypto.codec.classes.EXAMPLECIPHERSUITE at core-default.xml for details.");
        }
        return codec;
    }

    public static URI getKeyProviderUri(UserGroupInformation ugi, URI namenodeUri, String keyProviderUriStr, Configuration conf) throws IOException {
        Text credsKey;
        URI keyProviderUri = null;
        Credentials credentials = ugi.getCredentials();
        byte[] keyProviderUriBytes = credentials.getSecretKey(credsKey = HdfsKMSUtil.getKeyProviderMapKey(namenodeUri));
        if (keyProviderUriBytes != null) {
            keyProviderUri = URI.create(DFSUtilClient.bytes2String(keyProviderUriBytes));
        }
        if (keyProviderUri == null) {
            if (keyProviderUriStr != null && !conf.getBoolean("dfs.client.ignore.namenode.default.kms.uri", false) && !keyProviderUriStr.isEmpty()) {
                keyProviderUri = URI.create(keyProviderUriStr);
            }
            if (keyProviderUri == null) {
                keyProviderUri = KMSUtil.getKeyProviderUri(conf, keyProviderUriKeyName);
            }
            if (keyProviderUri != null) {
                credentials.addSecretKey(credsKey, DFSUtilClient.string2Bytes(keyProviderUri.toString()));
            }
        }
        return keyProviderUri;
    }

    public static KeyProvider getKeyProvider(KeyProviderTokenIssuer issuer, Configuration conf) throws IOException {
        URI keyProviderUri = issuer.getKeyProviderUri();
        if (keyProviderUri != null) {
            return KMSUtil.createKeyProviderFromUri(conf, keyProviderUri);
        }
        return null;
    }

    public static Text getKeyProviderMapKey(URI namenodeUri) {
        return new Text(DFS_KMS_PREFIX + namenodeUri.getScheme() + "://" + namenodeUri.getAuthority());
    }

    public static CryptoInputStream createWrappedInputStream(InputStream is, KeyProvider keyProvider, FileEncryptionInfo fileEncryptionInfo, Configuration conf) throws IOException {
        HdfsKMSUtil.getCryptoProtocolVersion(fileEncryptionInfo);
        CryptoCodec codec = HdfsKMSUtil.getCryptoCodec(conf, fileEncryptionInfo);
        KeyProvider.KeyVersion decrypted = HdfsKMSUtil.decryptEncryptedDataEncryptionKey(fileEncryptionInfo, keyProvider);
        return new CryptoInputStream(is, codec, decrypted.getMaterial(), fileEncryptionInfo.getIV());
    }

    static KeyProvider.KeyVersion decryptEncryptedDataEncryptionKey(FileEncryptionInfo feInfo, KeyProvider keyProvider) throws IOException {
        if (keyProvider == null) {
            throw new IOException("No KeyProvider is configured, cannot access an encrypted file");
        }
        KeyProviderCryptoExtension.EncryptedKeyVersion ekv = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption(feInfo.getKeyName(), feInfo.getEzKeyVersionName(), feInfo.getIV(), feInfo.getEncryptedDataEncryptionKey());
        try {
            KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension(keyProvider);
            return cryptoProvider.decryptEncryptedKey(ekv);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

