/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics.impl;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.DynamicIOStatisticsBuilder;
import org.apache.hadoop.fs.statistics.impl.EmptyIOStatistics;
import org.apache.hadoop.fs.statistics.impl.EmptyIOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilder;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStoreBuilderImpl;
import org.apache.hadoop.fs.statistics.impl.PairedDurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.SourceWrappedStatistics;
import org.apache.hadoop.fs.statistics.impl.StorageStatisticsFromIOStatistics;
import org.apache.hadoop.fs.statistics.impl.StubDurationTracker;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.ConsumerRaisingIOE;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.apache.hadoop.util.functional.InvocationRaisingIOE;

public final class IOStatisticsBinding {
    public static final String ENTRY_PATTERN = "(%s=%s)";
    @VisibleForTesting
    public static final String NULL_SOURCE = "()";

    private IOStatisticsBinding() {
    }

    public static IOStatistics fromStorageStatistics(StorageStatistics storageStatistics) {
        DynamicIOStatisticsBuilder builder = IOStatisticsBinding.dynamicIOStatistics();
        Iterator<StorageStatistics.LongStatistic> it = storageStatistics.getLongStatistics();
        while (it.hasNext()) {
            StorageStatistics.LongStatistic next = it.next();
            builder.withLongFunctionCounter(next.getName(), k -> storageStatistics.getLong((String)k));
        }
        return builder.build();
    }

    public static DynamicIOStatisticsBuilder dynamicIOStatistics() {
        return new DynamicIOStatisticsBuilder();
    }

    public static IOStatistics emptyStatistics() {
        return EmptyIOStatistics.getInstance();
    }

    public static IOStatisticsStore emptyStatisticsStore() {
        return EmptyIOStatisticsStore.getInstance();
    }

    public static IOStatisticsSource wrap(IOStatistics statistics) {
        return new SourceWrappedStatistics(statistics);
    }

    public static IOStatisticsStoreBuilder iostatisticsStore() {
        return new IOStatisticsStoreBuilderImpl();
    }

    public static <E> String entryToString(Map.Entry<String, E> entry) {
        return IOStatisticsBinding.entryToString(entry.getKey(), entry.getValue());
    }

    public static <E> String entryToString(String name, E value) {
        return String.format(ENTRY_PATTERN, name, value);
    }

    private static <E> Map<String, E> copyMap(Map<String, E> dest, Map<String, E> source, Function<E, E> copyFn) {
        dest.clear();
        source.forEach((key, current) -> dest.put((String)key, (Object)copyFn.apply(current)));
        return dest;
    }

    public static <E extends Serializable> E passthroughFn(E src) {
        return src;
    }

    public static <E extends Serializable> Map<String, E> snapshotMap(Map<String, E> source) {
        return IOStatisticsBinding.snapshotMap(source, IOStatisticsBinding::passthroughFn);
    }

    public static <E extends Serializable> ConcurrentHashMap<String, E> snapshotMap(Map<String, E> source, Function<E, E> copyFn) {
        ConcurrentHashMap dest = new ConcurrentHashMap();
        IOStatisticsBinding.copyMap(dest, source, copyFn);
        return dest;
    }

    public static <E> void aggregateMaps(Map<String, E> dest, Map<String, E> other, BiFunction<E, E, E> aggregateFn, Function<E, E> copyFn) {
        other.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object rVal = entry.getValue();
            Object lVal = dest.get(key);
            if (lVal == null) {
                dest.put(key, copyFn.apply(rVal));
            } else {
                dest.put(key, aggregateFn.apply(lVal, rVal));
            }
        });
    }

    public static Long aggregateCounters(Long l, Long r) {
        return Math.max(l, 0L) + Math.max(r, 0L);
    }

    public static Long aggregateGauges(Long l, Long r) {
        return l + r;
    }

    public static Long aggregateMinimums(Long l, Long r) {
        if (l == -1L) {
            return r;
        }
        if (r == -1L) {
            return l;
        }
        return Math.min(l, r);
    }

    public static Long aggregateMaximums(Long l, Long r) {
        if (l == -1L) {
            return r;
        }
        if (r == -1L) {
            return l;
        }
        return Math.max(l, r);
    }

    public static MeanStatistic aggregateMeanStatistics(MeanStatistic l, MeanStatistic r) {
        MeanStatistic res = l.copy();
        res.add(r);
        return res;
    }

    public static void maybeUpdateMaximum(AtomicLong dest, long sample) {
        long current;
        boolean done;
        while (!(done = sample > (current = dest.get()) ? dest.compareAndSet(current, sample) : true)) {
        }
    }

    public static void maybeUpdateMinimum(AtomicLong dest, long sample) {
        long current;
        boolean done;
        while (!(done = (current = dest.get()) == -1L || sample < current ? dest.compareAndSet(current, sample) : true)) {
        }
    }

    public static <A, B> FunctionRaisingIOE<A, B> trackFunctionDuration(@Nullable DurationTrackerFactory factory, String statistic, FunctionRaisingIOE<A, B> inputFn) {
        return x -> {
            try (DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);){
                Object r = inputFn.apply(x);
                return r;
            }
        };
    }

    public static <A, B> Function<A, B> trackJavaFunctionDuration(@Nullable DurationTrackerFactory factory, String statistic, Function<A, B> inputFn) {
        return x -> {
            try (DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);){
                Object r = inputFn.apply(x);
                return r;
            }
        };
    }

    public static <B> B trackDuration(DurationTrackerFactory factory, String statistic, CallableRaisingIOE<B> input) throws IOException {
        return IOStatisticsBinding.trackDurationOfOperation(factory, statistic, input).apply();
    }

    public static void trackDurationOfInvocation(DurationTrackerFactory factory, String statistic, InvocationRaisingIOE input) throws IOException {
        IOStatisticsBinding.measureDurationOfInvocation(factory, statistic, input);
    }

    public static Duration measureDurationOfInvocation(DurationTrackerFactory factory, String statistic, InvocationRaisingIOE input) throws IOException {
        try (DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);){
            input.apply();
        }
        return tracker.asDuration();
    }

    public static <B> CallableRaisingIOE<B> trackDurationOfOperation(@Nullable DurationTrackerFactory factory, String statistic, CallableRaisingIOE<B> input) {
        return () -> {
            DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);
            return IOStatisticsBinding.invokeTrackingDuration(tracker, input);
        };
    }

    public static <B> B invokeTrackingDuration(DurationTracker tracker, CallableRaisingIOE<B> input) throws IOException {
        try {
            B b = input.apply();
            return b;
        }
        catch (IOException | RuntimeException e) {
            tracker.failed();
            throw e;
        }
        finally {
            tracker.close();
        }
    }

    public static <B> ConsumerRaisingIOE<B> trackDurationConsumer(@Nullable DurationTrackerFactory factory, String statistic, ConsumerRaisingIOE<B> input) {
        return t -> {
            try (DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);){
                input.accept(t);
            }
        };
    }

    public static <B> Callable<B> trackDurationOfCallable(@Nullable DurationTrackerFactory factory, String statistic, Callable<B> input) {
        return () -> {
            try (DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);){
                Object v = input.call();
                return v;
            }
        };
    }

    public static <B> B trackDurationOfSupplier(@Nullable DurationTrackerFactory factory, String statistic, Supplier<B> input) {
        try (DurationTracker tracker = IOStatisticsBinding.createTracker(factory, statistic);){
            B b = input.get();
            return b;
        }
    }

    public static DurationTracker createTracker(@Nullable DurationTrackerFactory factory, String statistic) {
        return factory != null ? factory.trackDuration(statistic) : StubDurationTracker.STUB_DURATION_TRACKER;
    }

    public static DurationTrackerFactory pairedTrackerFactory(DurationTrackerFactory first, DurationTrackerFactory second) {
        return new PairedDurationTrackerFactory(first, second);
    }

    public static StorageStatistics publishAsStorageStatistics(String name, String scheme, IOStatistics source) {
        return new StorageStatisticsFromIOStatistics(name, scheme, source);
    }
}

