/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class OpensslCipher {
    private static final Logger LOG = LoggerFactory.getLogger((String)OpensslCipher.class.getName());
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 0;
    private long context = 0L;
    private final int alg;
    private final int padding;
    private long engine;
    private static final String loadingFailureReason;

    public static String getLoadingFailureReason() {
        return loadingFailureReason;
    }

    private OpensslCipher(long context, int alg, int padding, long engine) {
        this.context = context;
        this.alg = alg;
        this.padding = padding;
        this.engine = engine;
    }

    public static OpensslCipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return OpensslCipher.getInstance(transformation, null);
    }

    public static OpensslCipher getInstance(String transformation, String engineId) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Transform transform = OpensslCipher.tokenizeTransformation(transformation);
        int algMode = AlgMode.get(transform.alg, transform.mode);
        int padding = Padding.get(transform.padding);
        long context = OpensslCipher.initContext(algMode, padding);
        long engine = engineId != null ? OpensslCipher.initEngine(engineId) : 0L;
        return new OpensslCipher(context, algMode, padding, engine);
    }

    private static Transform tokenizeTransformation(String transformation) throws NoSuchAlgorithmException {
        if (transformation == null) {
            throw new NoSuchAlgorithmException("No transformation given.");
        }
        String[] parts = new String[3];
        int count = 0;
        StringTokenizer parser = new StringTokenizer(transformation, "/");
        while (parser.hasMoreTokens() && count < 3) {
            parts[count++] = parser.nextToken().trim();
        }
        if (count != 3 || parser.hasMoreTokens()) {
            throw new NoSuchAlgorithmException("Invalid transformation format: " + transformation);
        }
        return new Transform(parts[0], parts[1], parts[2]);
    }

    public static boolean isSupported(CipherSuite suite) {
        int padding;
        int algMode;
        try {
            Transform transform = OpensslCipher.tokenizeTransformation(suite.getName());
            algMode = AlgMode.get(transform.alg, transform.mode);
            padding = Padding.get(transform.padding);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            return false;
        }
        return OpensslCipher.isSupportedSuite(algMode, padding);
    }

    public void init(int mode, byte[] key, byte[] iv) {
        this.context = this.init(this.context, mode, this.alg, this.padding, key, iv, this.engine);
    }

    public int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        this.checkState();
        Preconditions.checkArgument(input.isDirect() && output.isDirect(), "Direct buffers are required.");
        int len = this.update(this.context, input, input.position(), input.remaining(), output, output.position(), output.remaining());
        input.position(input.limit());
        output.position(output.position() + len);
        return len;
    }

    public int doFinal(ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkState();
        Preconditions.checkArgument(output.isDirect(), "Direct buffer is required.");
        int len = this.doFinal(this.context, output, output.position(), output.remaining());
        output.position(output.position() + len);
        return len;
    }

    public void clean() {
        if (this.context != 0L) {
            this.clean(this.context, this.engine);
            this.context = 0L;
            this.engine = 0L;
        }
    }

    private void checkState() {
        Preconditions.checkState(this.context != 0L);
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    private static native void initIDs();

    private static native long initContext(int var0, int var1);

    private static native long initEngine(String var0);

    private native long init(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, long var8);

    private native int update(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    private native int doFinal(long var1, ByteBuffer var3, int var4, int var5);

    private native void clean(long var1, long var3);

    private static native boolean isSupportedSuite(int var0, int var1);

    public static native String getLibraryName();

    static {
        String loadingFailure = null;
        try {
            if (!NativeCodeLoader.buildSupportsOpenssl()) {
                PerformanceAdvisory.LOG.warn("Build does not support openssl");
                loadingFailure = "build does not support openssl.";
            } else {
                OpensslCipher.initIDs();
            }
        }
        catch (Throwable t) {
            loadingFailure = t.getMessage();
            LOG.warn("Failed to load OpenSSL Cipher.", t);
        }
        finally {
            loadingFailureReason = loadingFailure;
        }
    }

    private static class Transform {
        final String alg;
        final String mode;
        final String padding;

        public Transform(String alg, String mode, String padding) {
            this.alg = alg;
            this.mode = mode;
            this.padding = padding;
        }
    }

    private static enum AlgMode {
        AES_CTR,
        SM4_CTR;


        static int get(String algorithm, String mode) throws NoSuchAlgorithmException {
            try {
                return AlgMode.valueOf(algorithm + "_" + mode).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Doesn't support algorithm: " + algorithm + " and mode: " + mode);
            }
        }
    }

    private static enum Padding {
        NoPadding;


        static int get(String padding) throws NoSuchPaddingException {
            try {
                return Padding.valueOf(padding).ordinal();
            }
            catch (Exception e) {
                throw new NoSuchPaddingException("Doesn't support padding: " + padding);
            }
        }
    }
}

