/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.FastNumberFormat;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationId
implements Comparable<ApplicationId> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String appIdStrPrefix = "application";
    private static final String APPLICATION_ID_PREFIX = "application_";
    private static final int APP_ID_MIN_DIGITS = 4;

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ApplicationId newInstance(long clusterTimestamp, int id) {
        ApplicationId appId = Records.newRecord(ApplicationId.class);
        appId.setClusterTimestamp(clusterTimestamp);
        appId.setId(id);
        appId.build();
        return appId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setId(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getClusterTimestamp();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setClusterTimestamp(long var1);

    protected abstract void build();

    @Override
    public int compareTo(ApplicationId other) {
        if (this.getClusterTimestamp() - other.getClusterTimestamp() == 0L) {
            return this.getId() - other.getId();
        }
        return this.getClusterTimestamp() > other.getClusterTimestamp() ? 1 : (this.getClusterTimestamp() < other.getClusterTimestamp() ? -1 : 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(APPLICATION_ID_PREFIX).append(this.getClusterTimestamp()).append('_');
        FastNumberFormat.format(sb, this.getId(), 4);
        return sb.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationId fromString(String appIdStr) {
        if (!appIdStr.startsWith(APPLICATION_ID_PREFIX)) {
            throw new IllegalArgumentException("Invalid ApplicationId prefix: " + appIdStr + ". The valid ApplicationId should start with prefix application");
        }
        try {
            int pos1 = APPLICATION_ID_PREFIX.length() - 1;
            int pos2 = appIdStr.indexOf(95, pos1 + 1);
            if (pos2 < 0) {
                throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr);
            }
            long rmId = Long.parseLong(appIdStr.substring(pos1 + 1, pos2));
            int appId = Integer.parseInt(appIdStr.substring(pos2 + 1));
            ApplicationId applicationId = ApplicationId.newInstance(rmId, appId);
            return applicationId;
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ApplicationId: " + appIdStr, n);
        }
    }

    public int hashCode() {
        int prime = 371237;
        int result = 6521;
        long clusterTimestamp = this.getClusterTimestamp();
        result = 371237 * result + (int)(clusterTimestamp ^ clusterTimestamp >>> 32);
        result = 371237 * result + this.getId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationId other = (ApplicationId)obj;
        if (this.getClusterTimestamp() != other.getClusterTimestamp()) {
            return false;
        }
        return this.getId() == other.getId();
    }
}

