/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UpdateApplicationTimeoutsResponsePBImpl
extends UpdateApplicationTimeoutsResponse {
    YarnServiceProtos.UpdateApplicationTimeoutsResponseProto proto = YarnServiceProtos.UpdateApplicationTimeoutsResponseProto.getDefaultInstance();
    YarnServiceProtos.UpdateApplicationTimeoutsResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Map<ApplicationTimeoutType, String> applicationTimeouts = null;

    public UpdateApplicationTimeoutsResponsePBImpl() {
        this.builder = YarnServiceProtos.UpdateApplicationTimeoutsResponseProto.newBuilder();
    }

    public UpdateApplicationTimeoutsResponsePBImpl(YarnServiceProtos.UpdateApplicationTimeoutsResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServiceProtos.UpdateApplicationTimeoutsResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.UpdateApplicationTimeoutsResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationTimeouts != null) {
            this.addApplicationTimeouts();
        }
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((UpdateApplicationTimeoutsResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public Map<ApplicationTimeoutType, String> getApplicationTimeouts() {
        this.initApplicationTimeout();
        return this.applicationTimeouts;
    }

    private void initApplicationTimeout() {
        if (this.applicationTimeouts != null) {
            return;
        }
        YarnServiceProtos.UpdateApplicationTimeoutsResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationUpdateTimeoutMapProto> lists = p.getApplicationTimeoutsList();
        this.applicationTimeouts = new HashMap<ApplicationTimeoutType, String>(lists.size());
        for (YarnProtos.ApplicationUpdateTimeoutMapProto timeoutProto : lists) {
            this.applicationTimeouts.put(ProtoUtils.convertFromProtoFormat(timeoutProto.getApplicationTimeoutType()), timeoutProto.getExpireTime());
        }
    }

    @Override
    public void setApplicationTimeouts(Map<ApplicationTimeoutType, String> appTimeouts) {
        if (appTimeouts == null) {
            return;
        }
        this.initApplicationTimeout();
        this.applicationTimeouts.clear();
        this.applicationTimeouts.putAll(appTimeouts);
    }

    private void addApplicationTimeouts() {
        this.maybeInitBuilder();
        this.builder.clearApplicationTimeouts();
        if (this.applicationTimeouts == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationUpdateTimeoutMapProto> values = new Iterable<YarnProtos.ApplicationUpdateTimeoutMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationUpdateTimeoutMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationUpdateTimeoutMapProto>(){
                    private Iterator<ApplicationTimeoutType> iterator;
                    {
                        this.iterator = UpdateApplicationTimeoutsResponsePBImpl.this.applicationTimeouts.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationUpdateTimeoutMapProto next() {
                        ApplicationTimeoutType key = this.iterator.next();
                        return YarnProtos.ApplicationUpdateTimeoutMapProto.newBuilder().setExpireTime(UpdateApplicationTimeoutsResponsePBImpl.this.applicationTimeouts.get((Object)key)).setApplicationTimeoutType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationTimeouts((Iterable<? extends YarnProtos.ApplicationUpdateTimeoutMapProto>)values);
    }
}

