/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.invoke.CallSite;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class ConfigurationHelper {
    @VisibleForTesting
    static final String ERROR_MULTIPLE_ELEMENTS_MATCHING_TO_LOWER_CASE_VALUE = "has multiple elements matching to lower case value";

    private ConfigurationHelper() {
    }

    public static <E extends Enum<E>> EnumSet<E> parseEnumSet(String key, String valueString, Class<E> enumClass, boolean ignoreUnknown) throws IllegalArgumentException {
        Map<String, E> mapping = ConfigurationHelper.mapEnumNamesToValues("", enumClass);
        EnumSet<E> enumSet = EnumSet.noneOf(enumClass);
        for (String element : StringUtils.getTrimmedStringCollection(valueString)) {
            String item = element.toLowerCase(Locale.ROOT);
            if ("*".equals(item)) {
                enumSet.addAll(mapping.values());
                continue;
            }
            Enum e = (Enum)mapping.get(item);
            if (e != null) {
                enumSet.add(e);
                continue;
            }
            Preconditions.checkArgument(ignoreUnknown, "%s: Unknown option value: %s in list %s. Valid options for enum class %s are: %s", key, element, valueString, enumClass.getName(), mapping.keySet().stream().collect(Collectors.joining(",")));
        }
        return enumSet;
    }

    public static <E extends Enum<E>> Map<String, E> mapEnumNamesToValues(String prefix, Class<E> enumClass) {
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        HashMap<CallSite, Enum> mapping = new HashMap<CallSite, Enum>(constants.length);
        for (Enum constant : constants) {
            String lc = constant.name().toLowerCase(Locale.ROOT);
            Enum orig = mapping.put((CallSite)((Object)(prefix + lc)), constant);
            Preconditions.checkArgument(orig == null, "Enum %s has multiple elements matching to lower case value %s", enumClass, lc);
        }
        return mapping;
    }

    public static <E extends Enum<E>> E resolveEnum(Configuration conf, String name, Class<E> enumClass, Function<String, E> fallback) {
        String val = conf.getTrimmed(name, "");
        Map<String, E> mapping = ConfigurationHelper.mapEnumNamesToValues("", enumClass);
        Enum mapped = (Enum)mapping.get(val.toLowerCase(Locale.ROOT));
        if (mapped != null) {
            return (E)mapped;
        }
        return (E)((Enum)fallback.apply(val));
    }
}

