/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class IrqHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IrqHandler.class);
    public static final String CONTROL_C = "INT";
    public static final String SIGTERM = "TERM";
    private final String name;
    private final Interrupted handler;
    private final AtomicInteger signalCount = new AtomicInteger(0);
    private Signal signal;

    public IrqHandler(String name, Interrupted handler) {
        Preconditions.checkArgument(name != null, "Null \"name\"");
        Preconditions.checkArgument(handler != null, "Null \"handler\"");
        this.handler = handler;
        this.name = name;
    }

    public void bind() {
        Preconditions.checkState(this.signal == null, "Handler already bound");
        try {
            this.signal = new Signal(this.name);
            Signal.handle(this.signal, this);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not set handler for signal \"" + this.name + "\".This can happen if the JVM has the -Xrs set.", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void raise() {
        Signal.raise(this.signal);
    }

    public String toString() {
        return "IrqHandler for signal " + this.name;
    }

    @Override
    public void handle(Signal s) {
        this.signalCount.incrementAndGet();
        InterruptData data = new InterruptData(s.getName(), s.getNumber());
        LOG.info("Interrupted: {}", (Object)data);
        this.handler.interrupted(data);
    }

    public int getSignalCount() {
        return this.signalCount.get();
    }

    public static interface Interrupted {
        public void interrupted(InterruptData var1);
    }

    public static class InterruptData {
        private final String name;
        private final int number;

        public InterruptData(String name, int number) {
            this.name = name;
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            return "signal " + this.name + "(" + this.number + ")";
        }
    }
}

