/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosAuthException;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.PlatformName;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UserGroupInformation {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(UserGroupInformation.class);
    private static final float TICKET_RENEW_WINDOW = 0.8f;
    private static boolean shouldRenewImmediatelyForTests = false;
    static final String HADOOP_USER_NAME = "HADOOP_USER_NAME";
    static final String HADOOP_PROXY_USER = "HADOOP_PROXY_USER";
    static UgiMetrics metrics = UgiMetrics.create();
    private static AuthenticationMethod authenticationMethod;
    private static Groups groups;
    private static long kerberosMinSecondsBeforeRelogin;
    private static boolean kerberosKeyTabLoginRenewalEnabled;
    private static Optional<ExecutorService> kerberosLoginRenewalExecutor;
    private static Configuration conf;
    public static final String HADOOP_TOKEN_FILE_LOCATION = "HADOOP_TOKEN_FILE_LOCATION";
    public static final String HADOOP_TOKEN = "HADOOP_TOKEN";
    private static final AtomicReference<UserGroupInformation> loginUserRef;
    private final Subject subject;
    private final User user;
    private static String OS_LOGIN_MODULE_NAME;
    private static Class<? extends Principal> OS_PRINCIPAL_CLASS;
    private static final boolean windows;

    @VisibleForTesting
    public static void setShouldRenewImmediatelyForTests(boolean immediate) {
        shouldRenewImmediatelyForTests = immediate;
    }

    public static void reattachMetrics() {
        UgiMetrics.reattach();
    }

    public static boolean isInitialized() {
        return conf != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInitialized() {
        if (UserGroupInformation.isInitialized()) return;
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            if (UserGroupInformation.isInitialized()) return;
            UserGroupInformation.initialize(new Configuration(), false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void initialize(Configuration conf, boolean overrideNameRules) {
        int[] intervals;
        authenticationMethod = SecurityUtil.getAuthenticationMethod(conf);
        if (overrideNameRules || !HadoopKerberosName.hasRulesBeenSet()) {
            try {
                HadoopKerberosName.setConfiguration(conf);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem with Kerberos auth_to_local name configuration", ioe);
            }
        }
        try {
            kerberosMinSecondsBeforeRelogin = 1000L * conf.getLong("hadoop.kerberos.min.seconds.before.relogin", 60L);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.kerberos.min.seconds.before.relogin of " + conf.get("hadoop.kerberos.min.seconds.before.relogin"));
        }
        kerberosKeyTabLoginRenewalEnabled = conf.getBoolean("hadoop.kerberos.keytab.login.autorenewal.enabled", false);
        if (!(groups instanceof TestingGroups)) {
            groups = Groups.getUserToGroupsMappingService(conf);
        }
        UserGroupInformation.conf = conf;
        if (UserGroupInformation.metrics.getGroupsQuantiles == null && (intervals = conf.getInts("hadoop.user.group.metrics.percentiles.intervals")) != null && intervals.length > 0) {
            int length = intervals.length;
            MutableQuantiles[] getGroupsQuantiles = new MutableQuantiles[length];
            for (int i = 0; i < length; ++i) {
                getGroupsQuantiles[i] = UserGroupInformation.metrics.registry.newQuantiles("getGroups" + intervals[i] + "s", "Get groups", "ops", "latency", intervals[i]);
            }
            UserGroupInformation.metrics.getGroupsQuantiles = getGroupsQuantiles;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void setConfiguration(Configuration conf) {
        UserGroupInformation.initialize(conf, true);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static void reset() {
        authenticationMethod = null;
        conf = null;
        groups = null;
        kerberosMinSecondsBeforeRelogin = 0L;
        kerberosKeyTabLoginRenewalEnabled = false;
        kerberosLoginRenewalExecutor = Optional.empty();
        UserGroupInformation.setLoginUser(null);
        HadoopKerberosName.setRules(null);
    }

    public static boolean isSecurityEnabled() {
        return !UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.SIMPLE);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    private static boolean isAuthenticationMethodEnabled(AuthenticationMethod method) {
        UserGroupInformation.ensureInitialized();
        return authenticationMethod == method;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    @VisibleForTesting
    static boolean isKerberosKeyTabLoginRenewalEnabled() {
        UserGroupInformation.ensureInitialized();
        return kerberosKeyTabLoginRenewalEnabled;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    @VisibleForTesting
    static Optional<ExecutorService> getKerberosLoginRenewalExecutor() {
        UserGroupInformation.ensureInitialized();
        return kerberosLoginRenewalExecutor;
    }

    private static String getOSLoginModuleName() {
        if (PlatformName.IBM_JAVA) {
            return "com.ibm.security.auth.module.JAASLoginModule";
        }
        return windows ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
    }

    private static Class<? extends Principal> getOsPrincipalClass() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        try {
            String principalClass = null;
            principalClass = PlatformName.IBM_JAVA ? "com.ibm.security.auth.UsernamePrincipal" : (windows ? "com.sun.security.auth.NTUserPrincipal" : "com.sun.security.auth.UnixPrincipal");
            return cl.loadClass(principalClass);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to find JAAS classes:" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HadoopLoginContext newLoginContext(String appName, Subject subject, HadoopConfiguration loginConf) throws LoginException {
        Thread t = Thread.currentThread();
        ClassLoader oldCCL = t.getContextClassLoader();
        t.setContextClassLoader(HadoopLoginModule.class.getClassLoader());
        try {
            HadoopLoginContext hadoopLoginContext = new HadoopLoginContext(appName, subject, loginConf);
            return hadoopLoginContext;
        }
        finally {
            t.setContextClassLoader(oldCCL);
        }
    }

    private HadoopLoginContext getLogin() {
        LoginContext login = this.user.getLogin();
        return login instanceof HadoopLoginContext ? (HadoopLoginContext)login : null;
    }

    private void setLogin(LoginContext login) {
        this.user.setLogin(login);
    }

    public boolean isLoginSuccess() {
        LoginContext login = this.user.getLogin();
        return login instanceof HadoopLoginContext ? ((HadoopLoginContext)login).isLoginSuccess() : true;
    }

    private void setLastLogin(long loginTime) {
        this.user.setLastLogin(loginTime);
    }

    UserGroupInformation(Subject subject) {
        this.subject = subject;
        this.user = subject.getPrincipals(User.class).iterator().next();
        if (this.user == null || this.user.getName() == null) {
            throw new IllegalStateException("Subject does not contain a valid User");
        }
    }

    public boolean hasKerberosCredentials() {
        return this.user.getAuthenticationMethod() == AuthenticationMethod.KERBEROS;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getCurrentUser() throws IOException {
        UserGroupInformation.ensureInitialized();
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject == null || subject.getPrincipals(User.class).isEmpty()) {
            return UserGroupInformation.getLoginUser();
        }
        return new UserGroupInformation(subject);
    }

    public static UserGroupInformation getBestUGI(String ticketCachePath, String user) throws IOException {
        if (ticketCachePath != null) {
            return UserGroupInformation.getUGIFromTicketCache(ticketCachePath, user);
        }
        if (user == null) {
            return UserGroupInformation.getCurrentUser();
        }
        return UserGroupInformation.createRemoteUser(user);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getUGIFromTicketCache(String ticketCache, String user) throws IOException {
        if (!UserGroupInformation.isAuthenticationMethodEnabled(AuthenticationMethod.KERBEROS)) {
            return UserGroupInformation.getBestUGI(null, user);
        }
        LoginParams params = new LoginParams();
        params.put(LoginParam.PRINCIPAL, user);
        params.put(LoginParam.CCACHE, ticketCache);
        return UserGroupInformation.doSubjectLogin(null, params);
    }

    public static UserGroupInformation getUGIFromSubject(Subject subject) throws IOException {
        if (subject == null) {
            throw new KerberosAuthException("Subject must not be null");
        }
        if (subject.getPrincipals(KerberosPrincipal.class).isEmpty()) {
            throw new KerberosAuthException("Provided Subject must contain a KerberosPrincipal");
        }
        return UserGroupInformation.doSubjectLogin(subject, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation getLoginUser() throws IOException {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation loginUser = loginUserRef.get();
        if (loginUser == null) {
            UserGroupInformation newLoginUser = UserGroupInformation.createLoginUser(null);
            do {
                if (loginUserRef.compareAndSet(null, newLoginUser)) {
                    loginUser = newLoginUser;
                    loginUser.spawnAutoRenewalThreadForUserCreds(false);
                    continue;
                }
                loginUser = loginUserRef.get();
            } while (loginUser == null);
        }
        return loginUser;
    }

    public static String trimLoginMethod(String userName) {
        int spaceIndex = userName.indexOf(32);
        if (spaceIndex >= 0) {
            userName = userName.substring(0, spaceIndex);
        }
        return userName;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void loginUserFromSubject(Subject subject) throws IOException {
        UserGroupInformation.setLoginUser(UserGroupInformation.createLoginUser(subject));
    }

    private static UserGroupInformation createLoginUser(Subject subject) throws IOException {
        UserGroupInformation realUser = UserGroupInformation.doSubjectLogin(subject, null);
        UserGroupInformation loginUser = null;
        try {
            String proxyUser = System.getenv(HADOOP_PROXY_USER);
            if (proxyUser == null) {
                proxyUser = System.getProperty(HADOOP_PROXY_USER);
            }
            loginUser = proxyUser == null ? realUser : UserGroupInformation.createProxyUser(proxyUser, realUser);
            LinkedHashSet<String> tokenFileLocations = new LinkedHashSet<String>();
            tokenFileLocations.addAll(StringUtils.getTrimmedStringCollection(System.getProperty("hadoop.token.files")));
            tokenFileLocations.addAll(StringUtils.getTrimmedStringCollection(conf.get("hadoop.token.files")));
            tokenFileLocations.addAll(StringUtils.getTrimmedStringCollection(System.getenv(HADOOP_TOKEN_FILE_LOCATION)));
            for (String tokenFileLocation : tokenFileLocations) {
                if (tokenFileLocation == null || tokenFileLocation.length() <= 0) continue;
                File tokenFile = new File(tokenFileLocation);
                LOG.debug("Reading credentials from location {}", (Object)tokenFile.getCanonicalPath());
                if (tokenFile.exists() && tokenFile.isFile()) {
                    Credentials cred = Credentials.readTokenStorageFile(tokenFile, conf);
                    LOG.debug("Loaded {} tokens from {}", (Object)cred.numberOfTokens(), (Object)tokenFile.getCanonicalPath());
                    loginUser.addCredentials(cred);
                    continue;
                }
                LOG.info("Token file {} does not exist", (Object)tokenFile.getCanonicalPath());
            }
            LinkedHashSet<String> tokensBase64 = new LinkedHashSet<String>();
            tokensBase64.addAll(StringUtils.getTrimmedStringCollection(System.getProperty("hadoop.tokens")));
            tokensBase64.addAll(StringUtils.getTrimmedStringCollection(conf.get("hadoop.tokens")));
            tokensBase64.addAll(StringUtils.getTrimmedStringCollection(System.getenv(HADOOP_TOKEN)));
            int numTokenBase64 = 0;
            for (String tokenBase64 : tokensBase64) {
                if (tokenBase64 == null || tokenBase64.length() <= 0) continue;
                try {
                    Token token = new Token();
                    token.decodeFromUrlString(tokenBase64);
                    Credentials cred = new Credentials();
                    cred.addToken(token.getService(), token);
                    loginUser.addCredentials(cred);
                    ++numTokenBase64;
                }
                catch (IOException ioe) {
                    LOG.error("Cannot add token {}: {}", (Object)tokenBase64, (Object)ioe.getMessage());
                }
            }
            if (numTokenBase64 > 0) {
                LOG.debug("Loaded {} base64 tokens", (Object)numTokenBase64);
            }
        }
        catch (IOException ioe) {
            LOG.debug("Failure to load login credentials", (Throwable)ioe);
            throw ioe;
        }
        LOG.debug("UGI loginUser: {}", (Object)loginUser);
        return loginUser;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public static void setLoginUser(UserGroupInformation ugi) {
        loginUserRef.set(ugi);
    }

    private String getKeytab() {
        HadoopLoginContext login = this.getLogin();
        return login != null ? (String)login.getConfiguration().getParameters().get((Object)LoginParam.KEYTAB) : null;
    }

    private boolean isHadoopLogin() {
        return this.getLogin() != null;
    }

    public boolean isFromKeytab() {
        return this.hasKerberosCredentials() && this.isHadoopLogin() && this.getKeytab() != null;
    }

    private boolean isFromTicket() {
        return this.hasKerberosCredentials() && this.isHadoopLogin() && this.getKeytab() == null;
    }

    private KerberosTicket getTGT() {
        Set<KerberosTicket> tickets = this.subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!SecurityUtil.isOriginalTGT(ticket)) continue;
            return ticket;
        }
        return null;
    }

    private long getRefreshTime(KerberosTicket tgt) {
        long start = tgt.getStartTime().getTime();
        long end = tgt.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean shouldRelogin() {
        return this.hasKerberosCredentials() && this.isHadoopLogin();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    void spawnAutoRenewalThreadForUserCreds(boolean force) {
        if (!(force || this.shouldRelogin() && !this.isFromKeytab())) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            return;
        }
        String cmd = conf.get("hadoop.kerberos.kinit.command", "kinit");
        long nextRefresh = this.getRefreshTime(tgt);
        this.executeAutoRenewalTask(this.getUserName(), new TicketCacheRenewalRunnable(tgt, cmd, nextRefresh));
    }

    private void spawnAutoRenewalThreadForKeytab() {
        if (!this.shouldRelogin() || this.isFromTicket()) {
            return;
        }
        KerberosTicket tgt = this.getTGT();
        if (tgt == null) {
            return;
        }
        long nextRefresh = this.getRefreshTime(tgt);
        this.executeAutoRenewalTask(this.getUserName(), new KeytabRenewalRunnable(tgt, nextRefresh));
    }

    private void executeAutoRenewalTask(final String userName, AutoRenewalForUserCredsRunnable task) {
        kerberosLoginRenewalExecutor = Optional.of(Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("TGT Renewer for " + userName);
                return t;
            }
        }));
        kerberosLoginRenewalExecutor.get().submit(task);
    }

    @VisibleForTesting
    static long getNextTgtRenewalTime(long tgtEndTime, long now, RetryPolicy rp) throws Exception {
        long lastRetryTime = tgtEndTime - kerberosMinSecondsBeforeRelogin;
        RetryPolicy.RetryAction ra = rp.shouldRetry(null, UserGroupInformation.metrics.renewalFailures.value(), 0, false);
        return Math.min(lastRetryTime, now + ra.delayMillis);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void loginUserFromKeytab(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        UserGroupInformation u = UserGroupInformation.loginUserFromKeytabAndReturnUGI(user, path);
        if (UserGroupInformation.isKerberosKeyTabLoginRenewalEnabled()) {
            u.spawnAutoRenewalThreadForKeytab();
        }
        UserGroupInformation.setLoginUser(u);
        LOG.info("Login successful for user {} using keytab file {}. Keytab auto renewal enabled : {}", new Object[]{user, new File(path).getName(), UserGroupInformation.isKerberosKeyTabLoginRenewalEnabled()});
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void logoutUserFromKeytab() throws IOException {
        if (!this.hasKerberosCredentials()) {
            return;
        }
        if (UserGroupInformation.getKerberosLoginRenewalExecutor().isPresent()) {
            UserGroupInformation.getKerberosLoginRenewalExecutor().get().shutdownNow();
        }
        HadoopLoginContext login = this.getLogin();
        String keytabFile = this.getKeytab();
        if (login == null || keytabFile == null) {
            throw new KerberosAuthException("loginUserFromKeyTab must be done first");
        }
        try {
            LOG.debug("Initiating logout for {}", (Object)this.getUserName());
            login.logout();
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("Logout failure", le);
            kae.setUser(this.user.toString());
            kae.setKeytabFile(keytabFile);
            throw kae;
        }
        LOG.info("Logout successful for user " + this.getUserName() + " using keytab file " + keytabFile);
    }

    public void checkTGTAndReloginFromKeytab() throws IOException {
        this.reloginFromKeytab(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void fixKerberosTicketOrder() {
        Set<Object> creds;
        Set<Object> set = creds = this.getSubject().getPrivateCredentials();
        synchronized (set) {
            Iterator<Object> iter = creds.iterator();
            while (iter.hasNext()) {
                Object cred = iter.next();
                if (!(cred instanceof KerberosTicket)) continue;
                KerberosTicket ticket = (KerberosTicket)cred;
                if (ticket.isDestroyed() || ticket.getServer() == null) {
                    LOG.warn("Ticket is already destroyed, remove it.");
                    iter.remove();
                    continue;
                }
                if (!ticket.getServer().getName().startsWith("krbtgt")) {
                    LOG.warn("The first kerberos ticket is not TGT(the server principal is {}), remove and destroy it.", (Object)ticket.getServer());
                    iter.remove();
                    try {
                        ticket.destroy();
                    }
                    catch (DestroyFailedException e) {
                        LOG.warn("destroy ticket failed", (Throwable)e);
                    }
                    continue;
                }
                return;
            }
        }
        LOG.warn("Warning, no kerberos ticket found while attempting to renew ticket");
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void reloginFromKeytab() throws IOException {
        this.reloginFromKeytab(false);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void forceReloginFromKeytab() throws IOException {
        this.reloginFromKeytab(false, true);
    }

    private void reloginFromKeytab(boolean checkTGT) throws IOException {
        this.reloginFromKeytab(checkTGT, false);
    }

    private void reloginFromKeytab(boolean checkTGT, boolean ignoreLastLoginTime) throws IOException {
        KerberosTicket tgt;
        if (!this.shouldRelogin() || !this.isFromKeytab()) {
            return;
        }
        HadoopLoginContext login = this.getLogin();
        if (login == null) {
            throw new KerberosAuthException("loginUserFromKeyTab must be done first");
        }
        if (checkTGT && (tgt = this.getTGT()) != null && !shouldRenewImmediatelyForTests && Time.now() < this.getRefreshTime(tgt)) {
            return;
        }
        this.relogin(login, ignoreLastLoginTime);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void forceReloginFromTicketCache() throws IOException {
        this.reloginFromTicketCache(true);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public void reloginFromTicketCache() throws IOException {
        this.reloginFromTicketCache(false);
    }

    private void reloginFromTicketCache(boolean ignoreLastLoginTime) throws IOException {
        if (!this.shouldRelogin() || !this.isFromTicket()) {
            return;
        }
        HadoopLoginContext login = this.getLogin();
        if (login == null) {
            throw new KerberosAuthException("login must be done first");
        }
        this.relogin(login, ignoreLastLoginTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relogin(HadoopLoginContext login, boolean ignoreLastLoginTime) throws IOException {
        Object object = login.getSubjectLock();
        synchronized (object) {
            if (login == this.getLogin()) {
                this.unprotectedRelogin(login, ignoreLastLoginTime);
            }
        }
    }

    private void unprotectedRelogin(HadoopLoginContext login, boolean ignoreLastLoginTime) throws IOException {
        assert (Thread.holdsLock(login.getSubjectLock()));
        long now = Time.now();
        if (!this.hasSufficientTimeElapsed(now) && !ignoreLastLoginTime) {
            return;
        }
        this.user.setLastLogin(now);
        try {
            LOG.debug("Initiating logout for {}", (Object)this.getUserName());
            login.logout();
            login = UserGroupInformation.newLoginContext(login.getAppName(), login.getSubject(), login.getConfiguration());
            LOG.debug("Initiating re-login for {}", (Object)this.getUserName());
            login.login();
            this.fixKerberosTicketOrder();
            this.setLogin(login);
        }
        catch (LoginException le) {
            KerberosAuthException kae = new KerberosAuthException("Login failure", le);
            kae.setUser(this.getUserName());
            throw kae;
        }
    }

    public static UserGroupInformation loginUserFromKeytabAndReturnUGI(String user, String path) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return UserGroupInformation.getCurrentUser();
        }
        LoginParams params = new LoginParams();
        params.put(LoginParam.PRINCIPAL, user);
        params.put(LoginParam.KEYTAB, path);
        return UserGroupInformation.doSubjectLogin(null, params);
    }

    private boolean hasSufficientTimeElapsed(long now) {
        if (!shouldRenewImmediatelyForTests && now - this.user.getLastLogin() < kerberosMinSecondsBeforeRelogin) {
            LOG.warn("Not attempting to re-login since the last re-login was attempted less than " + kerberosMinSecondsBeforeRelogin / 1000L + " seconds before. Last Login=" + this.user.getLastLogin());
            return false;
        }
        return true;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.getLoginUser().isFromKeytab();
    }

    public static boolean isLoginTicketBased() throws IOException {
        return UserGroupInformation.getLoginUser().isFromTicket();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user) {
        return UserGroupInformation.createRemoteUser(user, SaslRpcServer.AuthMethod.SIMPLE);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createRemoteUser(String user, SaslRpcServer.AuthMethod authMethod) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new User(user));
        UserGroupInformation result = new UserGroupInformation(subject);
        result.setAuthenticationMethod(authMethod);
        return result;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createProxyUser(String user, UserGroupInformation realUser) {
        if (user == null || user.isEmpty()) {
            throw new IllegalArgumentException("Null user");
        }
        if (realUser == null) {
            throw new IllegalArgumentException("Null real user");
        }
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new User(user, AuthenticationMethod.PROXY, null));
        principals.add(new RealUser(realUser));
        return new UserGroupInformation(subject);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public UserGroupInformation getRealUser() {
        Iterator<RealUser> iterator = this.subject.getPrincipals(RealUser.class).iterator();
        if (iterator.hasNext()) {
            RealUser p = iterator.next();
            return p.getRealUser();
        }
        return null;
    }

    public static UserGroupInformation getRealUserOrSelf(UserGroupInformation user) {
        if (user == null) {
            return null;
        }
        UserGroupInformation real = user.getRealUser();
        return real != null ? real : user;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static UserGroupInformation createUserForTesting(String user, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(user);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public static UserGroupInformation createProxyUserForTesting(String user, UserGroupInformation realUser, String[] userGroups) {
        UserGroupInformation.ensureInitialized();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser(user, realUser);
        if (!(groups instanceof TestingGroups)) {
            groups = new TestingGroups(groups);
        }
        ((TestingGroups)groups).setUserGroups(ugi.getShortUserName(), userGroups);
        return ugi;
    }

    public String getShortUserName() {
        return this.user.getShortName();
    }

    public String getPrimaryGroupName() throws IOException {
        Set<String> groupsSet = this.getGroupsSet();
        if (groupsSet.isEmpty()) {
            throw new IOException("There is no primary group for UGI " + this);
        }
        return groupsSet.iterator().next();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public String getUserName() {
        return this.user.getName();
    }

    public synchronized boolean addTokenIdentifier(TokenIdentifier tokenId) {
        return this.subject.getPublicCredentials().add(tokenId);
    }

    public synchronized Set<TokenIdentifier> getTokenIdentifiers() {
        return this.subject.getPublicCredentials(TokenIdentifier.class);
    }

    public boolean addToken(Token<? extends TokenIdentifier> token) {
        return token != null ? this.addToken(token.getService(), token) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToken(Text alias, Token<? extends TokenIdentifier> token) {
        Subject subject = this.subject;
        synchronized (subject) {
            this.getCredentialsInternal().addToken(alias, token);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Token<? extends TokenIdentifier>> getTokens() {
        Subject subject = this.subject;
        synchronized (subject) {
            return Collections.unmodifiableCollection(new ArrayList<Token<? extends TokenIdentifier>>(this.getCredentialsInternal().getAllTokens()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials() {
        Subject subject = this.subject;
        synchronized (subject) {
            Credentials creds = new Credentials(this.getCredentialsInternal());
            Iterator<Token<? extends TokenIdentifier>> iter = creds.getAllTokens().iterator();
            while (iter.hasNext()) {
                if (!iter.next().isPrivate()) continue;
                iter.remove();
            }
            return creds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCredentials(Credentials credentials) {
        Subject subject = this.subject;
        synchronized (subject) {
            this.getCredentialsInternal().addAll(credentials);
        }
    }

    private synchronized Credentials getCredentialsInternal() {
        Credentials credentials;
        Set<Credentials> credentialsSet = this.subject.getPrivateCredentials(Credentials.class);
        if (!credentialsSet.isEmpty()) {
            credentials = credentialsSet.iterator().next();
        } else {
            credentials = new Credentials();
            this.subject.getPrivateCredentials().add(credentials);
        }
        return credentials;
    }

    public String[] getGroupNames() {
        Set<String> groupsSet = this.getGroupsSet();
        return groupsSet.toArray(new String[groupsSet.size()]);
    }

    @Deprecated
    public List<String> getGroups() {
        UserGroupInformation.ensureInitialized();
        try {
            return groups.getGroups(this.getShortUserName());
        }
        catch (IOException ie) {
            LOG.debug("Failed to get groups for user {}", (Object)this.getShortUserName(), (Object)ie);
            return Collections.emptyList();
        }
    }

    public Set<String> getGroupsSet() {
        UserGroupInformation.ensureInitialized();
        try {
            return groups.getGroupsSet(this.getShortUserName());
        }
        catch (IOException ie) {
            LOG.debug("Failed to get groups for user {}", (Object)this.getShortUserName(), (Object)ie);
            return Collections.emptySet();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getUserName());
        sb.append(" (auth:" + this.getAuthenticationMethod() + ")");
        if (this.getRealUser() != null) {
            sb.append(" via ").append(this.getRealUser().toString());
        }
        return sb.toString();
    }

    public synchronized void setAuthenticationMethod(AuthenticationMethod authMethod) {
        this.user.setAuthenticationMethod(authMethod);
    }

    public void setAuthenticationMethod(SaslRpcServer.AuthMethod authMethod) {
        this.user.setAuthenticationMethod(AuthenticationMethod.valueOf(authMethod));
    }

    public synchronized AuthenticationMethod getAuthenticationMethod() {
        return this.user.getAuthenticationMethod();
    }

    public synchronized AuthenticationMethod getRealAuthenticationMethod() {
        UserGroupInformation ugi = this.getRealUser();
        if (ugi == null) {
            ugi = this;
        }
        return ugi.getAuthenticationMethod();
    }

    public static AuthenticationMethod getRealAuthenticationMethod(UserGroupInformation ugi) {
        AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.subject == ((UserGroupInformation)o).subject;
    }

    public int hashCode() {
        return System.identityHashCode(this.subject);
    }

    protected Subject getSubject() {
        return this.subject;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedAction<T> action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PrivilegedAction [as: {}][action: {}]", new Object[]{this, action, new Exception()});
        }
        return Subject.doAs(this.subject, action);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public <T> T doAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PrivilegedAction [as: {}][action: {}]", new Object[]{this, action, new Exception()});
            }
            return Subject.doAs(this.subject, action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            LOG.debug("PrivilegedActionException as: {}", (Object)this, (Object)cause);
            if (cause == null) {
                throw new RuntimeException("PrivilegedActionException with no underlying cause. UGI [" + this + "]: " + pae, pae);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "KMS"})
    @InterfaceStability.Unstable
    public static void logUserInfo(Logger log, String caption, UserGroupInformation ugi) {
        if (log.isDebugEnabled()) {
            log.debug(caption + " UGI: " + ugi);
            for (Map.Entry<Text, Token<? extends TokenIdentifier>> kv : ugi.getCredentials().getTokenMap().entrySet()) {
                log.debug("+token: {} -> {}", (Object)kv.getKey(), kv.getValue());
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "KMS"})
    @InterfaceStability.Unstable
    public static void logAllUserInfo(Logger log, UserGroupInformation ugi) throws IOException {
        if (log.isDebugEnabled()) {
            UserGroupInformation.logUserInfo(log, "Current", ugi.getCurrentUser());
            if (ugi.getRealUser() != null) {
                UserGroupInformation.logUserInfo(log, "Real", ugi.getRealUser());
            }
            UserGroupInformation.logUserInfo(log, "Login", ugi.getLoginUser());
        }
    }

    public static void logAllUserInfo(UserGroupInformation ugi) throws IOException {
        UserGroupInformation.logAllUserInfo(LOG, ugi);
    }

    private void print() throws IOException {
        System.out.println("User: " + this.getUserName());
        System.out.print("Group Ids: ");
        System.out.println();
        String[] groups = this.getGroupNames();
        System.out.print("Groups: ");
        for (int i = 0; i < groups.length; ++i) {
            System.out.print(groups[i] + " ");
        }
        System.out.println();
    }

    private static UserGroupInformation doSubjectLogin(Subject subject, LoginParams params) throws IOException {
        UserGroupInformation.ensureInitialized();
        if (subject == null && params == null) {
            params = LoginParams.getDefaults();
        }
        HadoopConfiguration loginConf = new HadoopConfiguration(params);
        try {
            HadoopLoginContext login = UserGroupInformation.newLoginContext(authenticationMethod.getLoginAppName(), subject, loginConf);
            login.login();
            UserGroupInformation ugi = new UserGroupInformation(login.getSubject());
            if (subject == null) {
                params.put(LoginParam.PRINCIPAL, ugi.getUserName());
                ugi.setLogin(login);
                ugi.setLastLogin(Time.now());
            }
            return ugi;
        }
        catch (LoginException le) {
            String msg = le.getMessage();
            if (msg != null && msg.contains("invalid null input")) {
                throw new IOException("Invalid UID, could not determine effective user", le);
            }
            KerberosAuthException kae = new KerberosAuthException("failure to login:", le);
            if (params != null) {
                kae.setPrincipal((String)params.get((Object)LoginParam.PRINCIPAL));
                kae.setKeytabFile((String)params.get((Object)LoginParam.KEYTAB));
                kae.setTicketCacheFile((String)params.get((Object)LoginParam.CCACHE));
            }
            throw kae;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Getting UGI for current user");
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.print();
        System.out.println("UGI: " + ugi);
        System.out.println("Auth method " + ugi.user.getAuthenticationMethod());
        System.out.println("Keytab " + ugi.isFromKeytab());
        System.out.println("============================================================");
        if (args.length == 2) {
            System.out.println("Getting UGI from keytab....");
            UserGroupInformation.loginUserFromKeytab(args[0], args[1]);
            UserGroupInformation.getCurrentUser().print();
            System.out.println("Keytab: " + ugi);
            UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
            System.out.println("Auth method " + loginUgi.getAuthenticationMethod());
            System.out.println("Keytab " + loginUgi.isFromKeytab());
        }
    }

    static {
        kerberosLoginRenewalExecutor = Optional.empty();
        loginUserRef = new AtomicReference();
        windows = System.getProperty("os.name").startsWith("Windows");
        OS_LOGIN_MODULE_NAME = UserGroupInformation.getOSLoginModuleName();
        OS_PRINCIPAL_CLASS = UserGroupInformation.getOsPrincipalClass();
    }

    @Metrics(about="User and group related metrics", context="ugi")
    static class UgiMetrics {
        final MetricsRegistry registry = new MetricsRegistry("UgiMetrics");
        @Metric(value={"Rate of successful kerberos logins and latency (milliseconds)"})
        MutableRate loginSuccess;
        @Metric(value={"Rate of failed kerberos logins and latency (milliseconds)"})
        MutableRate loginFailure;
        @Metric(value={"GetGroups"})
        MutableRate getGroups;
        MutableQuantiles[] getGroupsQuantiles;
        @Metric(value={"Renewal failures since startup"})
        private MutableGaugeLong renewalFailuresTotal;
        @Metric(value={"Renewal failures since last successful login"})
        private MutableGaugeInt renewalFailures;

        UgiMetrics() {
        }

        static UgiMetrics create() {
            return DefaultMetricsSystem.instance().register(new UgiMetrics());
        }

        static void reattach() {
            metrics = UgiMetrics.create();
        }

        void addGetGroups(long latency) {
            this.getGroups.add(latency);
            if (this.getGroupsQuantiles != null) {
                for (MutableQuantiles q : this.getGroupsQuantiles) {
                    q.add(latency);
                }
            }
        }

        MutableGaugeInt getRenewalFailures() {
            return this.renewalFailures;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum AuthenticationMethod {
        SIMPLE(SaslRpcServer.AuthMethod.SIMPLE, "hadoop-simple"),
        KERBEROS(SaslRpcServer.AuthMethod.KERBEROS, "hadoop-kerberos"),
        TOKEN(SaslRpcServer.AuthMethod.TOKEN),
        CERTIFICATE(null),
        KERBEROS_SSL(null),
        PROXY(null);

        private final SaslRpcServer.AuthMethod authMethod;
        private final String loginAppName;

        private AuthenticationMethod(SaslRpcServer.AuthMethod authMethod) {
            this(authMethod, null);
        }

        private AuthenticationMethod(SaslRpcServer.AuthMethod authMethod, String loginAppName) {
            this.authMethod = authMethod;
            this.loginAppName = loginAppName;
        }

        public SaslRpcServer.AuthMethod getAuthMethod() {
            return this.authMethod;
        }

        String getLoginAppName() {
            if (this.loginAppName == null) {
                throw new UnsupportedOperationException(this + " login authentication is not supported");
            }
            return this.loginAppName;
        }

        public static AuthenticationMethod valueOf(SaslRpcServer.AuthMethod authMethod) {
            for (AuthenticationMethod value : AuthenticationMethod.values()) {
                if (value.getAuthMethod() != authMethod) continue;
                return value;
            }
            throw new IllegalArgumentException("no authentication method for " + authMethod);
        }
    }

    private static class TestingGroups
    extends Groups {
        private final Map<String, Set<String>> userToGroupsMapping = new HashMap<String, Set<String>>();
        private Groups underlyingImplementation;

        private TestingGroups(Groups underlyingImplementation) {
            super(new Configuration());
            this.underlyingImplementation = underlyingImplementation;
        }

        @Override
        public List<String> getGroups(String user) throws IOException {
            return new ArrayList<String>(this.getGroupsSet(user));
        }

        @Override
        public Set<String> getGroupsSet(String user) throws IOException {
            Set<String> result = this.userToGroupsMapping.get(user);
            if (result == null) {
                result = this.underlyingImplementation.getGroupsSet(user);
            }
            return result;
        }

        private void setUserGroups(String user, String[] groups) {
            LinkedHashSet groupsSet = new LinkedHashSet();
            Collections.addAll(groupsSet, groups);
            this.userToGroupsMapping.put(user, groupsSet);
        }
    }

    @InterfaceAudience.Private
    public static class HadoopLoginModule
    implements LoginModule {
        private Subject subject;

        @Override
        public boolean abort() throws LoginException {
            return true;
        }

        private <T extends Principal> T getCanonicalUser(Class<T> cls) {
            Iterator<T> iterator = this.subject.getPrincipals(cls).iterator();
            if (iterator.hasNext()) {
                Principal user = (Principal)iterator.next();
                return (T)user;
            }
            return null;
        }

        @Override
        public boolean commit() throws LoginException {
            LOG.debug("hadoop login commit");
            if (!this.subject.getPrincipals(User.class).isEmpty()) {
                LOG.debug("Using existing subject: {}", this.subject.getPrincipals());
                return true;
            }
            Principal user = this.getCanonicalUser(KerberosPrincipal.class);
            if (user != null) {
                LOG.debug("Using kerberos user: {}", (Object)user);
            }
            if (!UserGroupInformation.isSecurityEnabled() && user == null) {
                String envUser = System.getenv(UserGroupInformation.HADOOP_USER_NAME);
                if (envUser == null) {
                    envUser = System.getProperty(UserGroupInformation.HADOOP_USER_NAME);
                }
                Principal principal = user = envUser == null ? null : new User(envUser);
            }
            if (user == null) {
                user = this.getCanonicalUser(OS_PRINCIPAL_CLASS);
                LOG.debug("Using local user: {}", (Object)user);
            }
            if (user != null) {
                LOG.debug("Using user: \"{}\" with name: {}", (Object)user, (Object)user.getName());
                User userEntry = null;
                try {
                    AuthenticationMethod authMethod = user instanceof KerberosPrincipal ? AuthenticationMethod.KERBEROS : AuthenticationMethod.SIMPLE;
                    userEntry = new User(user.getName(), authMethod, null);
                }
                catch (Exception e) {
                    throw (LoginException)new LoginException(e.toString()).initCause(e);
                }
                LOG.debug("User entry: \"{}\"", (Object)userEntry);
                this.subject.getPrincipals().add(userEntry);
                return true;
            }
            throw new LoginException("Failed to find user in name " + this.subject);
        }

        @Override
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            this.subject = subject;
        }

        @Override
        public boolean login() throws LoginException {
            LOG.debug("Hadoop login");
            return true;
        }

        @Override
        public boolean logout() throws LoginException {
            LOG.debug("Hadoop logout");
            return true;
        }
    }

    private static class HadoopLoginContext
    extends LoginContext {
        private final String appName;
        private final HadoopConfiguration conf;
        private AtomicBoolean isLoggedIn = new AtomicBoolean();

        HadoopLoginContext(String appName, Subject subject, HadoopConfiguration conf) throws LoginException {
            super(appName, subject, null, conf);
            this.appName = appName;
            this.conf = conf;
        }

        public boolean isLoginSuccess() {
            return this.isLoggedIn.get();
        }

        String getAppName() {
            return this.appName;
        }

        HadoopConfiguration getConfiguration() {
            return this.conf;
        }

        Object getSubjectLock() {
            Subject subject = this.getSubject();
            return subject == null ? this : subject.getPrivateCredentials();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void login() throws LoginException {
            Object object = this.getSubjectLock();
            synchronized (object) {
                MutableRate metric = UserGroupInformation.metrics.loginFailure;
                long start = Time.monotonicNow();
                try {
                    super.login();
                    this.isLoggedIn.set(true);
                    metric = UserGroupInformation.metrics.loginSuccess;
                }
                finally {
                    metric.add(Time.monotonicNow() - start);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void logout() throws LoginException {
            Object object = this.getSubjectLock();
            synchronized (object) {
                if (this.isLoggedIn.compareAndSet(true, false)) {
                    super.logout();
                }
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    private static class HadoopConfiguration
    extends javax.security.auth.login.Configuration {
        static final String KRB5_LOGIN_MODULE = KerberosUtil.getKrb5LoginModuleName();
        static final String SIMPLE_CONFIG_NAME = "hadoop-simple";
        static final String KERBEROS_CONFIG_NAME = "hadoop-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        static final AppConfigurationEntry OS_SPECIFIC_LOGIN;
        static final AppConfigurationEntry HADOOP_LOGIN;
        private final LoginParams params;

        HadoopConfiguration(LoginParams params) {
            this.params = params;
        }

        @Override
        public LoginParams getParameters() {
            return this.params;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            ArrayList<AppConfigurationEntry> entries = new ArrayList<AppConfigurationEntry>();
            if (this.params == null || appName.equals(SIMPLE_CONFIG_NAME)) {
                entries.add(OS_SPECIFIC_LOGIN);
            } else if (appName.equals(KERBEROS_CONFIG_NAME)) {
                if (!this.params.containsKey((Object)LoginParam.PRINCIPAL)) {
                    entries.add(OS_SPECIFIC_LOGIN);
                }
                entries.add(this.getKerberosEntry());
            }
            entries.add(HADOOP_LOGIN);
            return entries.toArray(new AppConfigurationEntry[0]);
        }

        private AppConfigurationEntry getKerberosEntry() {
            HashMap<String, String> options = new HashMap<String, String>(BASIC_JAAS_OPTIONS);
            AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            String principal = (String)this.params.get((Object)LoginParam.PRINCIPAL);
            if (principal != null) {
                options.put("principal", principal);
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            }
            if (PlatformName.IBM_JAVA) {
                if (this.params.containsKey((Object)LoginParam.KEYTAB)) {
                    String keytab = (String)this.params.get((Object)LoginParam.KEYTAB);
                    if (keytab != null) {
                        options.put("useKeytab", HadoopConfiguration.prependFileAuthority(keytab));
                    } else {
                        options.put("useDefaultKeytab", "true");
                    }
                    options.put("credsType", "both");
                } else {
                    String ticketCache = (String)this.params.get((Object)LoginParam.CCACHE);
                    if (ticketCache != null) {
                        options.put("useCcache", HadoopConfiguration.prependFileAuthority(ticketCache));
                    } else {
                        options.put("useDefaultCcache", "true");
                    }
                    options.put("renewTGT", "true");
                }
            } else {
                if (this.params.containsKey((Object)LoginParam.KEYTAB)) {
                    options.put("useKeyTab", "true");
                    String keytab = (String)this.params.get((Object)LoginParam.KEYTAB);
                    if (keytab != null) {
                        options.put("keyTab", keytab);
                    }
                    options.put("storeKey", "true");
                } else {
                    options.put("useTicketCache", "true");
                    String ticketCache = (String)this.params.get((Object)LoginParam.CCACHE);
                    if (ticketCache != null) {
                        options.put("ticketCache", ticketCache);
                    }
                    options.put("renewTGT", "true");
                }
                options.put("doNotPrompt", "true");
            }
            options.put("refreshKrb5Config", "true");
            return new AppConfigurationEntry(KRB5_LOGIN_MODULE, controlFlag, options);
        }

        private static String prependFileAuthority(String keytabPath) {
            return keytabPath.startsWith("file://") ? keytabPath : "file://" + keytabPath;
        }

        static {
            if ("true".equalsIgnoreCase(System.getenv("HADOOP_JAAS_DEBUG"))) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            OS_SPECIFIC_LOGIN = new AppConfigurationEntry(OS_LOGIN_MODULE_NAME, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, BASIC_JAAS_OPTIONS);
            HADOOP_LOGIN = new AppConfigurationEntry(HadoopLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, BASIC_JAAS_OPTIONS);
        }
    }

    private static class LoginParams
    extends EnumMap<LoginParam, String>
    implements Configuration.Parameters {
        LoginParams() {
            super(LoginParam.class);
        }

        @Override
        public String put(LoginParam param, String val) {
            boolean add = val != null && !this.containsKey((Object)param);
            return add ? super.put(param, val) : null;
        }

        static LoginParams getDefaults() {
            LoginParams params = new LoginParams();
            params.put(LoginParam.PRINCIPAL, System.getenv("KRB5PRINCIPAL"));
            params.put(LoginParam.KEYTAB, System.getenv("KRB5KEYTAB"));
            params.put(LoginParam.CCACHE, System.getenv("KRB5CCNAME"));
            return params;
        }
    }

    static enum LoginParam {
        PRINCIPAL,
        KEYTAB,
        CCACHE;

    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    final class TicketCacheRenewalRunnable
    extends AutoRenewalForUserCredsRunnable {
        private String kinitCmd;

        TicketCacheRenewalRunnable(KerberosTicket tgt, String kinitCmd, long nextRefresh) {
            super(tgt, nextRefresh);
            this.kinitCmd = kinitCmd;
        }

        @Override
        public void relogin() throws IOException {
            String output = Shell.execCommand(this.kinitCmd, "-R");
            LOG.debug("Renewed ticket. kinit output: {}", (Object)output);
            UserGroupInformation.this.reloginFromTicketCache();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    abstract class AutoRenewalForUserCredsRunnable
    implements Runnable {
        private KerberosTicket tgt;
        private RetryPolicy rp;
        private long nextRefresh;
        private boolean runRenewalLoop = true;

        AutoRenewalForUserCredsRunnable(KerberosTicket tgt, long nextRefresh) {
            this.tgt = tgt;
            this.nextRefresh = nextRefresh;
            this.rp = null;
        }

        public void setRunRenewalLoop(boolean runRenewalLoop) {
            this.runRenewalLoop = runRenewalLoop;
        }

        protected abstract void relogin() throws IOException;

        @Override
        public void run() {
            do {
                try {
                    long now = Time.now();
                    LOG.debug("Current time is {}, next refresh is {}", (Object)now, (Object)this.nextRefresh);
                    if (now < this.nextRefresh) {
                        Thread.sleep(this.nextRefresh - now);
                    }
                    this.relogin();
                    this.tgt = UserGroupInformation.this.getTGT();
                    if (this.tgt == null) {
                        LOG.warn("No TGT after renewal. Aborting renew thread for " + UserGroupInformation.this.getUserName());
                        return;
                    }
                    this.nextRefresh = Math.max(UserGroupInformation.this.getRefreshTime(this.tgt), now + kerberosMinSecondsBeforeRelogin);
                    UserGroupInformation.metrics.renewalFailures.set(0);
                    this.rp = null;
                }
                catch (InterruptedException ie) {
                    LOG.warn("Terminating renewal thread");
                    return;
                }
                catch (IOException ie) {
                    long tgtEndTime;
                    UserGroupInformation.metrics.renewalFailuresTotal.incr();
                    long now = Time.now();
                    if (this.tgt.isDestroyed()) {
                        LOG.error(String.format("TGT is destroyed. Aborting renew thread for %s.", UserGroupInformation.this.getUserName()), (Throwable)ie);
                        return;
                    }
                    try {
                        tgtEndTime = this.tgt.getEndTime().getTime();
                    }
                    catch (NullPointerException npe) {
                        LOG.error("NPE thrown while getting KerberosTicket endTime. Aborting renew thread for {}.", (Object)UserGroupInformation.this.getUserName(), (Object)ie);
                        return;
                    }
                    LOG.warn("Exception encountered while running the renewal command for {}. (TGT end time:{}, renewalFailures: {}, renewalFailuresTotal: {})", new Object[]{UserGroupInformation.this.getUserName(), tgtEndTime, UserGroupInformation.metrics.renewalFailures.value(), UserGroupInformation.metrics.renewalFailuresTotal.value(), ie});
                    if (this.rp == null) {
                        this.rp = RetryPolicies.exponentialBackoffRetry(62, kerberosMinSecondsBeforeRelogin, TimeUnit.MILLISECONDS);
                    }
                    try {
                        this.nextRefresh = UserGroupInformation.getNextTgtRenewalTime(tgtEndTime, now, this.rp);
                    }
                    catch (Exception e) {
                        LOG.error("Exception when calculating next tgt renewal time", (Throwable)e);
                        return;
                    }
                    UserGroupInformation.metrics.renewalFailures.incr();
                    if (now <= this.nextRefresh) continue;
                    LOG.error("TGT is expired. Aborting renew thread for {}.", (Object)UserGroupInformation.this.getUserName());
                    return;
                }
            } while (this.runRenewalLoop);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    final class KeytabRenewalRunnable
    extends AutoRenewalForUserCredsRunnable {
        KeytabRenewalRunnable(KerberosTicket tgt, long nextRefresh) {
            super(tgt, nextRefresh);
        }

        @Override
        public void relogin() throws IOException {
            UserGroupInformation.this.reloginFromKeytab();
        }
    }

    private static class RealUser
    implements Principal {
        private final UserGroupInformation realUser;

        RealUser(UserGroupInformation realUser) {
            this.realUser = realUser;
        }

        @Override
        public String getName() {
            return this.realUser.getUserName();
        }

        public UserGroupInformation getRealUser() {
            return this.realUser;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.realUser.equals(((RealUser)o).realUser);
        }

        @Override
        public int hashCode() {
            return this.realUser.hashCode();
        }

        @Override
        public String toString() {
            return this.realUser.toString();
        }
    }
}

