/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DSQuotaExceededException
extends QuotaExceededException {
    protected static final long serialVersionUID = 1L;

    public DSQuotaExceededException() {
    }

    public DSQuotaExceededException(String msg) {
        super(msg);
    }

    public DSQuotaExceededException(long quota, long count) {
        super(quota, count);
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            return "The DiskSpace quota" + (String)(this.pathName == null ? "" : " of " + this.pathName) + " is exceeded: quota = " + this.quota + " B = " + StringUtils.TraditionalBinaryPrefix.long2String(this.quota, "B", 2) + " but diskspace consumed = " + this.count + " B = " + StringUtils.TraditionalBinaryPrefix.long2String(this.count, "B", 2);
        }
        return msg;
    }
}

